/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import fabric.cn.zbx1425.worldcomment.data.network.ImageDownload;
import fabric.cn.zbx1425.worldcomment.gui.CommentTypeButton;
import fabric.cn.zbx1425.worldcomment.gui.IGuiCommon;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class WidgetCommentEntry
extends class_339
implements IGuiCommon {
    private final CommentEntry comment;
    private final class_327 font;
    private List<class_5481> wrappedText = List.of();
    public boolean showImage = true;
    public static final int TOP_SINK = 12;

    public WidgetCommentEntry(CommentEntry comment) {
        super(0, 0, 0, 0, (class_2561)class_2561.method_43470((String)comment.message));
        this.comment = comment;
        this.font = class_310.method_1551().field_1772;
        this.calculateHeight();
    }

    public void setBounds(int x, int y, int width) {
        this.method_46421(x);
        this.method_46419(y);
        this.method_25358(width);
        this.calculateHeight();
    }

    private void calculateHeight() {
        int picWidth = this.comment.image.url.isEmpty() || !this.showImage ? 0 : (this.field_22758 - 20) / 3;
        int textWidth = this.field_22758 - 20 - picWidth - (picWidth > 0 ? 4 : 0);
        this.wrappedText = class_2477.method_10517().method_30933(this.font.method_27527().method_27498(this.comment.message, textWidth, class_2583.field_24360));
        int textHeight = 26 + (this.comment.message.isEmpty() ? 0 : 9 * this.wrappedText.size()) + 4;
        int picHeight = 20 + (this.comment.image.url.isEmpty() || !this.showImage ? 0 : picWidth * 9 / 16) + 4 + 4;
        this.field_22759 = Math.max(Math.max(textHeight, picHeight), 32);
    }

    protected void method_48579(class_332 guiParam, int mouseX, int mouseY, float partialTick) {
        class_5250 nameComponent;
        class_332 guiGraphics = guiParam;
        this.graphicsBlit9(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 0, 0, 128, 48, 256, 256, 24, 4, 4, 28);
        int picWidth = this.comment.image.url.isEmpty() || !this.showImage ? 0 : (this.field_22758 - 20) / 3;
        int picHeight = (this.comment.image.url.isEmpty() || !this.showImage ? 0 : picWidth * 9 / 16) + 4;
        if (!this.comment.message.isEmpty()) {
            int lineY = this.method_46427() + 26;
            for (class_5481 formattedCharSequence : this.wrappedText) {
                guiGraphics.method_51430(this.font, formattedCharSequence, this.method_46426() + 16, lineY, -12303292, false);
                Objects.requireNonNull(this.font);
                lineY += 9;
            }
        }
        if (!this.comment.image.url.isEmpty() && this.showImage) {
            ImageDownload.ImageState imageToDraw = ImageDownload.getTexture(this.comment.image, true);
            RenderSystem.setShaderTexture((int)0, (int)imageToDraw.getFriendlyTexture(class_310.method_1551().method_1531()).method_4624());
            RenderSystem.setShader(class_757::method_34542);
            Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            int x1 = this.method_46426() + this.field_22758 - 4 - picWidth;
            int x2 = this.method_46426() + this.field_22758 - 4;
            int y1 = this.method_46427() + 20;
            int y2 = this.method_46427() + 20 + picHeight;
            bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, 0.0f).method_22913(0.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, 0.0f).method_22913(0.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_22913(1.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, 0.0f).method_22913(1.0f, 0.0f).method_1344();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
        class_5250 class_52502 = nameComponent = this.comment.initiatorName.isEmpty() ? class_2561.method_43471((String)"gui.worldcomment.anonymous") : class_2561.method_43470((String)this.comment.initiatorName);
        Object uuidToDisplay = this.comment.initiatorName.isEmpty() ? (class_310.method_1551().field_1724.method_5687(3) ? this.comment.initiator.toString() : "") : "..." + this.comment.initiator.toString().substring(24);
        guiGraphics.method_51439(this.font, (class_2561)nameComponent, this.method_46426() + 34, this.method_46427() + 8, -1, true);
        if (this.showImage) {
            String timeStr = DateTimeFormatter.ofPattern("MM-dd HH:mm", Locale.ROOT).format(Instant.ofEpochMilli(this.comment.timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime());
            guiGraphics.method_51433(this.font, timeStr, this.method_46426() + this.method_25368() - 6 - this.font.method_1727(timeStr), this.method_46427() + 8, -4473925, true);
        }
        RenderSystem.enableBlend();
        guiGraphics.method_25293(ATLAS_LOCATION, this.method_46426() + 6, this.method_46427() + 2, 18, 18, (float)((this.comment.messageType - 1) % 4 * 64), (float)((this.comment.messageType - 1) / 4 * 64 + 128), 64, 64, 256, 256);
        if (mouseX > this.method_46426() + 4 && mouseX < this.method_46426() + this.method_25368() && mouseY > this.method_46427() && mouseY < this.method_46427() + 24) {
            guiGraphics.method_51437(this.font, List.of(class_2561.method_43471((String)("gui.worldcomment.comment_type." + this.comment.messageType)).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(CommentTypeButton.COMMENT_TYPE_COLOR[this.comment.messageType - 1] & 0xFFFFFF)).method_10852((class_2561)class_2561.method_43470((String)("  (" + this.comment.location.method_23854() + ")")).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1068))), class_2561.method_43470((String)("  " + Instant.ofEpochMilli(this.comment.timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME))).method_27696(class_2583.field_24360.method_10977(class_124.field_1080)), class_2561.method_43470((String)("  " + nameComponent.getString() + " " + (String)uuidToDisplay)).method_27696(class_2583.field_24360.method_10977(class_124.field_1080))), Optional.empty(), mouseX, mouseY);
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

