/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.interop;

import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import fabric.cn.zbx1425.worldcomment.data.client.ClientWorldData;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_310;

public class ProximityCommentSet {
    public final double distanceSqr;
    public final long timeToLive;
    public final Object2LongMap<CommentEntry> comments = new Object2LongOpenHashMap();
    public Consumer<CommentEntry> onCommentApproach;

    public ProximityCommentSet(double distance, long timeToLive) {
        this.distanceSqr = distance * distance;
        this.timeToLive = timeToLive;
    }

    public void tick(ClientWorldData worldData) {
        class_310 minecraft = class_310.method_1551();
        long currentTime = System.currentTimeMillis();
        class_2338 playerPos = minecraft.field_1724.method_24515();
        for (Map region : ClientWorldData.INSTANCE.regions.values()) {
            for (Map.Entry blockData : region.entrySet()) {
                for (CommentEntry comment2 : (List)blockData.getValue()) {
                    if (comment2.deleted || !(comment2.location.method_10262((class_2382)playerPos) <= this.distanceSqr)) continue;
                    if (!this.comments.containsKey((Object)comment2) && this.onCommentApproach != null) {
                        this.onCommentApproach.accept(comment2);
                    }
                    this.comments.put((Object)comment2, currentTime + this.timeToLive);
                }
            }
        }
        this.comments.keySet().removeIf(comment -> this.comments.getLong(comment) < currentTime);
    }

    public void clear() {
        this.comments.clear();
    }
}

