/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.network;

public class ChunkCollector {
    private final byte[] completeData;
    private int receivedChunks = 0;
    private final int totalChunks;
    private final long timestamp;

    public ChunkCollector(int totalSize, int totalChunks, long timestamp) {
        this.completeData = new byte[totalSize];
        this.totalChunks = totalChunks;
        this.timestamp = timestamp;
    }

    public ChunkCollector(int totalSize, int totalChunks) {
        this(totalSize, totalChunks, 0L);
    }

    public boolean addChunk(int chunkIndex, byte[] chunkData, int offset) {
        System.arraycopy(chunkData, 0, this.completeData, offset, chunkData.length);
        ++this.receivedChunks;
        return this.receivedChunks == this.totalChunks;
    }

    public byte[] getCompleteData() {
        return this.completeData;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

