/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.network;

import fabric.cn.zbx1425.worldcomment.ClientPlatform;
import fabric.cn.zbx1425.worldcomment.Main;
import fabric.cn.zbx1425.worldcomment.network.PacketImageDownloadS2C;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class PacketImageDownloadC2S {
    public static final class_2960 IDENTIFIER = Main.id("image_download");

    public static void handle(MinecraftServer server, class_3222 initiator, class_2540 buffer) {
        String fileName = buffer.method_19772();
        try {
            Path imageDir = server.method_27050(class_5218.field_24188).resolve("world-comment").resolve("image").normalize();
            Path imagePath = imageDir.resolve(fileName).normalize();
            if (!imagePath.startsWith(imageDir)) {
                Main.LOGGER.warn("Rejected path traversal: {}", (Object)fileName);
                PacketImageDownloadS2C.sendNotFound(initiator, fileName);
                return;
            }
            if (Files.exists(imagePath, new LinkOption[0])) {
                byte[] imageData = Files.readAllBytes(imagePath);
                PacketImageDownloadS2C.send(initiator, fileName, imageData);
            } else {
                PacketImageDownloadS2C.sendNotFound(initiator, fileName);
            }
        }
        catch (IOException e) {
            Main.LOGGER.error("Failed to read image file", (Throwable)e);
        }
    }

    public static class ClientLogics {
        public static void send(String fileName) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.method_10814(fileName);
            ClientPlatform.sendPacketToServer(IDENTIFIER, buffer);
        }
    }
}

