/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.render;

import fabric.cn.zbx1425.worldcomment.MainClient;
import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import fabric.cn.zbx1425.worldcomment.data.client.ClientRayPicking;
import fabric.cn.zbx1425.worldcomment.gui.IGuiCommon;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;

public class CommentWorldRenderer
implements IGuiCommon {
    private static final Random RANDOM = new Random();

    public static void renderComment(class_4588 vertices, class_4587 matrices, CommentEntry comment, boolean focused, boolean showIcon) {
        class_310 minecraft = class_310.method_1551();
        class_243 cameraPos = minecraft.field_1719.method_19538();
        RANDOM.setSeed(comment.id);
        matrices.method_22903();
        matrices.method_46416((float)comment.location.method_10263() + 0.5f, (float)comment.location.method_10264() + 1.8f, (float)comment.location.method_10260() + 0.5f);
        float cycleRotateLength = 8000.0f;
        float cycleRotateX = (float)((System.currentTimeMillis() + RANDOM.nextLong(0L, (long)cycleRotateLength)) % (long)cycleRotateLength) / cycleRotateLength;
        float cycleRotateY = (float)Math.sin((double)cycleRotateX * Math.PI * 2.0) / 2.0f + 0.5f;
        float cycleHoverLength = focused ? 1000.0f : 8000.0f;
        float cycleHoverX = (float)((System.currentTimeMillis() + RANDOM.nextLong(0L, (long)cycleHoverLength)) % (long)cycleHoverLength) / cycleHoverLength;
        float cycleHoverY = (float)Math.sin((double)cycleHoverX * Math.PI * 2.0) / 2.0f + 0.5f;
        matrices.method_22904((double)RANDOM.nextFloat(-0.3f, 0.3f), (double)cycleHoverY * 0.1, (double)RANDOM.nextFloat(-0.3f, 0.3f));
        float yaw = (float)class_3532.method_15349((double)((double)comment.location.method_10263() + 0.5 - cameraPos.method_10216()), (double)((double)comment.location.method_10260() + 0.5 - cameraPos.method_10215()));
        matrices.method_22907(class_7833.field_40716.rotation(yaw + cycleRotateY * 0.1308997f));
        matrices.method_22905(0.9f, 0.9f, 0.9f);
        float u1 = 0.5f;
        float v1 = 0.0f;
        float u2 = u1 + 0.125f - 0.00390625f;
        float v2 = v1 + 0.375f;
        class_4587.class_4665 pose = matrices.method_23760();
        CommentWorldRenderer.vertex(vertices, pose, 0.5f, 1.0f, 0.0f, u1, v1);
        CommentWorldRenderer.vertex(vertices, pose, 0.5f, -2.0f, 0.0f, u1, v2);
        CommentWorldRenderer.vertex(vertices, pose, -0.5f, -2.0f, 0.0f, u2, v2);
        CommentWorldRenderer.vertex(vertices, pose, -0.5f, 1.0f, 0.0f, u2, v1);
        if (showIcon) {
            matrices.method_46416(0.0f, 0.25f, 0.0f);
            matrices.method_22905(0.5f, 0.5f, 0.5f);
            u1 = (float)((comment.messageType - 1) % 4) * 0.25f;
            v1 = (float)((comment.messageType - 1) / 4) * 0.25f + 0.5f;
            u2 = u1 + 0.25f;
            v2 = v1 + 0.25f;
            pose = matrices.method_23760();
            CommentWorldRenderer.vertex(vertices, pose, 0.5f, 1.0f, -0.05f, u1, v1);
            CommentWorldRenderer.vertex(vertices, pose, 0.5f, 0.0f, -0.05f, u1, v2);
            CommentWorldRenderer.vertex(vertices, pose, -0.5f, 0.0f, -0.05f, u2, v2);
            CommentWorldRenderer.vertex(vertices, pose, -0.5f, 1.0f, -0.05f, u2, v1);
        }
        matrices.method_22909();
    }

    private static void vertex(class_4588 vertices, class_4587.class_4665 pose, float x, float y, float z, float u, float v) {
        vertices.method_22918(pose.method_23761(), x, y, z).method_39415(-1).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(pose.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
    }

    public static void renderComments(class_4597 buffers, class_4587 matrices) {
        long currentTime = System.currentTimeMillis();
        class_4588 vertices = buffers.getBuffer(class_1921.method_23689((class_2960)ATLAS_LOCATION));
        for (Map.Entry<class_2338, List<CommentEntry>> blockData : ClientRayPicking.visibleComments.entrySet()) {
            for (int i = 0; i < blockData.getValue().size(); ++i) {
                CommentEntry comment = blockData.getValue().get(i);
                boolean isVisible = MainClient.CLIENT_CONFIG.isCommentVisible(class_310.method_1551(), comment);
                if (!isVisible) continue;
                boolean showIcon = blockData.getValue().size() < 2 || currentTime / 1000L % (long)blockData.getValue().size() == (long)i;
                CommentWorldRenderer.renderComment(vertices, matrices, comment, ClientRayPicking.pickedComments.contains(comment), showIcon);
            }
        }
    }
}

