/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.render;

import fabric.cn.zbx1425.worldcomment.data.client.ClientRayPicking;
import fabric.cn.zbx1425.worldcomment.data.client.Screenshot;
import fabric.cn.zbx1425.worldcomment.gui.IGuiCommon;
import fabric.cn.zbx1425.worldcomment.item.CommentToolItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class ControlTipRenderer
implements IGuiCommon {
    public static final ControlTip TIP_CREATE = new ControlTip((class_2561)class_2561.method_43471((String)"gui.worldcomment.control_tip.create"), 2, class_310.method_1551().field_1690.field_1835, false, true);
    public static final ControlTip TIP_PLACE_COMMENT = new ControlTip((class_2561)class_2561.method_43471((String)"gui.worldcomment.control_tip.place_comment"), 0, null, true, true);
    public static final ControlTip TIP_TOGGLE_SHOW = new ControlTip(() -> class_2561.method_43469((String)"gui.worldcomment.control_tip.toggle_show", (Object[])new Object[]{String.format("%02d:%02d", (int)Math.floor(CommentToolItem.invisibleTimeRemaining / 20.0f / 60.0f), (int)Math.floor(CommentToolItem.invisibleTimeRemaining / 20.0f % 60.0f))}), 0, null, true);
    public static final ControlTip TIP_TOGGLE_HIDE = new ControlTip((class_2561)class_2561.method_43471((String)"gui.worldcomment.control_tip.toggle_hide"), 0, null, false);
    public static final ControlTip TIP_VIEW_MANAGE = new ControlTip((class_2561)class_2561.method_43471((String)"gui.worldcomment.control_tip.view_manage"), 2, class_310.method_1551().field_1690.field_1824, false);
    public static final ControlTip TIP_DETAIL = new ControlTip((class_2561)class_2561.method_43471((String)"gui.worldcomment.control_tip.detail"), 2, class_310.method_1551().field_1690.field_1907, false);
    public static final ControlTip TIP_SCROLL = new ControlTip((class_2561)class_2561.method_43471((String)"gui.worldcomment.control_tip.scroll"), 1, null, false);
    public static final List<ControlTip> TIPS = List.of(TIP_PLACE_COMMENT, TIP_TOGGLE_SHOW, TIP_TOGGLE_HIDE, TIP_CREATE, TIP_VIEW_MANAGE, TIP_SCROLL, TIP_DETAIL);

    public static void render(class_332 guiGraphics) {
        ControlTipRenderer.update();
        int yOffset = 10;
        for (ControlTip tip : TIPS) {
            if (!tip.visible) continue;
            tip.render(guiGraphics, 10, yOffset);
            if (tip.atCursor) continue;
            yOffset += 22;
        }
    }

    public static void update() {
        class_310 minecraft = class_310.method_1551();
        for (ControlTip tip : TIPS) {
            tip.visible = false;
        }
        if (minecraft.field_1724 == null) {
            return;
        }
        if (Screenshot.isGrabbing) {
            return;
        }
        class_1799 item = CommentToolItem.Client.getHoldingCommentTool();
        if (item != null) {
            if (CommentToolItem.getUploadJobId(item) != null) {
                ControlTipRenderer.TIP_PLACE_COMMENT.visible = true;
            } else {
                ControlTipRenderer.TIP_CREATE.visible = true;
                if (CommentToolItem.getVisibilityPreference()) {
                    ControlTipRenderer.TIP_TOGGLE_HIDE.visible = true;
                } else {
                    ControlTipRenderer.TIP_TOGGLE_SHOW.visible = true;
                }
            }
            ControlTipRenderer.TIP_VIEW_MANAGE.visible = true;
        }
        if (!ClientRayPicking.pickedComments.isEmpty()) {
            if (ClientRayPicking.pickedComments.size() > 1) {
                ControlTipRenderer.TIP_SCROLL.visible = true;
            }
            ControlTipRenderer.TIP_DETAIL.visible = true;
        }
    }

    public static class ControlTip {
        public final int imgIndex;
        public final class_304 key;
        public final boolean critical;
        public final boolean atCursor;
        public final Supplier<class_2561> text;
        public boolean visible = false;

        public ControlTip(class_2561 text, int imgIndex, class_304 key, boolean critical) {
            this.text = () -> text;
            this.imgIndex = imgIndex;
            this.key = key;
            this.critical = critical;
            this.atCursor = false;
        }

        public ControlTip(class_2561 text, int imgIndex, class_304 key, boolean critical, boolean atCursor) {
            this.text = () -> text;
            this.imgIndex = imgIndex;
            this.key = key;
            this.critical = critical;
            this.atCursor = atCursor;
        }

        public ControlTip(Supplier<class_2561> text, int imgIndex, class_304 key, boolean critical) {
            this.text = text;
            this.imgIndex = imgIndex;
            this.key = key;
            this.critical = critical;
            this.atCursor = false;
        }

        public void render(class_332 guiGraphics, int x, int y) {
            long currentTime;
            class_327 font = class_310.method_1551().field_1772;
            int innerWidth = 24 + font.method_27525((class_5348)this.text.get());
            if (this.atCursor) {
                x = guiGraphics.method_51421() / 2 - innerWidth / 2;
                y = guiGraphics.method_51443() / 2 - 20 - 4;
            }
            if (this.critical && (currentTime = System.currentTimeMillis()) % 400L < 200L) {
                guiGraphics.method_25294(x + 1, y + 1, x + innerWidth + 4 + 1, y + 20 + 1, -12303292);
                guiGraphics.method_25294(x, y, x + innerWidth + 4, y + 20, -2237082);
            }
            guiGraphics.method_25293(IGuiCommon.ATLAS_LOCATION, x, y, 20, 20, (float)(176 + this.imgIndex * 20), 0.0f, 20, 20, 256, 256);
            if (this.key != null) {
                class_2561 keyMessage = this.key.method_16007();
                int keyMessageWidth = font.method_27525((class_5348)keyMessage);
                if (keyMessageWidth < 30) {
                    guiGraphics.method_27534(font, keyMessage, x + 10, y + 10 - 4, -4941);
                } else {
                    guiGraphics.method_44379(x, y, x + 20, y + 20);
                    int xOffset = (int)(System.currentTimeMillis() / 50L % (long)(keyMessageWidth + 40));
                    guiGraphics.method_27535(font, keyMessage, x - xOffset + 20, y + 10 - 4, -4941);
                    guiGraphics.method_44380();
                }
            }
            guiGraphics.method_51439(font, this.text.get(), x + 20 + 4, y + 10 - 4, -1, true);
        }
    }
}

