/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment;

import forge.cn.zbx1425.worldcomment.ServerConfig;
import forge.cn.zbx1425.worldcomment.ServerPlatform;
import forge.cn.zbx1425.worldcomment.data.ServerWorldData;
import forge.cn.zbx1425.worldcomment.data.sync.RedisSynchronizer;
import forge.cn.zbx1425.worldcomment.item.CommentEyeglassItem;
import forge.cn.zbx1425.worldcomment.item.CommentToolItem;
import forge.cn.zbx1425.worldcomment.network.PacketClientConfigS2C;
import forge.cn.zbx1425.worldcomment.network.PacketCollectionDataS2C;
import forge.cn.zbx1425.worldcomment.network.PacketCollectionRequestC2S;
import forge.cn.zbx1425.worldcomment.network.PacketEntryActionC2S;
import forge.cn.zbx1425.worldcomment.network.PacketEntryCreateC2S;
import forge.cn.zbx1425.worldcomment.network.PacketEntryUpdateS2C;
import forge.cn.zbx1425.worldcomment.network.PacketImageDownloadC2S;
import forge.cn.zbx1425.worldcomment.network.PacketImageDownloadS2C;
import forge.cn.zbx1425.worldcomment.network.PacketImageUploadC2S;
import forge.cn.zbx1425.worldcomment.network.PacketImageUploadS2C;
import forge.cn.zbx1425.worldcomment.network.PacketRegionDataS2C;
import forge.cn.zbx1425.worldcomment.network.PacketRegionRequestC2S;
import forge.cn.zbx1425.worldcomment.util.RegistriesWrapper;
import forge.cn.zbx1425.worldcomment.util.RegistryObject;
import java.io.IOException;
import java.net.http.HttpClient;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static final String MOD_ID = "worldcomment";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Subnoteica");
    public static ServerWorldData DATABASE;
    public static ServerConfig SERVER_CONFIG;
    public static final HttpClient HTTP_CLIENT;
    public static final Executor IO_EXECUTOR;
    public static final RegistryObject<CommentToolItem> ITEM_COMMENT_TOOL;
    public static final RegistryObject<CommentEyeglassItem> ITEM_COMMENT_EYEGLASS;

    public static void init(RegistriesWrapper registries) {
        registries.registerItem("comment_tool", ITEM_COMMENT_TOOL);
        registries.registerItem("comment_eyeglass", ITEM_COMMENT_EYEGLASS);
        ServerPlatform.registerPacket(PacketClientConfigS2C.IDENTIFIER);
        ServerPlatform.registerPacket(PacketCollectionDataS2C.IDENTIFIER);
        ServerPlatform.registerPacket(PacketCollectionRequestC2S.IDENTIFIER);
        ServerPlatform.registerPacket(PacketEntryActionC2S.IDENTIFIER);
        ServerPlatform.registerPacket(PacketEntryCreateC2S.IDENTIFIER);
        ServerPlatform.registerPacket(PacketEntryUpdateS2C.IDENTIFIER);
        ServerPlatform.registerPacket(PacketRegionDataS2C.IDENTIFIER);
        ServerPlatform.registerPacket(PacketRegionRequestC2S.IDENTIFIER);
        ServerPlatform.registerPacket(PacketImageUploadC2S.IDENTIFIER);
        ServerPlatform.registerPacket(PacketImageUploadS2C.IDENTIFIER);
        ServerPlatform.registerPacket(PacketImageDownloadC2S.IDENTIFIER);
        ServerPlatform.registerPacket(PacketImageDownloadS2C.IDENTIFIER);
        ServerPlatform.registerNetworkReceiver(PacketRegionRequestC2S.IDENTIFIER, PacketRegionRequestC2S::handle);
        ServerPlatform.registerNetworkReceiver(PacketCollectionRequestC2S.IDENTIFIER, PacketCollectionRequestC2S::handle);
        ServerPlatform.registerNetworkReceiver(PacketEntryCreateC2S.IDENTIFIER, PacketEntryCreateC2S::handle);
        ServerPlatform.registerNetworkReceiver(PacketEntryActionC2S.IDENTIFIER, PacketEntryActionC2S::handle);
        ServerPlatform.registerNetworkReceiver(PacketImageUploadC2S.IDENTIFIER, PacketImageUploadC2S::handle);
        ServerPlatform.registerNetworkReceiver(PacketImageDownloadC2S.IDENTIFIER, PacketImageDownloadC2S::handle);
        ServerPlatform.registerServerStartingEvent(server -> {
            try {
                SERVER_CONFIG.load(server.m_6237_().toPath().resolve("config").resolve("world-comment.json"));
                DATABASE = new ServerWorldData((MinecraftServer)server, Main.SERVER_CONFIG.syncRole.value.equalsIgnoreCase("host"));
                if (!Main.SERVER_CONFIG.redisUrl.value.isEmpty()) {
                    Main.DATABASE.peerChannel = new RedisSynchronizer(Main.SERVER_CONFIG.redisUrl.value, DATABASE);
                }
                DATABASE.load();
            }
            catch (IOException e) {
                LOGGER.error("Failed to open data storage", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
        ServerPlatform.registerServerStoppingEvent(server -> {
            try {
                Main.DATABASE.peerChannel.close();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to close database peerChannel", (Throwable)ex);
            }
        });
        ServerPlatform.registerPlayerJoinEvent(player -> PacketClientConfigS2C.send(player, SERVER_CONFIG));
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation vanillaId(String path) {
        return new ResourceLocation(path);
    }

    static {
        SERVER_CONFIG = new ServerConfig();
        HTTP_CLIENT = HttpClient.newHttpClient();
        IO_EXECUTOR = Executors.newCachedThreadPool();
        ITEM_COMMENT_TOOL = new RegistryObject<CommentToolItem>(CommentToolItem::new);
        ITEM_COMMENT_EYEGLASS = new RegistryObject<CommentEyeglassItem>(CommentEyeglassItem::new);
    }
}

