/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment;

import com.google.common.base.CaseFormat;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import forge.cn.zbx1425.worldcomment.Main;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class ServerConfig {
    public ConfigItem redisUrl;
    public ConfigItem syncRole;
    public ConfigItem uplinkUrl;
    public ConfigItem uplinkAuthKey;
    public ConfigItem imageUploadConfig;
    public ConfigItem allowMarkerUsage;
    public ConfigItem commentVisibilityCriteria;
    public ConfigItem markerVisibilityCriteria;
    public ConfigItem imageGlobalKill;
    private Path path;

    public void load(Path configPath) throws IOException {
        JsonObject json = Files.exists(configPath, new LinkOption[0]) ? JsonParser.parseString((String)Files.readString(configPath)).getAsJsonObject() : new JsonObject();
        this.redisUrl = new ConfigItem(json, "redisUrl", "");
        this.syncRole = new ConfigItem(json, "syncRole", "host");
        this.uplinkUrl = new ConfigItem(json, "uplinkUrl", "");
        this.uplinkAuthKey = new ConfigItem(json, "uplinkAuthKey", "");
        this.imageUploadConfig = new ConfigItem(json, "imageUploadConfig", "");
        this.allowMarkerUsage = new ConfigItem(json, "allowMarkerUsage", "creative");
        this.commentVisibilityCriteria = new ConfigItem(json, "commentVisibilityCriteria", "tool_toggle");
        this.markerVisibilityCriteria = new ConfigItem(json, "markerVisibilityCriteria", "always");
        this.imageGlobalKill = new ConfigItem(json, "imageGlobalKill", "false");
        this.path = configPath;
        if (!Files.exists(configPath, new LinkOption[0])) {
            this.save(configPath);
        }
    }

    public void save(Path configPath) throws IOException {
        JsonObject json = new JsonObject();
        this.redisUrl.writeJson(json);
        this.syncRole.writeJson(json);
        this.uplinkUrl.writeJson(json);
        this.uplinkAuthKey.writeJson(json);
        this.imageUploadConfig.writeJson(json);
        this.allowMarkerUsage.writeJson(json);
        this.commentVisibilityCriteria.writeJson(json);
        this.markerVisibilityCriteria.writeJson(json);
        this.imageGlobalKill.writeJson(json);
        Files.writeString(configPath, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json), new OpenOption[0]);
    }

    public void save() throws IOException {
        this.save(this.path);
    }

    public List<JsonObject> parseUploaderConfig() {
        ArrayList<JsonObject> uploaderConfigs = new ArrayList<JsonObject>();
        try {
            JsonElement rootElement = JsonParser.parseString((String)this.imageUploadConfig.value);
            if (rootElement.isJsonArray()) {
                for (JsonElement element : rootElement.getAsJsonArray()) {
                    uploaderConfigs.add(element.getAsJsonObject());
                }
            } else if (rootElement.isJsonObject()) {
                uploaderConfigs.add(rootElement.getAsJsonObject());
            }
        }
        catch (Exception ex) {
            Main.LOGGER.error("Failed to parse image upload config", (Throwable)ex);
        }
        return uploaderConfigs;
    }

    public static class ConfigItem {
        private final String camelKey;
        public String value;
        public boolean isFromJson;

        public ConfigItem(JsonObject jsonObject, String camelKey, String defaultValue) {
            String snakeKey = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, camelKey);
            this.camelKey = camelKey;
            if (System.getenv("SUBNOTEICA_" + snakeKey) != null) {
                this.value = System.getenv("SUBNOTEICA_" + snakeKey);
                this.isFromJson = false;
            } else if (jsonObject.has(camelKey)) {
                this.value = jsonObject.get(camelKey).isJsonArray() || jsonObject.get(camelKey).isJsonObject() ? jsonObject.get(camelKey).toString() : jsonObject.get(camelKey).getAsString();
                this.isFromJson = true;
            } else {
                this.value = defaultValue;
                this.isFromJson = false;
            }
        }

        public void writeJson(JsonObject jsonObject) {
            if (this.isFromJson) {
                jsonObject.addProperty(this.camelKey, this.value);
            }
        }
    }
}

