/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data;

import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;

public class CommentCache {
    Map<ResourceLocation, Long2ObjectMap<List<CommentEntry>>> regionIndex = new HashMap<ResourceLocation, Long2ObjectMap<List<CommentEntry>>>();
    Map<UUID, List<CommentEntry>> playerIndex = new HashMap<UUID, List<CommentEntry>>();
    Long2ObjectSortedMap<CommentEntry> timeIndex = new Long2ObjectAVLTreeMap(Comparator.reverseOrder());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRegion(ResourceLocation dimension, long region, byte[] data, boolean fromFile) {
        CommentCache commentCache = this;
        synchronized (commentCache) {
            ArrayList<CommentEntry> regionEntries = new ArrayList<CommentEntry>();
            FriendlyByteBuf src = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
            while (src.readerIndex() < data.length) {
                CommentEntry entry = new CommentEntry(dimension, src, fromFile);
                if (entry.deleted) continue;
                regionEntries.add(entry);
                this.playerIndex.computeIfAbsent(entry.initiator, ignored -> new ArrayList()).add(entry);
                this.timeIndex.put(entry.timestamp, (Object)entry);
            }
            this.regionIndex.computeIfAbsent(dimension, ignored -> new Long2ObjectOpenHashMap()).put(region, regionEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommentEntry> queryRegion(ResourceLocation level, ChunkPos region) {
        CommentCache commentCache = this;
        synchronized (commentCache) {
            return (List)this.regionIndex.getOrDefault(level, (Long2ObjectMap<List<CommentEntry>>)Long2ObjectMaps.emptyMap()).getOrDefault(region.m_45588_(), List.of());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommentEntry> queryPlayer(UUID player) {
        CommentCache commentCache = this;
        synchronized (commentCache) {
            return this.playerIndex.getOrDefault(player, List.of());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommentEntry> queryLatest(int offset, int count) {
        CommentCache commentCache = this;
        synchronized (commentCache) {
            ArrayList<CommentEntry> result = new ArrayList<CommentEntry>();
            for (CommentEntry comment : this.timeIndex.values()) {
                if (comment.deleted) continue;
                if (offset > 0) {
                    --offset;
                    continue;
                }
                if (count <= 0) break;
                result.add(comment);
                --count;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(CommentEntry newEntry) {
        CommentCache commentCache = this;
        synchronized (commentCache) {
            ((List)this.regionIndex.computeIfAbsent(newEntry.level, ignored -> new Long2ObjectOpenHashMap()).computeIfAbsent(newEntry.region.m_45588_(), ignored -> new ArrayList())).add(newEntry);
            this.playerIndex.computeIfAbsent(newEntry.initiator, ignored -> new ArrayList()).add(newEntry);
            this.timeIndex.put(newEntry.timestamp, (Object)newEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommentEntry update(CommentEntry newEntry) {
        CommentCache commentCache = this;
        synchronized (commentCache) {
            List regionData = (List)this.regionIndex.getOrDefault(newEntry.level, (Long2ObjectMap<List<CommentEntry>>)Long2ObjectMaps.emptyMap()).get(newEntry.region.m_45588_());
            if (regionData == null) {
                return null;
            }
            for (CommentEntry existingEntry : regionData) {
                if (existingEntry.id != newEntry.id) continue;
                existingEntry.deleted = newEntry.deleted;
                existingEntry.uplinkSent = newEntry.uplinkSent;
                existingEntry.like = newEntry.like;
                assert (existingEntry.fileOffset > 0L);
                return existingEntry;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommentEntry> updateAllFields(CommentEntry newEntry) {
        CommentCache commentCache = this;
        synchronized (commentCache) {
            List regionData = (List)this.regionIndex.getOrDefault(newEntry.level, (Long2ObjectMap<List<CommentEntry>>)Long2ObjectMaps.emptyMap()).get(newEntry.region.m_45588_());
            if (regionData == null) {
                return null;
            }
            for (CommentEntry existingEntry : regionData) {
                if (existingEntry.id != newEntry.id) continue;
                existingEntry.copyFrom(newEntry);
                return regionData;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CommentCache commentCache = this;
        synchronized (commentCache) {
            this.regionIndex.clear();
            this.playerIndex.clear();
            this.timeIndex.clear();
        }
    }
}

