/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forge.cn.zbx1425.worldcomment.data.ServerWorldData;
import forge.cn.zbx1425.worldcomment.data.network.ThumbImage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;

public class CommentEntry {
    public static int REGION_SHIFT = 2;
    public static final int MESSAGE_MAX_LENGTH = 256;
    public long id;
    public long timestamp;
    public ResourceLocation level;
    public ChunkPos region;
    public BlockPos location;
    public UUID initiator;
    public String initiatorName;
    public int messageType;
    public String message;
    public ThumbImage image;
    public boolean deleted;
    public boolean uplinkSent;
    public int like;
    public long fileOffset;

    public CommentEntry(Player initiator, boolean isAnonymous, int messageType, String message) {
        this.id = ServerWorldData.SNOWFLAKE.nextId();
        this.timestamp = System.currentTimeMillis();
        this.level = initiator.m_9236_().m_46472_().m_135782_();
        this.initiator = initiator.m_36316_().getId();
        this.initiatorName = isAnonymous ? "" : initiator.m_36316_().getName();
        this.messageType = messageType;
        this.message = message;
        this.deleted = false;
    }

    public CommentEntry(ResourceLocation level, FriendlyByteBuf src, boolean fromFile) {
        this.fileOffset = src.readerIndex();
        this.deleted = src.readBoolean();
        this.uplinkSent = src.readBoolean();
        src.skipBytes(2);
        this.like = src.readInt();
        src.skipBytes(8);
        this.id = src.readLong();
        this.timestamp = src.readLong();
        this.level = level;
        this.location = src.m_130135_();
        this.region = new ChunkPos(this.location.m_123341_() >> 4 + REGION_SHIFT, this.location.m_123343_() >> 4 + REGION_SHIFT);
        this.initiator = src.m_130259_();
        this.initiatorName = src.m_130277_();
        this.messageType = src.readInt();
        this.message = src.m_130277_();
        this.image = new ThumbImage(src.m_130277_(), src.m_130277_());
        if (fromFile) {
            src.skipBytes(16 - src.readerIndex() % 16);
        }
    }

    public void setLocation(BlockPos location) {
        this.location = location;
        this.region = new ChunkPos(location.m_123341_() >> 4 + REGION_SHIFT, location.m_123343_() >> 4 + REGION_SHIFT);
    }

    public void copyFrom(CommentEntry other) {
        this.messageType = other.messageType;
        this.message = other.message;
        this.image = other.image;
        this.deleted = other.deleted;
        this.uplinkSent = other.uplinkSent;
        this.like = other.like;
    }

    public void writeBuffer(FriendlyByteBuf dst, boolean toFile) {
        dst.writeBoolean(this.deleted);
        dst.writeBoolean(this.uplinkSent);
        dst.writeZero(2);
        dst.writeInt(this.like);
        dst.writeBytes("====ZBX=".getBytes(StandardCharsets.UTF_8));
        dst.writeLong(this.id);
        dst.writeLong(this.timestamp);
        dst.m_130064_(this.location);
        dst.m_130077_(this.initiator);
        dst.m_130070_(this.initiatorName);
        dst.writeInt(this.messageType);
        dst.m_130070_(this.message);
        dst.m_130070_(this.image.url);
        dst.m_130070_(this.image.thumbUrl);
        if (toFile) {
            dst.writeZero(16 - dst.writerIndex() % 16);
        }
    }

    public void writeFileStream(FileOutputStream oStream) throws IOException {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer((int)512));
        this.writeBuffer(buf, true);
        this.fileOffset = oStream.getChannel().position();
        oStream.write(buf.array(), 0, buf.writerIndex());
    }

    public void updateInFile(RandomAccessFile oFile) throws IOException {
        oFile.seek(this.fileOffset);
        oFile.writeBoolean(this.deleted);
        oFile.writeBoolean(this.uplinkSent);
        oFile.write(new byte[2]);
        oFile.writeInt(this.like);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", (Number)this.id);
        json.addProperty("timestamp", (Number)this.timestamp);
        json.addProperty("level", this.level.toString());
        JsonArray blockPosArr = new JsonArray();
        blockPosArr.add((Number)this.location.m_123341_());
        blockPosArr.add((Number)this.location.m_123342_());
        blockPosArr.add((Number)this.location.m_123343_());
        json.add("location", (JsonElement)blockPosArr);
        json.addProperty("initiator", this.initiator.toString());
        json.addProperty("initiatorName", this.initiatorName);
        json.addProperty("messageType", (Number)this.messageType);
        json.addProperty("message", this.message);
        json.add("image", (JsonElement)this.image.toJson());
        json.addProperty("deleted", Boolean.valueOf(this.deleted));
        json.addProperty("like", (Number)this.like);
        return json;
    }

    public ByteBuf toBinaryBuffer() {
        FriendlyByteBuf dest = new FriendlyByteBuf(Unpooled.buffer((int)512));
        dest.m_130085_(this.level);
        this.writeBuffer(dest, false);
        return dest;
    }

    public static CommentEntry fromBinaryBuffer(ByteBuf buf) {
        FriendlyByteBuf src = new FriendlyByteBuf(buf);
        ResourceLocation level = src.m_130281_();
        return new CommentEntry(level, src, false);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

