/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data;

import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.data.CommentCache;
import forge.cn.zbx1425.worldcomment.data.CommentCommand;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.Snowflake;
import forge.cn.zbx1425.worldcomment.data.network.uplink.UplinkDispatcher;
import forge.cn.zbx1425.worldcomment.data.persist.FileSerializer;
import forge.cn.zbx1425.worldcomment.data.sync.Synchronizer;
import forge.cn.zbx1425.worldcomment.network.PacketEntryUpdateS2C;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class ServerWorldData {
    public static final Snowflake SNOWFLAKE = new Snowflake();
    public final MinecraftServer server;
    public final Path basePath;
    public boolean isHost;
    public final CommentCache comments = new CommentCache();
    public final FileSerializer fileSerializer;
    public final UplinkDispatcher uplinkDispatcher;
    public Synchronizer peerChannel;

    public ServerWorldData(MinecraftServer server, boolean isHost) {
        this.server = server;
        this.basePath = Path.of(server.m_129843_(LevelResource.f_78182_).toString(), "world-comment");
        this.fileSerializer = new FileSerializer(this.basePath);
        this.isHost = isHost;
        this.peerChannel = Synchronizer.NOOP;
        this.uplinkDispatcher = new UplinkDispatcher(Main.SERVER_CONFIG.uplinkUrl.value);
    }

    public void load() throws IOException {
        if (this.isHost) {
            this.fileSerializer.loadInto(this.comments);
            this.peerChannel.kvWriteAll(this.comments.timeIndex);
        } else {
            this.peerChannel.kvReadAllInto(this.comments);
        }
    }

    public void insert(CommentEntry newEntry, boolean fromPeer) throws IOException {
        if (CommentCommand.isCommand(newEntry)) {
            if (this.isHost) {
                CommentCommand.executeCommandServer(newEntry, this);
            }
            return;
        }
        this.comments.insert(newEntry);
        if (this.isHost) {
            this.fileSerializer.insert(newEntry);
            this.uplinkDispatcher.insert(newEntry);
            this.peerChannel.kvWriteEntry(newEntry);
        }
        if (!fromPeer) {
            this.peerChannel.notifyInsert(newEntry);
        }
        for (ServerPlayer player : this.server.m_6846_().m_11314_()) {
            PacketEntryUpdateS2C.send(player, newEntry, false);
        }
    }

    public void update(CommentEntry newEntry, boolean fromPeer) throws IOException {
        CommentEntry trustedEntry = this.comments.update(newEntry);
        if (this.isHost) {
            this.fileSerializer.update(trustedEntry);
            this.uplinkDispatcher.update(trustedEntry);
            this.peerChannel.kvWriteEntry(trustedEntry);
        }
        if (!fromPeer) {
            this.peerChannel.notifyUpdate(trustedEntry);
        }
        for (ServerPlayer player : this.server.m_6846_().m_11314_()) {
            PacketEntryUpdateS2C.send(player, trustedEntry, true);
        }
    }

    public void updateAllFields(CommentEntry newEntry, boolean fromPeer) throws IOException {
        List<CommentEntry> regionEntries = this.comments.updateAllFields(newEntry);
        if (this.isHost) {
            this.fileSerializer.updateRegion(regionEntries);
            this.uplinkDispatcher.update(newEntry);
            this.peerChannel.kvWriteEntry(newEntry);
        }
        if (!fromPeer) {
            this.peerChannel.notifyUpdateAllFields(newEntry);
        }
        for (ServerPlayer player : this.server.m_6846_().m_11314_()) {
            PacketEntryUpdateS2C.send(player, newEntry, true);
        }
    }
}

