/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data.client;

import forge.cn.zbx1425.worldcomment.MainClient;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.client.ClientWorldData;
import forge.cn.zbx1425.worldcomment.mixin.LevelRendererAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ClientRayPicking {
    public static Map<BlockPos, List<CommentEntry>> visibleComments = new Object2ObjectArrayMap();
    public static List<CommentEntry> pickedComments = new ArrayList<CommentEntry>();
    public static int overlayOffset;

    public static void tick(float partialTicks, float hitDistance) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91073_ == null) {
            return;
        }
        Vec3 pickStart = minecraft.f_91074_.m_20299_(partialTicks);
        Vec3 pickDir = minecraft.f_91074_.m_20252_(partialTicks);
        Vec3 pickEnd = pickStart.m_82520_(pickDir.f_82479_ * (double)hitDistance, pickDir.f_82480_ * (double)hitDistance, pickDir.f_82481_ * (double)hitDistance);
        HitResult hitResult = minecraft.f_91074_.m_19907_((double)hitDistance, partialTicks, true);
        double vanillaDistSqr = hitResult.m_6662_() == HitResult.Type.MISS ? 65472.0 : hitResult.m_82450_().m_82557_(pickStart);
        visibleComments.clear();
        pickedComments.clear();
        for (Map region : ClientWorldData.INSTANCE.regions.values()) {
            for (Map.Entry blockData : region.entrySet()) {
                BlockPos bp = (BlockPos)blockData.getKey();
                AABB blockHitArea = new AABB((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), (double)(bp.m_123341_() + 1), (double)(bp.m_123342_() + 3), (double)(bp.m_123343_() + 1));
                Frustum cullingFrustum = ((LevelRendererAccessor)minecraft.f_91060_).getCullingFrustum();
                if (cullingFrustum != null && !cullingFrustum.m_113029_(blockHitArea)) continue;
                Optional clipPos = blockHitArea.m_82371_(pickStart, pickEnd);
                boolean isPicked = clipPos.isPresent() && ((Vec3)clipPos.get()).m_82557_(pickStart) < vanillaDistSqr;
                for (CommentEntry comment : (List)blockData.getValue()) {
                    boolean isVisible = MainClient.CLIENT_CONFIG.isCommentVisible(minecraft, comment);
                    if (!isVisible) continue;
                    visibleComments.computeIfAbsent(comment.location, ignored -> new ArrayList()).add(comment);
                    if (!isPicked) continue;
                    pickedComments.add(comment);
                }
            }
        }
        overlayOffset = Math.min(overlayOffset, Math.max(pickedComments.size() - 1, 0));
    }
}

