/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data.client;

import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.interop.ProximityCommentSet;
import forge.cn.zbx1425.worldcomment.network.PacketRegionRequestC2S;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;

public class ClientWorldData {
    public Long2ObjectMap<Map<BlockPos, List<CommentEntry>>> regions = new Long2ObjectOpenHashMap();
    public Long2LongMap regionExpiry = new Long2LongOpenHashMap();
    public static ClientWorldData INSTANCE = new ClientWorldData();
    public static final long REGION_TTL = 300000L;
    public ResourceLocation level;
    public ProximityCommentSet proximityCommentSet = new ProximityCommentSet(16.0, 150000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        ClientWorldData clientWorldData = this;
        synchronized (clientWorldData) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null || minecraft.f_91073_ == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (minecraft.f_91073_.m_46472_().m_135782_() != this.level) {
                this.level = minecraft.f_91073_.m_46472_().m_135782_();
                this.clear();
            }
            BlockPos playerPos = minecraft.f_91074_.m_20183_();
            int cx = playerPos.m_123341_() >> 4 + CommentEntry.REGION_SHIFT;
            int cz = playerPos.m_123343_() >> 4 + CommentEntry.REGION_SHIFT;
            ArrayList<ChunkPos> regionsToRequest = new ArrayList<ChunkPos>();
            for (int x = cx - 1; x <= cx + 1; ++x) {
                for (int z = cz - 1; z <= cz + 1; ++z) {
                    long chunkLong = ChunkPos.m_45589_((int)x, (int)z);
                    if (this.regionExpiry.containsKey(chunkLong) && this.regionExpiry.get(chunkLong) >= currentTime) continue;
                    this.regionExpiry.put(chunkLong, currentTime + 300000L);
                    regionsToRequest.add(new ChunkPos(x, z));
                }
            }
            if (regionsToRequest.size() > 0) {
                PacketRegionRequestC2S.ClientLogics.send(minecraft.f_91073_.m_46472_().m_135782_(), regionsToRequest);
            }
            ObjectIterator it = this.regionExpiry.long2LongEntrySet().iterator();
            while (it.hasNext()) {
                Long2LongMap.Entry entry = (Long2LongMap.Entry)it.next();
                if (entry.getLongValue() >= currentTime) continue;
                this.regions.remove(entry.getLongKey());
                it.remove();
            }
            this.proximityCommentSet.tick(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ClientWorldData clientWorldData = this;
        synchronized (clientWorldData) {
            this.regions.clear();
            this.regionExpiry.clear();
            this.proximityCommentSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptRegions(ResourceLocation level, Long2ObjectMap<List<CommentEntry>> regions) {
        ClientWorldData clientWorldData = this;
        synchronized (clientWorldData) {
            if (!level.equals((Object)this.level)) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            for (Long2ObjectMap.Entry entry : regions.long2ObjectEntrySet()) {
                ((Map)this.regions.computeIfAbsent(entry.getLongKey(), ignored -> new Object2ObjectArrayMap())).clear();
                for (CommentEntry comment : (List)entry.getValue()) {
                    ((Map)this.regions.get(entry.getLongKey())).computeIfAbsent(comment.location, ignored -> new ArrayList()).add(comment);
                }
                this.regionExpiry.put(entry.getLongKey(), currentTime + 300000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptUpdate(CommentEntry comment, boolean update) {
        ClientWorldData clientWorldData = this;
        synchronized (clientWorldData) {
            if (!comment.level.equals((Object)this.level)) {
                return;
            }
            Map regionData = (Map)this.regions.get(comment.region.m_45588_());
            if (regionData != null) {
                if (update) {
                    List blockData = (List)regionData.get(comment.location);
                    for (int i = 0; i < blockData.size(); ++i) {
                        if (((CommentEntry)blockData.get((int)i)).id != comment.id) continue;
                        if (comment.deleted) {
                            blockData.remove(i);
                        } else {
                            blockData.set(i, comment);
                        }
                        break;
                    }
                } else {
                    regionData.computeIfAbsent(comment.location, ignored -> new ArrayList()).add(comment);
                }
            }
        }
    }
}

