/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data.network;

import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.ServerWorldData;
import forge.cn.zbx1425.worldcomment.data.network.ImageDownload;
import forge.cn.zbx1425.worldcomment.data.network.upload.ImageUploader;
import forge.cn.zbx1425.worldcomment.network.PacketCollectionRequestC2S;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class ImageDump {
    private static long lastRequestNonce = 0L;
    private static String lastRequestDirName = "";

    public static void requestDumpComments(String dirName) {
        lastRequestNonce = ServerWorldData.SNOWFLAKE.nextId();
        lastRequestDirName = dirName;
        PacketCollectionRequestC2S.ClientLogics.sendLatest(0, Integer.MAX_VALUE, lastRequestNonce);
    }

    public static void handleDumpResponse(List<CommentEntry> comments, long nonce) {
        if (nonce != lastRequestNonce) {
            return;
        }
        Path storeDir = Minecraft.m_91087_().f_91069_.toPath().resolve("worldcomment-images").resolve(lastRequestDirName);
        try {
            if (!Files.isDirectory(storeDir, new LinkOption[0])) {
                Files.createDirectories(storeDir, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            Main.LOGGER.error("Cannot create image dump directory", (Throwable)ex);
            return;
        }
        Main.IO_EXECUTOR.execute(() -> {
            for (int i = 0; i < comments.size(); ++i) {
                Path filePath;
                int finalI = i;
                Minecraft.m_91087_().execute(() -> {
                    if (Minecraft.m_91087_().f_91074_ != null) {
                        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)("WorldComment: Downloading " + (finalI + 1) + "/" + comments.size())), true);
                    }
                });
                CommentEntry comment = (CommentEntry)comments.get(i);
                String targetUrl = comment.image.url;
                if (targetUrl.isEmpty() || Files.exists(filePath = storeDir.resolve(ImageDownload.getCacheFileName(targetUrl)), new LinkOption[0])) continue;
                try {
                    URI url = URI.create(targetUrl);
                    if (url.getScheme().equals("file")) continue;
                    byte[] imageData = Main.HTTP_CLIENT.send(ImageUploader.requestBuilder(url).timeout(Duration.of(10L, ChronoUnit.SECONDS)).GET().build(), HttpResponse.BodyHandlers.ofByteArray()).body();
                    Files.write(filePath, imageData, new OpenOption[0]);
                    continue;
                }
                catch (IOException | InterruptedException ex) {
                    Main.LOGGER.warn("Cannot download image {}", (Object)targetUrl, (Object)ex);
                }
            }
            Minecraft.m_91087_().execute(() -> {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)"WorldComment: Download finished"), false);
                }
            });
        });
    }
}

