/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data.network;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class MimeMultipartData {
    private String boundary;
    private HttpRequest.BodyPublisher bodyPublisher;

    private MimeMultipartData() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public HttpRequest.BodyPublisher getBodyPublisher() throws IOException {
        return this.bodyPublisher;
    }

    public String getContentType() {
        return "multipart/form-data; boundary=" + this.boundary;
    }

    public static class Builder {
        private String boundary;
        private Charset charset = StandardCharsets.UTF_8;
        private List<MimedFile> files = new ArrayList<MimedFile>();
        private Map<String, String> texts = new LinkedHashMap<String, String>();

        private Builder() {
            this.boundary = new BigInteger(128, new Random()).toString();
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withBoundary(String boundary) {
            this.boundary = boundary;
            return this;
        }

        public Builder addFile(String name, String path, byte[] data, String mimeType) {
            this.files.add(new MimedFile(name, path, data, mimeType));
            return this;
        }

        public Builder addText(String name, String text) {
            this.texts.put(name, text);
            return this;
        }

        public MimeMultipartData build() throws IOException {
            MimeMultipartData mimeMultipartData = new MimeMultipartData();
            mimeMultipartData.boundary = this.boundary;
            byte[] newline = "\r\n".getBytes(this.charset);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (MimedFile mimedFile : this.files) {
                byteArrayOutputStream.write(("--" + this.boundary).getBytes(this.charset));
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(("Content-Disposition: form-data; name=\"" + mimedFile.name + "\"; filename=\"" + mimedFile.fileName + "\"").getBytes(this.charset));
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(("Content-Type: " + mimedFile.mimeType).getBytes(this.charset));
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(mimedFile.data);
                byteArrayOutputStream.write(newline);
            }
            for (Map.Entry entry : this.texts.entrySet()) {
                byteArrayOutputStream.write(("--" + this.boundary).getBytes(this.charset));
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(("Content-Disposition: form-data; name=\"" + (String)entry.getKey() + "\"").getBytes(this.charset));
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(((String)entry.getValue()).getBytes(this.charset));
                byteArrayOutputStream.write(newline);
            }
            byteArrayOutputStream.write(("--" + this.boundary + "--").getBytes(this.charset));
            mimeMultipartData.bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(byteArrayOutputStream.toByteArray());
            return mimeMultipartData;
        }

        public class MimedFile {
            public final String name;
            public final String fileName;
            public final byte[] data;
            public final String mimeType;

            public MimedFile(String name, String fileName, byte[] data, String mimeType) {
                this.name = name;
                this.fileName = fileName;
                this.data = data;
                this.mimeType = mimeType;
            }
        }
    }
}

