/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data.network;

import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.MainClient;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.network.SubmitJob;
import forge.cn.zbx1425.worldcomment.data.network.ThumbImage;
import forge.cn.zbx1425.worldcomment.data.network.upload.ImageUploader;
import forge.cn.zbx1425.worldcomment.network.PacketEntryCreateC2S;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;

public class SubmitDispatcher {
    private static final Long2ObjectMap<SubmitJob> pendingJobs = new Long2ObjectOpenHashMap();

    public static long addJob(CommentEntry comment, byte[] imageBytes, BiConsumer<SubmitJob, Throwable> callback) {
        SubmitJob job = new SubmitJob(comment, imageBytes, callback, MainClient.CLIENT_CONFIG);
        SubmitDispatcher.addJob(comment.id, job);
        return comment.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addJob(long jobId, SubmitJob job) {
        Long2ObjectMap<SubmitJob> long2ObjectMap = pendingJobs;
        synchronized (long2ObjectMap) {
            pendingJobs.put(jobId, (Object)job);
        }
        if (job.imageBytes != null) {
            ImageUploader uploader = job.uploaderToUse.poll();
            if (uploader == null) {
                throw new IllegalStateException("All uploads failed");
            }
            ((CompletableFuture)uploader.uploadImage(job.imageBytes, job.comment).thenAccept(thumbImage -> {
                job.setImage((ThumbImage)thumbImage);
                SubmitDispatcher.trySendPackage(jobId);
            })).exceptionally(ex -> {
                Main.LOGGER.error("Upload Image", ex);
                if (job.callback != null) {
                    job.callback.accept(job, (Throwable)ex);
                }
                if (job.uploaderToUse.isEmpty()) {
                    SubmitDispatcher.removeJob(jobId);
                } else {
                    SubmitDispatcher.addJob(jobId, job);
                }
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void placeJobAt(long jobId, BlockPos blockPos) {
        Long2ObjectMap<SubmitJob> long2ObjectMap = pendingJobs;
        synchronized (long2ObjectMap) {
            if (!pendingJobs.containsKey(jobId)) {
                return;
            }
            ((SubmitJob)pendingJobs.get(jobId)).setLocation(blockPos);
            SubmitDispatcher.trySendPackage(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJob(long jobId) {
        Long2ObjectMap<SubmitJob> long2ObjectMap = pendingJobs;
        synchronized (long2ObjectMap) {
            pendingJobs.remove(jobId);
        }
    }

    private static void trySendPackage(long jobId) {
        SubmitJob job = (SubmitJob)pendingJobs.get(jobId);
        if (job.isReady()) {
            PacketEntryCreateC2S.ClientLogics.send(job.comment);
            if (job.callback != null) {
                job.callback.accept(null, null);
            }
            SubmitDispatcher.removeJob(jobId);
        } else if (job.imageBytes != null && !job.imageReady && job.callback != null) {
            job.callback.accept(job, null);
        }
    }
}

