/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data.network;

import forge.cn.zbx1425.worldcomment.ClientConfig;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.network.ThumbImage;
import forge.cn.zbx1425.worldcomment.data.network.upload.ImageUploader;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;

public class SubmitJob {
    public final CommentEntry comment;
    public final byte[] imageBytes;
    public boolean imageReady;
    public boolean blockPosReady;
    public BiConsumer<SubmitJob, Throwable> callback;
    public Queue<ImageUploader> uploaderToUse;

    public SubmitJob(CommentEntry comment, byte[] imageBytes, BiConsumer<SubmitJob, Throwable> callback, ClientConfig config) {
        this.comment = comment;
        this.imageBytes = imageBytes;
        if (imageBytes == null) {
            comment.image = ThumbImage.NONE;
            this.imageReady = true;
        }
        this.callback = callback;
        this.uploaderToUse = new LinkedList<ImageUploader>(config.imageUploader);
    }

    public void setImage(ThumbImage image) {
        this.comment.image = image;
        this.imageReady = true;
    }

    public void setLocation(BlockPos blockPos) {
        this.comment.setLocation(blockPos);
        this.blockPosReady = true;
    }

    public boolean isReady() {
        return this.imageReady && this.blockPosReady;
    }
}

