/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data.network.upload;

import com.google.gson.JsonObject;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.network.ThumbImage;
import forge.cn.zbx1425.worldcomment.data.network.upload.ImageUploader;
import forge.cn.zbx1425.worldcomment.network.PacketImageDownloadC2S;
import forge.cn.zbx1425.worldcomment.network.PacketImageUploadC2S;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class LocalStorageUploader
extends ImageUploader {
    private static final LocalStorageUploader INSTANCE = new LocalStorageUploader();
    public static final String URL_PREFIX = "file://worldcomment/";
    private static final Map<Long, CompletableFuture<ThumbImage>> pendingUploads = new HashMap<Long, CompletableFuture<ThumbImage>>();
    private static final Map<String, CompletableFuture<byte[]>> pendingDownloads = new HashMap<String, CompletableFuture<byte[]>>();
    private static final long TIMEOUT_SECONDS = 30L;
    public static final int IMAGE_MAX_SIZE = 0xA00000;
    public static final int IMAGE_CHUNK_SIZE = 28672;

    private LocalStorageUploader() {
    }

    public static LocalStorageUploader getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<ThumbImage> uploadImage(byte[] imageBytes, CommentEntry comment) {
        CompletableFuture future = new CompletableFuture();
        Map<Long, CompletableFuture<ThumbImage>> map = pendingUploads;
        synchronized (map) {
            CompletableFuture<ThumbImage> existing = pendingUploads.get(comment.id);
            if (existing != null && !existing.isDone()) {
                return existing;
            }
            if (existing != null) {
                pendingUploads.remove(comment.id);
            }
            pendingUploads.put(comment.id, future);
        }
        PacketImageUploadC2S.ClientLogics.send(comment, imageBytes);
        return future.orTimeout(30L, TimeUnit.SECONDS).whenComplete((result, ex) -> {
            Map<Long, CompletableFuture<ThumbImage>> map = pendingUploads;
            synchronized (map) {
                pendingUploads.remove(comment.id);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void completeUpload(long jobId, ThumbImage image) {
        CompletableFuture<ThumbImage> future;
        Map<Long, CompletableFuture<ThumbImage>> map = pendingUploads;
        synchronized (map) {
            future = pendingUploads.remove(jobId);
        }
        if (future != null) {
            future.complete(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void completeUploadExceptionally(long jobId, Throwable ex) {
        CompletableFuture<ThumbImage> future;
        Map<Long, CompletableFuture<ThumbImage>> map = pendingUploads;
        synchronized (map) {
            future = pendingUploads.remove(jobId);
        }
        if (future != null) {
            future.completeExceptionally(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletableFuture<byte[]> downloadImage(String url) {
        if (!url.startsWith(URL_PREFIX)) {
            throw new IllegalArgumentException("Not a WorldComment URL: " + url);
        }
        String fileName = url.substring(URL_PREFIX.length());
        Map<String, CompletableFuture<byte[]>> map = pendingDownloads;
        synchronized (map) {
            CompletableFuture<byte[]> existing = pendingDownloads.get(url);
            if (existing != null && !existing.isDone()) {
                return existing;
            }
            if (existing != null) {
                pendingDownloads.remove(url);
            }
            CompletableFuture future = new CompletableFuture();
            pendingDownloads.put(url, future);
            PacketImageDownloadC2S.ClientLogics.send(fileName);
            return future.orTimeout(30L, TimeUnit.SECONDS).whenComplete((result, ex) -> {
                Map<String, CompletableFuture<byte[]>> map = pendingDownloads;
                synchronized (map) {
                    pendingDownloads.remove(url);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void completeDownload(String fileName, byte[] imageData) {
        CompletableFuture<byte[]> future;
        String url = URL_PREFIX + fileName;
        Map<String, CompletableFuture<byte[]>> map = pendingDownloads;
        synchronized (map) {
            future = pendingDownloads.remove(url);
        }
        if (future != null) {
            future.complete(imageData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void completeDownloadExceptionally(String fileName, Throwable ex) {
        CompletableFuture<byte[]> future;
        String url = URL_PREFIX + fileName;
        Map<String, CompletableFuture<byte[]>> map = pendingDownloads;
        synchronized (map) {
            future = pendingDownloads.remove(url);
        }
        if (future != null) {
            future.completeExceptionally(ex);
        }
    }

    @Override
    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("service", "local");
        return obj;
    }

    public static LocalStorageUploader deserialize(JsonObject config) {
        return LocalStorageUploader.getInstance();
    }
}

