/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data.network.upload;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.network.ImageConvertClient;
import forge.cn.zbx1425.worldcomment.data.network.MimeMultipartData;
import forge.cn.zbx1425.worldcomment.data.network.ThumbImage;
import forge.cn.zbx1425.worldcomment.data.network.upload.ImageUploader;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class SmmsUploader
extends ImageUploader {
    private final String apiUrl;
    private final String apiToken;

    public SmmsUploader(JsonObject config) {
        this.apiUrl = config.has("apiUrl") ? config.get("apiUrl").getAsString() : "https://smms.app/api/v2/upload";
        this.apiToken = config.get("apiToken").getAsString();
    }

    @Override
    public CompletableFuture<ThumbImage> uploadImage(byte[] imageBytes, CommentEntry comment) {
        String initiatorName = comment.initiatorName.isBlank() ? "anonymous" : comment.initiatorName;
        CompletableFuture<String> fullSizeUrlFuture = this.uploadImage(imageBytes, IMAGE_MAX_WIDTH, "sender-" + initiatorName + ".jpg");
        CompletableFuture<String> thumbnailFuture = this.uploadImage(imageBytes, THUMBNAIL_MAX_WIDTH, "sender-" + initiatorName + ".thumb.jpg");
        return CompletableFuture.allOf(fullSizeUrlFuture, thumbnailFuture).thenApply(ignored -> new ThumbImage((String)fullSizeUrlFuture.join(), (String)thumbnailFuture.join()));
    }

    private CompletableFuture<String> uploadImage(byte[] imageBytes, int maxWidth, String fileName) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                MimeMultipartData body = MimeMultipartData.newBuilder().withCharset(StandardCharsets.UTF_8).addFile("smfile", fileName, ImageConvertClient.toJpegScaled(imageBytes, maxWidth), "image/jpg").build();
                return ImageUploader.requestBuilder(URI.create(this.apiUrl)).header("Content-Type", body.getContentType()).header("Authorization", "Basic " + this.apiToken).POST(body.getBodyPublisher()).build();
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        }, Main.IO_EXECUTOR).thenCompose(reqUpload -> Main.HTTP_CLIENT.sendAsync((HttpRequest)reqUpload, HttpResponse.BodyHandlers.ofString()))).thenApply(response -> {
            if (response.statusCode() != 200) {
                throw new CompletionException(new IOException("HTTP Error Code " + response.statusCode() + "\n" + (String)response.body()));
            }
            JsonObject respObj = JsonParser.parseString((String)((String)response.body())).getAsJsonObject();
            if (!respObj.get("success").getAsBoolean()) {
                if (respObj.get("code").getAsString().equals("image_repeated")) {
                    return respObj.get("images").getAsString();
                }
                throw new CompletionException(new IOException("Upload Fail " + (String)response.body()));
            }
            return respObj.get("data").getAsJsonObject().get("url").getAsString();
        });
    }

    @Override
    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("service", "smms");
        obj.addProperty("apiUrl", this.apiUrl);
        obj.addProperty("apiToken", this.apiToken);
        return obj;
    }
}

