/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.data.persist;

import forge.cn.zbx1425.worldcomment.data.CommentCache;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;

public class FileSerializer {
    private final Path basePath;

    public FileSerializer(Path basePath) {
        this.basePath = basePath;
    }

    public void loadInto(CommentCache commentCache) throws IOException {
        commentCache.clear();
        try {
            Files.createDirectories(this.basePath.resolve("region"), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        try (Stream<Path> levelFiles = Files.list(this.basePath.resolve("region"));){
            for (Path levelPath : levelFiles.toList()) {
                ResourceLocation dimension = new ResourceLocation(levelPath.getFileName().toString().replace("+", ":"));
                Stream<Path> files = Files.list(levelPath);
                try {
                    for (Path file : files.toList()) {
                        String[] fileNameParts = file.getFileName().toString().split("\\.");
                        if (fileNameParts.length != 4 || !fileNameParts[3].equals("bin")) continue;
                        ChunkPos region = new ChunkPos(Integer.parseInt(fileNameParts[1]), Integer.parseInt(fileNameParts[2]));
                        byte[] fileContent = Files.readAllBytes(file);
                        commentCache.loadRegion(dimension, region.m_45588_(), fileContent, true);
                    }
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
        }
    }

    private Path getLevelPath(ResourceLocation dimension) {
        return this.basePath.resolve("region").resolve(dimension.m_135827_() + "+" + dimension.m_135815_());
    }

    private Path getLevelRegionPath(ResourceLocation dimension, ChunkPos region) {
        return this.basePath.resolve("region").resolve(dimension.m_135827_() + "+" + dimension.m_135815_()).resolve("r." + region.f_45578_ + "." + region.f_45579_ + ".bin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(CommentEntry newEntry) throws IOException {
        FileSerializer fileSerializer = this;
        synchronized (fileSerializer) {
            try {
                Files.createDirectory(this.getLevelPath(newEntry.level), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            Path targetFile = this.getLevelRegionPath(newEntry.level, newEntry.region);
            try (FileOutputStream oStream = new FileOutputStream(targetFile.toFile(), true);){
                newEntry.writeFileStream(oStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CommentEntry existingEntry) throws IOException {
        FileSerializer fileSerializer = this;
        synchronized (fileSerializer) {
            assert (existingEntry.fileOffset > 0L);
            Path targetFile = this.getLevelRegionPath(existingEntry.level, existingEntry.region);
            try (RandomAccessFile oStream = new RandomAccessFile(targetFile.toFile(), "rw");){
                existingEntry.updateInFile(oStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegion(List<CommentEntry> regionEntries) throws IOException {
        FileSerializer fileSerializer = this;
        synchronized (fileSerializer) {
            if (regionEntries.isEmpty()) {
                return;
            }
            CommentEntry pivot = regionEntries.get(0);
            try {
                Files.createDirectory(this.getLevelPath(pivot.level), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            Path targetFile = this.getLevelRegionPath(pivot.level, pivot.region);
            try (FileOutputStream oStream = new FileOutputStream(targetFile.toFile(), false);){
                for (CommentEntry entry : regionEntries) {
                    entry.writeFileStream(oStream);
                }
            }
        }
    }
}

