/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.ServerWorldData;
import forge.cn.zbx1425.worldcomment.data.client.ClientRayPicking;
import forge.cn.zbx1425.worldcomment.data.client.ClientWorldData;
import forge.cn.zbx1425.worldcomment.data.network.ImageDownload;
import forge.cn.zbx1425.worldcomment.gui.IGuiCommon;
import forge.cn.zbx1425.worldcomment.gui.WidgetColorButton;
import forge.cn.zbx1425.worldcomment.gui.WidgetCommentEntry;
import forge.cn.zbx1425.worldcomment.network.PacketCollectionRequestC2S;
import forge.cn.zbx1425.worldcomment.network.PacketEntryActionC2S;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class CommentListScreen
extends Screen
implements IGuiCommon {
    int subScreen = 0;
    int prevSubScreen = 0;
    Button[] pageButtons = new Button[4];
    List<CommentEntry> commentList = new ArrayList<CommentEntry>();
    int commentListOffset = 0;
    int latestCommentsRequestedAmount = 0;
    private final int latestCommentsPageSize = 20;
    CommentEntry commentForDetail;
    CommentEntry commentToDelete;
    private final Map<CommentEntry, WidgetCommentEntry> widgets = new WeakHashMap<CommentEntry, WidgetCommentEntry>();
    private double accumulatedScroll = 0.0;
    private long lastRequestNonce;

    protected CommentListScreen(CommentEntry commentForDetail) {
        super((Component)Component.m_237113_((String)""));
        this.commentForDetail = commentForDetail;
        this.useSubScreen(commentForDetail != null ? 3 : 0);
        this.prevSubScreen = commentForDetail != null ? 3 : 0;
    }

    private WidgetCommentEntry getWidget(CommentEntry entry) {
        return this.widgets.computeIfAbsent(entry, WidgetCommentEntry::new);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        int commentEntryWidth = Math.min(this.f_96543_ - 100 - 20 - 10, 250);
        int bookWidth = this.subScreen == 3 ? this.f_96543_ : commentEntryWidth + 100 + 20 + 10;
        int xOffset = (this.f_96543_ - bookWidth) / 2;
        int xOffsetR = this.f_96543_ - xOffset;
        this.pageButtons[0] = (Button)this.m_142416_((GuiEventListener)new WidgetColorButton(xOffset + 10, 40, 80, 20, (Component)Component.m_237115_((String)"gui.worldcomment.list.nearby_posts"), -1739917, sender -> this.useSubScreen(0)));
        this.pageButtons[1] = (Button)this.m_142416_((GuiEventListener)new WidgetColorButton(xOffset + 10, 64, 80, 20, (Component)Component.m_237115_((String)"gui.worldcomment.list.recent_posts"), -1739917, sender -> this.useSubScreen(1)));
        this.pageButtons[2] = (Button)this.m_142416_((GuiEventListener)new WidgetColorButton(xOffset + 10, 88, 80, 20, (Component)Component.m_237115_((String)"gui.worldcomment.list.my_posts"), -1739917, sender -> this.useSubScreen(2)));
        this.pageButtons[3] = (Button)this.m_142416_((GuiEventListener)new WidgetColorButton(xOffset + 10, 122, 80, 20, (Component)Component.m_237115_((String)"gui.worldcomment.list.detail"), -1739917, sender -> {}));
        for (int i = 0; i < this.pageButtons.length; ++i) {
            this.pageButtons[i].f_93623_ = i != this.subScreen;
        }
        this.pageButtons[3].f_93624_ = this.subScreen == 3;
    }

    void useSubScreen(int subScreen) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.prevSubScreen = this.subScreen;
        this.subScreen = subScreen;
        if (this.prevSubScreen != 3 || this.commentList.isEmpty()) {
            switch (subScreen) {
                case 0: {
                    this.commentList.clear();
                    BlockPos playerPos = minecraft.f_91074_.m_20183_();
                    for (Map region : ClientWorldData.INSTANCE.regions.values()) {
                        for (Map.Entry blockData : region.entrySet()) {
                            for (CommentEntry comment : (List)blockData.getValue()) {
                                if (comment.deleted) continue;
                                this.commentList.add(comment);
                            }
                        }
                    }
                    this.commentList.sort(Comparator.comparingDouble(entry -> entry.location.m_123331_((Vec3i)playerPos)));
                    this.commentListOffset = 0;
                    break;
                }
                case 1: {
                    this.commentList.clear();
                    this.commentListOffset = 0;
                    this.lastRequestNonce = ServerWorldData.SNOWFLAKE.nextId();
                    this.latestCommentsRequestedAmount = 0;
                    PacketCollectionRequestC2S.ClientLogics.sendLatest(this.latestCommentsRequestedAmount, 20, this.lastRequestNonce);
                    this.latestCommentsRequestedAmount += 20;
                    break;
                }
                case 2: {
                    this.commentList.clear();
                    this.commentListOffset = 0;
                    this.lastRequestNonce = ServerWorldData.SNOWFLAKE.nextId();
                    PacketCollectionRequestC2S.ClientLogics.sendPlayer(minecraft.f_91074_.m_36316_().getId(), this.lastRequestNonce);
                }
            }
        }
        this.m_7856_();
    }

    public void m_88315_(GuiGraphics guiParam, int mouseX, int mouseY, float partialTick) {
        GuiGraphics guiGraphics = guiParam;
        Minecraft minecraft = Minecraft.m_91087_();
        this.m_280273_(guiParam);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
        int commentEntryWidth = Math.min(this.f_96543_ - 100 - 20 - 10, 250);
        int bookWidth = this.subScreen == 3 ? this.f_96543_ : commentEntryWidth + 100 + 20 + 10;
        int xOffset = (this.f_96543_ - bookWidth) / 2;
        int xOffsetR = this.f_96543_ - xOffset;
        guiGraphics.m_280614_(minecraft.f_91062_, (Component)Component.m_237115_((String)"gui.worldcomment.list.title"), xOffset + 40, 15, -6464, true);
        for (Button button : this.pageButtons) {
            button.m_252865_(xOffset + 10);
        }
        if (this.subScreen == 3) {
            boolean canDelete;
            CommentEntry comment = this.commentForDetail;
            int maxPicWidth = this.f_96543_ - 100 - 20 - 20;
            int maxPicHeight = this.f_96544_ - 30 - 20 - 20;
            int shadowColor = -16777216;
            int shadowOffset = 3;
            ImageDownload.ImageState imageToDraw = ImageDownload.getTexture(comment.image, false);
            int picWidth = Math.min(maxPicWidth, maxPicHeight * imageToDraw.width / imageToDraw.height);
            int picHeight = picWidth * imageToDraw.height / imageToDraw.width;
            int x1 = 110;
            int x2 = 110 + picWidth;
            int y1 = 40;
            int y2 = 40 + picHeight;
            guiGraphics.m_280509_(x1 + shadowOffset, y1 + shadowOffset, x2 + shadowOffset, y2 + shadowOffset, shadowColor);
            RenderSystem.setShaderTexture((int)0, (int)imageToDraw.getFriendlyTexture(minecraft.m_91097_()).m_117963_());
            RenderSystem.setShader(GameRenderer::m_172817_);
            Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y1, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y2, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y2, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y1, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            WidgetCommentEntry widget = this.getWidget(comment);
            widget.showImage = false;
            int imgAreaWidth = this.f_96543_ - 100 - 20 - 10;
            widget.setBounds(110 + imgAreaWidth - imgAreaWidth / 2, 0, imgAreaWidth / 2);
            widget.setBounds(110 + imgAreaWidth - imgAreaWidth / 2, this.f_96544_ - 20 - widget.m_93694_(), imgAreaWidth / 2);
            widget.m_88315_(guiParam, mouseX, mouseY, partialTick);
            boolean bl = canDelete = minecraft.f_91074_.m_20310_(3) || minecraft.f_91074_.m_36316_().getId().equals(comment.initiator);
            if (canDelete) {
                int deleteBtnX = 118;
                int deleteBtnY = this.f_96544_ - 20 - 22;
                guiGraphics.m_280411_(ATLAS_LOCATION, deleteBtnX, deleteBtnY, 20, 20, 216.0f, 60.0f, 20, 20, 256, 256);
                if (mouseX > deleteBtnX && mouseX < deleteBtnX + 20 && mouseY > deleteBtnY && mouseY < deleteBtnY + 20) {
                    guiGraphics.m_280411_(ATLAS_LOCATION, deleteBtnX, deleteBtnY, 20, 20, 236.0f, 60.0f, 20, 20, 256, 256);
                    if (this.commentToDelete == comment) {
                        guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.worldcomment.list.remove.confirm"), mouseX, mouseY);
                    }
                }
            }
        } else {
            this.graphicsBlit9(guiGraphics, xOffset + 100, 30, bookWidth - 120, this.f_96544_ - 50, 176, 40, 20, 20, 256, 256, 4, 4, 4, 4);
            guiGraphics.m_280588_(0, 32, this.f_96543_, this.f_96544_ - 22);
            int yOffset = 36;
            for (int i = this.commentListOffset; i < this.commentList.size(); ++i) {
                boolean canDelete;
                CommentEntry comment = this.commentList.get(i);
                WidgetCommentEntry widget = this.getWidget(comment);
                widget.showImage = true;
                widget.setBounds(xOffset + 106, yOffset, bookWidth - 102 - 22 - 8 - 4 - 16);
                widget.m_88315_(guiParam, mouseX, mouseY, partialTick);
                guiGraphics.m_280411_(ATLAS_LOCATION, xOffsetR - 22 - 4 - 16, yOffset + 4, 16, 16, 196.0f, 60.0f, 20, 20, 256, 256);
                if (mouseX > xOffsetR - 22 - 4 - 16 && mouseX < xOffsetR - 22 - 4 && mouseY > yOffset + 4 && mouseY < yOffset + 4 + 16) {
                    guiGraphics.m_280411_(ATLAS_LOCATION, xOffsetR - 22 - 4 - 16, yOffset + 4, 16, 16, 236.0f, 60.0f, 20, 20, 256, 256);
                }
                boolean bl = canDelete = minecraft.f_91074_.m_20310_(3) || minecraft.f_91074_.m_36316_().getId().equals(comment.initiator);
                if (canDelete) {
                    guiGraphics.m_280411_(ATLAS_LOCATION, xOffsetR - 22 - 4 - 16, (yOffset += 16) + 4, 16, 16, 216.0f, 60.0f, 20, 20, 256, 256);
                    if (mouseX > xOffsetR - 22 - 4 - 16 && mouseX < xOffsetR - 22 - 4 && mouseY > yOffset + 4 && mouseY < yOffset + 4 + 16) {
                        guiGraphics.m_280411_(ATLAS_LOCATION, xOffsetR - 22 - 4 - 16, yOffset + 4, 16, 16, 236.0f, 60.0f, 20, 20, 256, 256);
                        if (this.commentToDelete == comment) {
                            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.worldcomment.list.remove.confirm"), mouseX, mouseY);
                        }
                    }
                    yOffset -= 16;
                }
                if ((yOffset += widget.m_93694_() + 6) > this.f_96544_ - 22) break;
            }
            guiGraphics.m_280618_();
            if (this.commentList.size() > 1) {
                String pageStr = String.format("\u2195 %d / %d", this.commentListOffset + 1, this.commentList.size());
                guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, pageStr, xOffsetR - 10 - 10 - Minecraft.m_91087_().f_91062_.m_92895_(pageStr), 15, -5908825, true);
            } else if (this.commentList.isEmpty()) {
                guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.worldcomment.list.empty"), xOffset + 100 + (bookWidth - 120) / 2, 30 + (this.f_96544_ - 50) / 2, -5908825);
            }
        }
        guiGraphics.m_280168_().m_85849_();
        super.m_88315_(guiParam, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        block8: {
            int xOffsetR;
            block7: {
                boolean canDelete;
                int commentEntryWidth = Math.min(this.f_96543_ - 100 - 20 - 10, 250);
                int bookWidth = this.subScreen == 3 ? this.f_96543_ : commentEntryWidth + 100 + 20 + 10;
                int xOffset = (this.f_96543_ - bookWidth) / 2;
                xOffsetR = this.f_96543_ - xOffset;
                if (this.subScreen != 3) break block7;
                CommentEntry comment = this.commentForDetail;
                boolean bl = canDelete = this.f_96541_.f_91074_.m_20310_(3) || this.f_96541_.f_91074_.m_36316_().getId().equals(comment.initiator);
                if (!canDelete) break block8;
                int deleteBtnX = 118;
                int deleteBtnY = this.f_96544_ - 20 - 22;
                if (!(mouseX > (double)deleteBtnX) || !(mouseX < (double)(deleteBtnX + 20)) || !(mouseY > (double)deleteBtnY) || !(mouseY < (double)(deleteBtnY + 20))) break block8;
                if (comment == this.commentToDelete) {
                    PacketEntryActionC2S.ClientLogics.send(comment, -1);
                    this.commentList.remove(comment);
                    this.commentToDelete = null;
                    this.commentListOffset = Mth.m_14045_((int)this.commentListOffset, (int)0, (int)Math.max(this.commentList.size() - 1, 0));
                    this.m_7379_();
                } else {
                    this.commentToDelete = comment;
                }
                break block8;
            }
            int yOffset = 36;
            for (int i = this.commentListOffset; i < this.commentList.size(); ++i) {
                CommentEntry comment = this.commentList.get(i);
                WidgetCommentEntry widget = this.getWidget(comment);
                if (mouseX > (double)(xOffsetR - 22 - 4 - 16) && mouseX < (double)(xOffsetR - 22 - 4) && mouseY > (double)(yOffset + 4) && mouseY < (double)(yOffset + 4 + 16)) {
                    this.commentForDetail = comment;
                    this.useSubScreen(3);
                    return true;
                }
                yOffset += 16;
                if (mouseX > (double)(xOffsetR - 22 - 4 - 16) && mouseX < (double)(xOffsetR - 22 - 4) && mouseY > (double)(yOffset + 4) && mouseY < (double)(yOffset + 4 + 16)) {
                    if (comment == this.commentToDelete) {
                        PacketEntryActionC2S.ClientLogics.send(comment, -1);
                        this.commentList.remove(comment);
                        this.commentToDelete = null;
                        this.commentListOffset = Mth.m_14045_((int)this.commentListOffset, (int)0, (int)Math.max(this.commentList.size() - 1, 0));
                    } else {
                        this.commentToDelete = comment;
                    }
                    return true;
                }
                yOffset -= 16;
                if ((yOffset += widget.m_93694_() + 6) > this.f_96544_ - 22) break;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_280273_(GuiGraphics guiParam) {
        GuiGraphics guiGraphics = guiParam;
        super.m_280273_(guiParam);
        int commentEntryWidth = Math.min(this.f_96543_ - 100 - 20 - 10, 250);
        int bookWidth = this.subScreen == 3 ? this.f_96543_ : commentEntryWidth + 100 + 20 + 10;
        int xOffset = (this.f_96543_ - bookWidth) / 2;
        int xOffsetR = this.f_96543_ - xOffset;
        this.graphicsBlit9(guiGraphics, xOffset + 30, 10, bookWidth - 40, this.f_96544_ - 20, 196, 40, 20, 20, 256, 256, 4, 4, 4, 4);
        RenderSystem.enableBlend();
        guiGraphics.m_280509_(xOffset + 30, 10, xOffset + 60, this.f_96544_ - 10, 1725116207);
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaY) {
        if (this.accumulatedScroll != 0.0 && Math.signum(deltaY) != Math.signum(this.accumulatedScroll)) {
            this.accumulatedScroll = 0.0;
        }
        this.accumulatedScroll += deltaY;
        int scrollAmount = (int)this.accumulatedScroll;
        if (scrollAmount == 0) {
            return super.m_6050_(mouseX, mouseY, deltaY);
        }
        this.accumulatedScroll -= (double)scrollAmount;
        if (this.commentList.size() <= 1) {
            this.commentListOffset = 0;
            return super.m_6050_(mouseX, mouseY, deltaY);
        }
        int dir = -((int)Math.signum(scrollAmount));
        this.commentListOffset = Mth.m_14045_((int)(this.commentListOffset + dir), (int)0, (int)Math.max(this.commentList.size() - 1, 0));
        if (this.subScreen == 1 && this.commentListOffset >= this.latestCommentsRequestedAmount - 10) {
            this.lastRequestNonce = ServerWorldData.SNOWFLAKE.nextId();
            PacketCollectionRequestC2S.ClientLogics.sendLatest(this.latestCommentsRequestedAmount, 20, this.lastRequestNonce);
            this.latestCommentsRequestedAmount += 20;
        }
        return true;
    }

    public void m_7379_() {
        if (this.subScreen == 3 && this.prevSubScreen != 3) {
            this.useSubScreen(this.prevSubScreen);
        } else {
            super.m_7379_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void handleCommentDataUI(List<CommentEntry> data, long nonce) {
        if (nonce != this.lastRequestNonce) {
            return;
        }
        this.commentList.addAll(data);
        this.commentList.sort(Comparator.comparingLong(entry -> -entry.timestamp));
        this.commentListOffset = Mth.m_14045_((int)this.commentListOffset, (int)0, (int)Math.max(this.commentList.size() - 1, 0));
    }

    public static void triggerOpen() {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.recordRenderCall(() -> minecraft.m_6937_(() -> {
            if (minecraft.f_91080_ instanceof CommentListScreen) {
                minecraft.f_91080_.m_7379_();
            } else {
                minecraft.m_91152_((Screen)new CommentListScreen(null));
            }
        }));
    }

    public static boolean handleKeyTab() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return false;
        }
        if (ClientRayPicking.pickedComments.isEmpty()) {
            return false;
        }
        minecraft.execute(() -> {
            if (minecraft.f_91080_ instanceof CommentListScreen) {
                minecraft.f_91080_.m_7379_();
            } else if (minecraft.f_91080_ == null) {
                minecraft.m_91152_((Screen)new CommentListScreen(ClientRayPicking.pickedComments.get(ClientRayPicking.overlayOffset)));
            }
        });
        return true;
    }
}

