/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.MainClient;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.client.Screenshot;
import forge.cn.zbx1425.worldcomment.data.network.SubmitDispatcher;
import forge.cn.zbx1425.worldcomment.data.network.SubmitJob;
import forge.cn.zbx1425.worldcomment.gui.CommentTypeButton;
import forge.cn.zbx1425.worldcomment.gui.IGuiCommon;
import forge.cn.zbx1425.worldcomment.gui.ScreenshotConfigScreen;
import forge.cn.zbx1425.worldcomment.gui.WidgetColorButton;
import forge.cn.zbx1425.worldcomment.gui.WidgetFlagLabel;
import forge.cn.zbx1425.worldcomment.gui.WidgetUnmanagedImage;
import forge.cn.zbx1425.worldcomment.item.CommentToolItem;
import forge.cn.zbx1425.worldcomment.util.OffHeapAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CommentToolScreen
extends Screen
implements IGuiCommon {
    private final byte[] imageBytes;
    private final boolean withPlacingDown;
    private static final int SIDEBAR_OFFSET = 100;
    private static final int CONTAINER_PADDING_X = 8;
    private static final int CONTAINER_PADDING_Y = 5;
    private List<CommentTypeButton> radioButtons = new ArrayList<CommentTypeButton>();
    private WidgetUnmanagedImage widgetImage;
    private MultiLineEditBox textBoxMessage;
    private Button btnScreenshotConfig;
    private Checkbox checkBoxNoImage;
    private Checkbox checkBoxAnonymous;
    private WidgetColorButton btnSaveScreenshot;
    private Button btnSendFeedback;
    private int selectedCommentType = 0;
    boolean screenshotSaved;
    public int containerWidth;
    public int containerHeight;
    public int containerOffsetX;
    public int containerOffsetY;
    private long timestampOpenGui = 0L;

    public CommentToolScreen(byte[] imageBytes, boolean withPlacingDown) {
        super((Component)Component.m_237113_((String)"Comment Tool"));
        this.imageBytes = imageBytes;
        this.withPlacingDown = withPlacingDown;
        this.screenshotSaved = false;
        ByteBuffer offHeapBuffer = OffHeapAllocator.allocate(imageBytes.length);
        try {
            offHeapBuffer.put(imageBytes);
            offHeapBuffer.rewind();
            this.widgetImage = new WidgetUnmanagedImage(new DynamicTexture(NativeImage.m_85062_((ByteBuffer)offHeapBuffer)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            OffHeapAllocator.free(offHeapBuffer);
        }
    }

    public void m_7379_() {
        this.widgetImage.close();
        super.m_7379_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        Minecraft minecraft = Minecraft.m_91087_();
        int baseY = 5;
        this.radioButtons.clear();
        assert (minecraft.f_91074_ != null && minecraft.f_91072_ != null);
        boolean canAccessBuildTools = MainClient.CLIENT_CONFIG.canAccessBuildMarkers(minecraft);
        for (int r = 0; r < (canAccessBuildTools ? 2 : 1); ++r) {
            this.m_142416_((GuiEventListener)new WidgetFlagLabel(96, baseY, CommentTypeButton.BTN_WIDTH * 4 + 10, 10, -14575885, (Component)Component.m_237115_((String)("gui.worldcomment.comment_type.r" + (r + 1)))));
            for (int c = 0; c < 4; ++c) {
                CommentTypeButton selectBtn = new CommentTypeButton(100 + CommentTypeButton.BTN_WIDTH * c, baseY + 10, r * 4 + c + 1, sender -> {
                    this.selectedCommentType = ((CommentTypeButton)sender).commentType;
                    for (CommentTypeButton radioButton : this.radioButtons) {
                        radioButton.f_93623_ = radioButton.commentType != this.selectedCommentType;
                    }
                    this.updateBtnSendFeedback();
                });
                selectBtn.f_93623_ = selectBtn.commentType != this.selectedCommentType;
                this.m_142416_((GuiEventListener)selectBtn);
                this.radioButtons.add(selectBtn);
            }
            baseY += CommentTypeButton.BTN_HEIGHT + 10;
        }
        if (!canAccessBuildTools) {
            baseY += 10;
        }
        this.m_142416_((GuiEventListener)new WidgetFlagLabel(96, baseY, CommentTypeButton.BTN_WIDTH * 5 + 10, 10, -16728876, (Component)Component.m_237115_((String)"gui.worldcomment.message")));
        this.textBoxMessage = new MultiLineEditBox(Minecraft.m_91087_().f_91062_, 100, baseY += 10, CommentTypeButton.BTN_WIDTH * 5, 80, (Component)Component.m_237115_((String)"gui.worldcomment.message.placeholder"), (Component)Component.m_237113_((String)""));
        this.textBoxMessage.m_240159_("");
        this.textBoxMessage.m_239273_(ignored -> this.updateBtnSendFeedback());
        this.m_142416_((GuiEventListener)this.textBoxMessage);
        baseY += this.textBoxMessage.m_93694_();
        this.btnSendFeedback = new WidgetColorButton(100 + CommentTypeButton.BTN_WIDTH * 3, baseY += 5, CommentTypeButton.BTN_WIDTH * 2, 20, (Component)Component.m_237115_((String)"gui.worldcomment.submit"), -3808859, sender -> this.sendReport());
        this.updateBtnSendFeedback();
        this.m_142416_((GuiEventListener)this.btnSendFeedback);
        baseY = 5;
        this.widgetImage.setBounds(0, baseY, 80);
        this.m_142416_((GuiEventListener)this.widgetImage);
        this.btnScreenshotConfig = new WidgetColorButton(0, baseY += this.widgetImage.m_93694_() + 10, CommentTypeButton.BTN_WIDTH * 2, 20, (Component)Component.m_237115_((String)"gui.worldcomment.screenshot_config"), -5592406, sender -> minecraft.m_91152_((Screen)new ScreenshotConfigScreen()));
        this.m_142416_((GuiEventListener)this.btnScreenshotConfig);
        this.checkBoxNoImage = forge.cn.zbx1425.worldcomment.util.compat.Checkbox.builder((Component)Component.m_237115_((String)"gui.worldcomment.exclude_screenshot"), minecraft.f_91062_).pos(0, baseY += 30).selected(false).build();
        this.m_142416_((GuiEventListener)this.checkBoxNoImage);
        this.checkBoxAnonymous = forge.cn.zbx1425.worldcomment.util.compat.Checkbox.builder((Component)Component.m_237115_((String)"gui.worldcomment.anonymous"), minecraft.f_91062_).pos(0, baseY += 20).selected(false).build();
        this.m_142416_((GuiEventListener)this.checkBoxAnonymous);
        this.containerWidth = 96 + CommentTypeButton.BTN_WIDTH * 5 + 10;
        this.containerHeight = this.btnSendFeedback.m_252907_() + this.btnSendFeedback.m_93694_();
        this.containerOffsetX = (this.f_96543_ - (this.containerWidth + 16)) / 2 + 8;
        this.containerOffsetY = (this.f_96544_ - (this.containerHeight + 10)) / 2 + 5;
        for (GuiEventListener child : this.m_6702_()) {
            AbstractWidget widget = (AbstractWidget)child;
            widget.m_252865_(widget.m_252754_() + this.containerOffsetX);
            widget.m_253211_(widget.m_252907_() + this.containerOffsetY);
        }
        this.btnSaveScreenshot = new WidgetColorButton(this.containerOffsetX, this.btnSendFeedback.m_252907_(), CommentTypeButton.BTN_WIDTH * 2, 20, (Component)Component.m_237115_((String)"gui.worldcomment.save_screenshot"), -8268550, sender -> {
            Path persistentPath = Screenshot.getAvailableFile().toPath();
            try {
                Files.write(persistentPath, this.imageBytes, new OpenOption[0]);
                this.screenshotSaved = true;
                this.btnSaveScreenshot.f_93623_ = false;
            }
            catch (IOException e) {
                Main.LOGGER.error("Copy image", (Throwable)e);
            }
        });
        this.btnSaveScreenshot.f_93623_ = !this.screenshotSaved;
        this.m_142416_((GuiEventListener)this.btnSaveScreenshot);
    }

    private void sendReport() {
        if (this.selectedCommentType == 0) {
            return;
        }
        Minecraft.m_91087_().execute(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            CommentEntry comment = new CommentEntry((Player)player, this.checkBoxAnonymous.m_93840_(), this.selectedCommentType, this.textBoxMessage.m_239249_());
            long jobId = SubmitDispatcher.addJob(comment, this.checkBoxNoImage.m_93840_() ? null : this.imageBytes, (arg_0, arg_1) -> CommentToolScreen.lambda$sendReport$6((Player)player, arg_0, arg_1));
            if (!this.withPlacingDown) {
                SubmitDispatcher.placeJobAt(jobId, player.m_20183_().m_175288_((int)Math.round(player.m_20182_().f_82480_ - 0.0625)));
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"gui.worldcomment.send_pending"), false);
                ItemStack item = CommentToolItem.Client.getHoldingCommentTool();
                if (item != null) {
                    CommentToolItem.setUploadJobId(item, jobId);
                }
            }
        });
        this.m_7379_();
    }

    public void m_88315_(GuiGraphics guiParam, int mouseX, int mouseY, float partialTick) {
        GuiGraphics guiGraphics = guiParam;
        this.m_280273_(guiParam);
        guiGraphics.m_280168_().m_85836_();
        boolean animationDone = this.setupAnimationTransform(guiGraphics);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
        super.m_88315_(guiParam, mouseX, mouseY, partialTick);
        guiGraphics.m_280168_().m_85849_();
    }

    public void m_280273_(GuiGraphics guiParam) {
        GuiGraphics guiGraphics = guiParam;
        super.m_280273_(guiParam);
        guiGraphics.m_280168_().m_85836_();
        this.setupAnimationTransform(guiGraphics);
        RenderSystem.enableBlend();
        guiGraphics.m_280509_(this.containerOffsetX - 8, this.containerOffsetY - 5, this.containerOffsetX + this.containerWidth + 8, this.containerOffsetY + this.containerHeight + 5, -1725816286);
        guiGraphics.m_280509_(this.containerOffsetX - 8, this.containerOffsetY + this.containerHeight - 20 + 5, this.containerOffsetX + this.containerWidth + 8, this.containerOffsetY + this.containerHeight + 5, 1716809338);
        guiGraphics.m_280168_().m_85849_();
    }

    private boolean setupAnimationTransform(GuiGraphics guiGraphics) {
        float y2;
        float y1;
        float x2;
        float x1;
        long timestampNow = System.currentTimeMillis();
        if (this.timestampOpenGui == 0L) {
            this.timestampOpenGui = timestampNow;
        }
        float animProgress = Mth.m_14036_((float)((float)(timestampNow - this.timestampOpenGui) / 600.0f), (float)0.0f, (float)1.0f);
        float s1PadW = (float)this.f_96543_ / 10.0f;
        float s1PadH = (float)this.f_96544_ / 10.0f;
        if ((double)animProgress < 0.4) {
            float subProgress = (float)Mth.m_144914_((double)animProgress, (double)0.0, (double)0.4, (double)0.0, (double)1.0);
            easedProgress = 1.0f - (float)Math.pow(1.0f - subProgress, 3.0);
            x1 = Mth.m_14179_((float)easedProgress, (float)0.0f, (float)s1PadW);
            x2 = Mth.m_14179_((float)easedProgress, (float)this.f_96543_, (float)((float)this.f_96543_ - s1PadW));
            y1 = Mth.m_14179_((float)easedProgress, (float)0.0f, (float)s1PadH);
            y2 = Mth.m_14179_((float)easedProgress, (float)this.f_96544_, (float)((float)this.f_96544_ - s1PadH));
        } else if (animProgress < 1.0f) {
            float x = (float)Mth.m_144914_((double)animProgress, (double)0.4, (double)1.0, (double)0.0, (double)1.0);
            easedProgress = x < 0.5f ? 4.0f * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0f;
            x1 = Mth.m_14179_((float)easedProgress, (float)s1PadW, (float)this.containerOffsetX);
            x2 = Mth.m_14179_((float)easedProgress, (float)((float)this.f_96543_ - s1PadW), (float)(this.containerOffsetX + this.widgetImage.m_5711_()));
            y1 = Mth.m_14179_((float)easedProgress, (float)s1PadH, (float)(this.containerOffsetY + 5));
            y2 = Mth.m_14179_((float)easedProgress, (float)((float)this.f_96544_ - s1PadH), (float)(this.containerOffsetY + 5 + this.widgetImage.m_93694_()));
        } else {
            return true;
        }
        float scaleX = (x2 - x1) / (float)this.widgetImage.m_5711_();
        float scaleY = (y2 - y1) / (float)this.widgetImage.m_93694_();
        guiGraphics.m_280168_().m_252880_(x1, y1, 0.0f);
        guiGraphics.m_280168_().m_85841_(scaleX, scaleY, 1.0f);
        guiGraphics.m_280168_().m_252880_((float)(-this.containerOffsetX), (float)(-(this.containerOffsetY + 5)), 0.0f);
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    private void updateBtnSendFeedback() {
        if (this.selectedCommentType == 0) {
            this.btnSendFeedback.f_93623_ = false;
            this.btnSendFeedback.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.worldcomment.require_comment_type").m_130940_(ChatFormatting.RED)));
        } else if (this.textBoxMessage.m_239249_().length() > 256) {
            this.btnSendFeedback.f_93623_ = false;
            this.btnSendFeedback.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.worldcomment.message_too_long").m_130940_(ChatFormatting.RED)));
        } else {
            this.btnSendFeedback.f_93623_ = true;
            this.btnSendFeedback.m_257544_(null);
        }
    }

    private static /* synthetic */ void lambda$sendReport$6(Player player, SubmitJob job, Throwable ex) {
        Minecraft.m_91087_().execute(() -> {
            if (job == null) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.worldcomment.send_finish"), false);
            } else if (ex != null) {
                player.m_5661_((Component)Component.m_237110_((String)"gui.worldcomment.send_fail", (Object[])new Object[]{ex.getClass().getName() + ": " + ex.getMessage()}), false);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"gui.worldcomment.send_upload_incomplete"), false);
            }
        });
    }
}

