/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.network.ImageDownload;
import forge.cn.zbx1425.worldcomment.gui.CommentTypeButton;
import forge.cn.zbx1425.worldcomment.gui.IGuiCommon;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;

public class WidgetCommentEntry
extends AbstractWidget
implements IGuiCommon {
    private final CommentEntry comment;
    private final Font font;
    private List<FormattedCharSequence> wrappedText = List.of();
    public boolean showImage = true;
    public static final int TOP_SINK = 12;

    public WidgetCommentEntry(CommentEntry comment) {
        super(0, 0, 0, 0, (Component)Component.m_237113_((String)comment.message));
        this.comment = comment;
        this.font = Minecraft.m_91087_().f_91062_;
        this.calculateHeight();
    }

    public void setBounds(int x, int y, int width) {
        this.m_252865_(x);
        this.m_253211_(y);
        this.m_93674_(width);
        this.calculateHeight();
    }

    private void calculateHeight() {
        int picWidth = this.comment.image.url.isEmpty() || !this.showImage ? 0 : (this.f_93618_ - 20) / 3;
        int textWidth = this.f_93618_ - 20 - picWidth - (picWidth > 0 ? 4 : 0);
        this.wrappedText = Language.m_128107_().m_128112_(this.font.m_92865_().m_92432_(this.comment.message, textWidth, Style.f_131099_));
        int textHeight = 26 + (this.comment.message.isEmpty() ? 0 : 9 * this.wrappedText.size()) + 4;
        int picHeight = 20 + (this.comment.image.url.isEmpty() || !this.showImage ? 0 : picWidth * 9 / 16) + 4 + 4;
        this.f_93619_ = Math.max(Math.max(textHeight, picHeight), 32);
    }

    protected void m_87963_(GuiGraphics guiParam, int mouseX, int mouseY, float partialTick) {
        MutableComponent nameComponent;
        GuiGraphics guiGraphics = guiParam;
        this.graphicsBlit9(guiGraphics, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 0, 0, 128, 48, 256, 256, 24, 4, 4, 28);
        int picWidth = this.comment.image.url.isEmpty() || !this.showImage ? 0 : (this.f_93618_ - 20) / 3;
        int picHeight = (this.comment.image.url.isEmpty() || !this.showImage ? 0 : picWidth * 9 / 16) + 4;
        if (!this.comment.message.isEmpty()) {
            int lineY = this.m_252907_() + 26;
            for (FormattedCharSequence formattedCharSequence : this.wrappedText) {
                guiGraphics.m_280649_(this.font, formattedCharSequence, this.m_252754_() + 16, lineY, -12303292, false);
                Objects.requireNonNull(this.font);
                lineY += 9;
            }
        }
        if (!this.comment.image.url.isEmpty() && this.showImage) {
            ImageDownload.ImageState imageToDraw = ImageDownload.getTexture(this.comment.image, true);
            RenderSystem.setShaderTexture((int)0, (int)imageToDraw.getFriendlyTexture(Minecraft.m_91087_().m_91097_()).m_117963_());
            RenderSystem.setShader(GameRenderer::m_172817_);
            Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            int x1 = this.m_252754_() + this.f_93618_ - 4 - picWidth;
            int x2 = this.m_252754_() + this.f_93618_ - 4;
            int y1 = this.m_252907_() + 20;
            int y2 = this.m_252907_() + 20 + picHeight;
            bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y1, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y2, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y2, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y1, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
        MutableComponent mutableComponent = nameComponent = this.comment.initiatorName.isEmpty() ? Component.m_237115_((String)"gui.worldcomment.anonymous") : Component.m_237113_((String)this.comment.initiatorName);
        Object uuidToDisplay = this.comment.initiatorName.isEmpty() ? (Minecraft.m_91087_().f_91074_.m_20310_(3) ? this.comment.initiator.toString() : "") : "..." + this.comment.initiator.toString().substring(24);
        guiGraphics.m_280614_(this.font, (Component)nameComponent, this.m_252754_() + 34, this.m_252907_() + 8, -1, true);
        if (this.showImage) {
            String timeStr = DateTimeFormatter.ofPattern("MM-dd HH:mm", Locale.ROOT).format(Instant.ofEpochMilli(this.comment.timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime());
            guiGraphics.m_280056_(this.font, timeStr, this.m_252754_() + this.m_5711_() - 6 - this.font.m_92895_(timeStr), this.m_252907_() + 8, -4473925, true);
        }
        RenderSystem.enableBlend();
        guiGraphics.m_280411_(ATLAS_LOCATION, this.m_252754_() + 6, this.m_252907_() + 2, 18, 18, (float)((this.comment.messageType - 1) % 4 * 64), (float)((this.comment.messageType - 1) / 4 * 64 + 128), 64, 64, 256, 256);
        if (mouseX > this.m_252754_() + 4 && mouseX < this.m_252754_() + this.m_5711_() && mouseY > this.m_252907_() && mouseY < this.m_252907_() + 24) {
            guiGraphics.m_280677_(this.font, List.of(Component.m_237115_((String)("gui.worldcomment.comment_type." + this.comment.messageType)).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(CommentTypeButton.COMMENT_TYPE_COLOR[this.comment.messageType - 1] & 0xFFFFFF)).m_7220_((Component)Component.m_237113_((String)("  (" + this.comment.location.m_123344_() + ")")).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131140_(ChatFormatting.WHITE))), Component.m_237113_((String)("  " + Instant.ofEpochMilli(this.comment.timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME))).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)), Component.m_237113_((String)("  " + nameComponent.getString() + " " + (String)uuidToDisplay)).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY))), Optional.empty(), mouseX, mouseY);
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }
}

