/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.interop;

import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.client.ClientWorldData;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class ProximityCommentSet {
    public final double distanceSqr;
    public final long timeToLive;
    public final Object2LongMap<CommentEntry> comments = new Object2LongOpenHashMap();
    public Consumer<CommentEntry> onCommentApproach;

    public ProximityCommentSet(double distance, long timeToLive) {
        this.distanceSqr = distance * distance;
        this.timeToLive = timeToLive;
    }

    public void tick(ClientWorldData worldData) {
        Minecraft minecraft = Minecraft.m_91087_();
        long currentTime = System.currentTimeMillis();
        BlockPos playerPos = minecraft.f_91074_.m_20183_();
        for (Map region : ClientWorldData.INSTANCE.regions.values()) {
            for (Map.Entry blockData : region.entrySet()) {
                for (CommentEntry comment2 : (List)blockData.getValue()) {
                    if (comment2.deleted || !(comment2.location.m_123331_((Vec3i)playerPos) <= this.distanceSqr)) continue;
                    if (!this.comments.containsKey((Object)comment2) && this.onCommentApproach != null) {
                        this.onCommentApproach.accept(comment2);
                    }
                    this.comments.put((Object)comment2, currentTime + this.timeToLive);
                }
            }
        }
        this.comments.keySet().removeIf(comment -> this.comments.getLong(comment) < currentTime);
    }

    public void clear() {
        this.comments.clear();
    }
}

