/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.item;

import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.data.network.SubmitDispatcher;
import forge.cn.zbx1425.worldcomment.item.GroupedItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class CommentToolItem
extends Item
implements GroupedItem {
    private static boolean visibilityPreference = true;
    public static float invisibleTimeRemaining = 0.0f;

    public CommentToolItem() {
        super(GroupedItem.createProperties(properties -> properties.m_41487_(1), CommentToolItem::getTabImpl));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack item = player.m_21120_(usedHand);
        if (!level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)item);
        }
        if (!item.m_150930_((Item)Main.ITEM_COMMENT_TOOL.get())) {
            return InteractionResultHolder.m_19100_((Object)item);
        }
        if (Client.placeUploadJob(level, player, item)) {
            return InteractionResultHolder.m_19090_((Object)item);
        }
        return InteractionResultHolder.m_19100_((Object)item);
    }

    @Override
    public ResourceKey<CreativeModeTab> getTab() {
        return CommentToolItem.getTabImpl();
    }

    public static ResourceKey<CreativeModeTab> getTabImpl() {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)Main.vanillaId("tools_and_utilities"));
    }

    public static Long getUploadJobId(ItemStack item) {
        if (item.m_41784_().m_128425_("uploadJobId", 4)) {
            return item.m_41784_().m_128454_("uploadJobId");
        }
        return null;
    }

    public static void setUploadJobId(ItemStack item, Long jobId) {
        if (jobId == null) {
            item.m_41784_().m_128473_("uploadJobId");
        } else {
            item.m_41784_().m_128356_("uploadJobId", jobId.longValue());
        }
    }

    public static void updateInvisibilityTimer(float deltaTicks) {
        if (invisibleTimeRemaining > 0.0f && (invisibleTimeRemaining -= deltaTicks) <= 0.0f) {
            visibilityPreference = true;
        }
    }

    public static boolean getVisibilityPreference() {
        return visibilityPreference;
    }

    public static class Client {
        public static final int COMMENT_HIDE_TICKS = 4800;

        public static ItemStack getHoldingCommentTool() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return null;
            }
            ItemStack mainHandStack = player.m_21205_();
            if (mainHandStack.m_150930_((Item)Main.ITEM_COMMENT_TOOL.get())) {
                return mainHandStack;
            }
            ItemStack offHandStack = player.m_21206_();
            if (offHandStack.m_150930_((Item)Main.ITEM_COMMENT_TOOL.get())) {
                return offHandStack;
            }
            return null;
        }

        public static boolean placeUploadJob(Level level, Player player, ItemStack item) {
            Long jobId = CommentToolItem.getUploadJobId(item);
            if (jobId != null) {
                HitResult hitResult = Minecraft.m_91087_().f_91077_;
                if (hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                    BlockPos facePos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                    boolean hasClearance = true;
                    for (int y = 0; y < 3; ++y) {
                        if (!level.m_8055_(facePos.m_7918_(0, y, 0)).m_280296_()) continue;
                        hasClearance = false;
                        break;
                    }
                    if (hasClearance) {
                        SubmitDispatcher.placeJobAt(jobId, facePos);
                        CommentToolItem.setUploadJobId(item, null);
                        return true;
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"gui.worldcomment.send_insufficient_clearance"), false);
                }
            } else if (visibilityPreference) {
                visibilityPreference = false;
                invisibleTimeRemaining = 4800.0f - invisibleTimeRemaining % 4800.0f < 60.0f ? (float)(Math.min(Math.round((invisibleTimeRemaining + 4800.0f) / 4800.0f), 4) * 4800) : 4800.0f;
            } else {
                visibilityPreference = true;
            }
            return false;
        }
    }
}

