/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.network;

import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.ServerPlatform;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.network.ImageDump;
import forge.cn.zbx1425.worldcomment.gui.CommentListScreen;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class PacketCollectionDataS2C {
    public static final ResourceLocation IDENTIFIER = Main.id("collection_data");

    public static void send(ServerPlayer target, List<CommentEntry> data, long nonce) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeLong(nonce);
        buffer.writeInt(data.size());
        for (CommentEntry comment : data) {
            buffer.m_130085_(comment.level);
            comment.writeBuffer(buffer, false);
        }
        ServerPlatform.sendPacketToPlayer(target, IDENTIFIER, buffer);
    }

    public static class ClientLogics {
        public static void handle(FriendlyByteBuf buffer) {
            long nonce = buffer.readLong();
            int commentSize = buffer.readInt();
            ArrayList<CommentEntry> comments = new ArrayList<CommentEntry>(commentSize);
            for (int j = 0; j < commentSize; ++j) {
                ResourceLocation level = buffer.m_130281_();
                CommentEntry comment = new CommentEntry(level, buffer, false);
                if (comment.deleted) continue;
                comments.add(comment);
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91080_ instanceof CommentListScreen) {
                ((CommentListScreen)minecraft.f_91080_).handleCommentDataUI(comments, nonce);
            }
            ImageDump.handleDumpResponse(comments, nonce);
        }
    }
}

