/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.network;

import forge.cn.zbx1425.worldcomment.ClientPlatform;
import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.network.PacketCollectionDataS2C;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class PacketCollectionRequestC2S {
    public static final ResourceLocation IDENTIFIER = Main.id("collection_request");

    public static void handle(MinecraftServer server, ServerPlayer initiator, FriendlyByteBuf buffer) {
        int requestType = buffer.readInt();
        long nonce = buffer.readLong();
        switch (requestType) {
            case 1: {
                UUID playerId = buffer.m_130259_();
                PacketCollectionDataS2C.send(initiator, Main.DATABASE.comments.queryPlayer(playerId), nonce);
                break;
            }
            case 2: {
                int offset = buffer.readInt();
                int limit = buffer.readInt();
                if (initiator.m_20310_(3) || limit <= 40) {
                    PacketCollectionDataS2C.send(initiator, Main.DATABASE.comments.queryLatest(offset, limit), nonce);
                    break;
                }
                PacketCollectionDataS2C.send(initiator, List.of(), nonce);
            }
        }
    }

    public static class ClientLogics {
        public static void sendPlayer(UUID playerId, long nonce) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.writeInt(1);
            buffer.writeLong(nonce);
            buffer.m_130077_(playerId);
            ClientPlatform.sendPacketToServer(IDENTIFIER, buffer);
        }

        public static void sendLatest(int offset, int limit, long nonce) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.writeInt(2);
            buffer.writeLong(nonce);
            buffer.writeInt(offset);
            buffer.writeInt(limit);
            ClientPlatform.sendPacketToServer(IDENTIFIER, buffer);
        }
    }
}

