/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.network;

import forge.cn.zbx1425.worldcomment.ClientPlatform;
import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.network.PacketImageDownloadS2C;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class PacketImageDownloadC2S {
    public static final ResourceLocation IDENTIFIER = Main.id("image_download");

    public static void handle(MinecraftServer server, ServerPlayer initiator, FriendlyByteBuf buffer) {
        String fileName = buffer.m_130277_();
        try {
            Path imageDir = server.m_129843_(LevelResource.f_78182_).resolve("world-comment").resolve("image").normalize();
            Path imagePath = imageDir.resolve(fileName).normalize();
            if (!imagePath.startsWith(imageDir)) {
                Main.LOGGER.warn("Rejected path traversal: {}", (Object)fileName);
                PacketImageDownloadS2C.sendNotFound(initiator, fileName);
                return;
            }
            if (Files.exists(imagePath, new LinkOption[0])) {
                byte[] imageData = Files.readAllBytes(imagePath);
                PacketImageDownloadS2C.send(initiator, fileName, imageData);
            } else {
                PacketImageDownloadS2C.sendNotFound(initiator, fileName);
            }
        }
        catch (IOException e) {
            Main.LOGGER.error("Failed to read image file", (Throwable)e);
        }
    }

    public static class ClientLogics {
        public static void send(String fileName) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.m_130070_(fileName);
            ClientPlatform.sendPacketToServer(IDENTIFIER, buffer);
        }
    }
}

