/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.network;

import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.ServerPlatform;
import forge.cn.zbx1425.worldcomment.data.network.upload.LocalStorageUploader;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class PacketImageDownloadS2C {
    public static final ResourceLocation IDENTIFIER = Main.id("image_download");

    public static void send(ServerPlayer target, String fileName, byte[] imageData) {
        int totalChunks = (imageData.length + 28672 - 1) / 28672;
        for (int i = 0; i < totalChunks; ++i) {
            int start = i * 28672;
            int end = Math.min(start + 28672, imageData.length);
            byte[] chunk = Arrays.copyOfRange(imageData, start, end);
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.m_130070_(fileName);
            buffer.writeInt(imageData.length);
            buffer.writeInt(i);
            buffer.writeInt(totalChunks);
            buffer.writeInt(chunk.length);
            buffer.writeBytes(chunk);
            ServerPlatform.sendPacketToPlayer(target, IDENTIFIER, buffer);
        }
    }

    public static void sendNotFound(ServerPlayer target, String fileName) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130070_(fileName);
        buffer.writeInt(0);
        buffer.writeInt(0);
        buffer.writeInt(1);
        buffer.writeInt(0);
        ServerPlatform.sendPacketToPlayer(target, IDENTIFIER, buffer);
    }

    public static class ClientLogics {
        private static final Map<String, ChunkCollector> chunkCollectors = new HashMap<String, ChunkCollector>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void handle(FriendlyByteBuf buffer) {
            ChunkCollector collector;
            String fileName = buffer.m_130277_();
            int totalSize = buffer.readInt();
            if (totalSize == 0) {
                LocalStorageUploader.completeDownloadExceptionally(fileName, new IOException("Image not found"));
                return;
            }
            int chunkIndex = buffer.readInt();
            int totalChunks = buffer.readInt();
            int chunkSize = buffer.readInt();
            byte[] chunkData = new byte[chunkSize];
            buffer.readBytes(chunkData);
            Map<String, ChunkCollector> map = chunkCollectors;
            synchronized (map) {
                collector = chunkCollectors.computeIfAbsent(fileName, k -> new ChunkCollector(totalSize, totalChunks));
            }
            int offset = chunkIndex * 28672;
            boolean isComplete = collector.addChunk(chunkIndex, chunkData, offset);
            if (isComplete) {
                Map<String, ChunkCollector> map2 = chunkCollectors;
                synchronized (map2) {
                    chunkCollectors.remove(fileName);
                }
                LocalStorageUploader.completeDownload(fileName, collector.getCompleteData());
            }
        }

        private static class ChunkCollector {
            private final byte[] completeData;
            private int receivedChunks = 0;
            private final int totalChunks;

            public ChunkCollector(int totalSize, int totalChunks) {
                this.completeData = new byte[totalSize];
                this.totalChunks = totalChunks;
            }

            public boolean addChunk(int chunkIndex, byte[] chunkData, int offset) {
                System.arraycopy(chunkData, 0, this.completeData, offset, chunkData.length);
                ++this.receivedChunks;
                return this.receivedChunks == this.totalChunks;
            }

            public byte[] getCompleteData() {
                return this.completeData;
            }
        }
    }
}

