/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.network;

import forge.cn.zbx1425.worldcomment.ClientPlatform;
import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.network.ImageConvertClient;
import forge.cn.zbx1425.worldcomment.data.network.ImageConvertServer;
import forge.cn.zbx1425.worldcomment.data.network.ThumbImage;
import forge.cn.zbx1425.worldcomment.data.network.upload.ImageUploader;
import forge.cn.zbx1425.worldcomment.network.PacketImageUploadS2C;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class PacketImageUploadC2S {
    public static final ResourceLocation IDENTIFIER = Main.id("image_upload");
    private static final DateTimeFormatter FILE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
    private static final Map<Long, ChunkCollector> chunkCollectors = new HashMap<Long, ChunkCollector>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(MinecraftServer server, ServerPlayer initiator, FriendlyByteBuf buffer) {
        ChunkCollector collector;
        long jobId = buffer.readLong();
        int totalSize = buffer.readInt();
        if (totalSize > 0xA00000) {
            return;
        }
        long timestamp = buffer.readLong();
        int chunkIndex = buffer.readInt();
        int totalChunks = buffer.readInt();
        int chunkSize = buffer.readInt();
        byte[] chunkData = new byte[chunkSize];
        buffer.readBytes(chunkData);
        Map<Long, ChunkCollector> map = chunkCollectors;
        synchronized (map) {
            collector = chunkCollectors.computeIfAbsent(jobId, k -> new ChunkCollector(totalSize, totalChunks, timestamp));
        }
        int offset = chunkIndex * 28672;
        boolean isComplete = collector.addChunk(chunkIndex, chunkData, offset);
        if (isComplete) {
            Map<Long, ChunkCollector> map2 = chunkCollectors;
            synchronized (map2) {
                chunkCollectors.remove(jobId);
            }
            try {
                byte[] completeImageData = collector.getCompleteData();
                String baseFileName = Instant.ofEpochMilli(collector.getTimestamp()).atOffset(ZoneOffset.UTC).format(FILE_DATE_FORMAT) + "-" + String.format("%016x", jobId) + "-" + initiator.m_36316_().getName();
                Path serverImagePath = server.m_129843_(LevelResource.f_78182_).resolve("world-comment").resolve("image");
                if (!Files.exists(serverImagePath, new LinkOption[0])) {
                    Files.createDirectories(serverImagePath, new FileAttribute[0]);
                }
                String fullFileName = baseFileName + ".jpg";
                Path fullFile = serverImagePath.resolve(fullFileName);
                Files.write(fullFile, completeImageData, new OpenOption[0]);
                byte[] thumbData = ImageConvertServer.toJpegScaled(completeImageData, ImageUploader.THUMBNAIL_MAX_WIDTH);
                String thumbFileName = baseFileName + ".thumb.jpg";
                Path jpgFile = serverImagePath.resolve(thumbFileName);
                Files.write(jpgFile, thumbData, new OpenOption[0]);
                ThumbImage image = new ThumbImage("file://worldcomment/" + fullFileName, "file://worldcomment/" + thumbFileName);
                PacketImageUploadS2C.send(initiator, jobId, image);
            }
            catch (IOException e) {
                PacketImageUploadS2C.sendException(initiator, jobId, e);
                Main.LOGGER.error("Failed to save uploaded image", (Throwable)e);
            }
        }
    }

    private static class ChunkCollector {
        private final byte[] completeData;
        private int receivedChunks = 0;
        private final int totalChunks;
        private final long timestamp;

        public ChunkCollector(int totalSize, int totalChunks, long timestamp) {
            this.completeData = new byte[totalSize];
            this.totalChunks = totalChunks;
            this.timestamp = timestamp;
        }

        public boolean addChunk(int chunkIndex, byte[] chunkData, int offset) {
            System.arraycopy(chunkData, 0, this.completeData, offset, chunkData.length);
            ++this.receivedChunks;
            return this.receivedChunks == this.totalChunks;
        }

        public byte[] getCompleteData() {
            return this.completeData;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class ClientLogics {
        public static void send(CommentEntry comment, byte[] imageBytes) {
            byte[] jpgData = ImageConvertClient.toJpegScaled(imageBytes, ImageUploader.IMAGE_MAX_WIDTH);
            if (jpgData.length > 0xA00000) {
                Main.LOGGER.warn("Image too large: {}B", (Object)jpgData.length);
                return;
            }
            int totalChunks = (jpgData.length + 28672 - 1) / 28672;
            for (int i = 0; i < totalChunks; ++i) {
                int start = i * 28672;
                int end = Math.min(start + 28672, jpgData.length);
                byte[] chunk = Arrays.copyOfRange(jpgData, start, end);
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                buffer.writeLong(comment.id);
                buffer.writeInt(jpgData.length);
                buffer.writeLong(comment.timestamp);
                buffer.writeInt(i);
                buffer.writeInt(totalChunks);
                buffer.writeInt(chunk.length);
                buffer.writeBytes(chunk);
                ClientPlatform.sendPacketToServer(IDENTIFIER, buffer);
            }
        }
    }
}

