/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.network;

import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.ServerPlatform;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.client.ClientWorldData;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public class PacketRegionDataS2C {
    public static final ResourceLocation IDENTIFIER = Main.id("region_data");

    public static void send(ServerPlayer target, ResourceLocation level, Map<ChunkPos, List<CommentEntry>> data) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130085_(level);
        buffer.writeInt(data.size());
        for (Map.Entry<ChunkPos, List<CommentEntry>> entry : data.entrySet()) {
            buffer.m_178341_(entry.getKey());
            buffer.writeInt(entry.getValue().size());
            for (CommentEntry comment : entry.getValue()) {
                comment.writeBuffer(buffer, false);
            }
        }
        ServerPlatform.sendPacketToPlayer(target, IDENTIFIER, buffer);
    }

    public static class ClientLogics {
        public static void handle(FriendlyByteBuf buffer) {
            ResourceLocation level = buffer.m_130281_();
            int regionSize = buffer.readInt();
            Long2ObjectOpenHashMap regions = new Long2ObjectOpenHashMap();
            for (int i = 0; i < regionSize; ++i) {
                ChunkPos region = buffer.m_178383_();
                int commentSize = buffer.readInt();
                ArrayList<CommentEntry> comments = new ArrayList<CommentEntry>(commentSize);
                for (int j = 0; j < commentSize; ++j) {
                    CommentEntry comment = new CommentEntry(level, buffer, false);
                    if (comment.deleted) continue;
                    comments.add(comment);
                }
                regions.put(region.m_45588_(), comments);
            }
            ClientWorldData.INSTANCE.acceptRegions(level, (Long2ObjectMap<List<CommentEntry>>)regions);
        }
    }
}

