/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.network;

import forge.cn.zbx1425.worldcomment.ClientPlatform;
import forge.cn.zbx1425.worldcomment.Main;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.network.PacketRegionDataS2C;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public class PacketRegionRequestC2S {
    public static final ResourceLocation IDENTIFIER = Main.id("request_region");

    public static void handle(MinecraftServer server, ServerPlayer initiator, FriendlyByteBuf buffer) {
        ResourceLocation level = buffer.m_130281_();
        Object2ObjectArrayMap results = new Object2ObjectArrayMap();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ChunkPos request = buffer.m_178383_();
            List<CommentEntry> regionResults = Main.DATABASE.comments.queryRegion(level, request);
            results.put(request, regionResults);
        }
        PacketRegionDataS2C.send(initiator, level, (Map<ChunkPos, List<CommentEntry>>)results);
    }

    public static class ClientLogics {
        public static void send(ResourceLocation level, List<ChunkPos> requests) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.m_130085_(level);
            buffer.writeInt(requests.size());
            for (ChunkPos request : requests) {
                buffer.m_178341_(request);
            }
            ClientPlatform.sendPacketToServer(IDENTIFIER, buffer);
        }
    }
}

