/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.render;

import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.client.ClientRayPicking;
import forge.cn.zbx1425.worldcomment.gui.WidgetCommentEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class CommentOverlayRenderer {
    private static final List<CommentEntry> cachedComments = new ArrayList<CommentEntry>();
    private static final List<WidgetCommentEntry> cachedWidgets = new ArrayList<WidgetCommentEntry>();
    private static int cachedWidth = 0;

    private static void calculateLayout(int width) {
        cachedComments.clear();
        cachedComments.addAll(ClientRayPicking.pickedComments);
        cachedWidgets.clear();
        int yOffset = 0;
        for (CommentEntry comment : cachedComments) {
            WidgetCommentEntry widget = new WidgetCommentEntry(comment);
            widget.setBounds(width / 2 + 10, yOffset, Math.min(width / 2 - 30, 250));
            yOffset += widget.m_93694_() + 10;
            cachedWidgets.add(widget);
        }
    }

    public static void render(GuiGraphics guiGraphics) {
        if (cachedWidth != guiGraphics.m_280182_() || !ClientRayPicking.pickedComments.equals(cachedComments)) {
            CommentOverlayRenderer.calculateLayout(guiGraphics.m_280182_());
            cachedWidth = guiGraphics.m_280182_();
        }
        if (cachedComments.size() > 0) {
            guiGraphics.m_280168_().m_85836_();
            int baseYOffset = guiGraphics.m_280206_() / 2 - (cachedWidgets.get(ClientRayPicking.overlayOffset).m_252907_() + 12);
            guiGraphics.m_280168_().m_252880_(0.0f, (float)baseYOffset, 0.0f);
            for (WidgetCommentEntry widget : cachedWidgets) {
                if (widget.m_252907_() + baseYOffset + widget.m_93694_() <= 0 || widget.m_252907_() + baseYOffset >= guiGraphics.m_280206_()) continue;
                widget.m_88315_(guiGraphics, 0, 0, 0.0f);
            }
            guiGraphics.m_280168_().m_85849_();
            if (cachedComments.size() > 1) {
                String pageStr = String.format("\u2195 %d / %d", ClientRayPicking.overlayOffset + 1, cachedComments.size());
                guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, pageStr, guiGraphics.m_280182_() / 2 - 10 - Minecraft.m_91087_().f_91062_.m_92895_(pageStr), guiGraphics.m_280206_() / 2 - 4, -5908825, true);
            }
        }
    }
}

