/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import forge.cn.zbx1425.worldcomment.MainClient;
import forge.cn.zbx1425.worldcomment.data.CommentEntry;
import forge.cn.zbx1425.worldcomment.data.client.ClientRayPicking;
import forge.cn.zbx1425.worldcomment.gui.IGuiCommon;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class CommentWorldRenderer
implements IGuiCommon {
    private static final Random RANDOM = new Random();

    public static void renderComment(VertexConsumer vertices, PoseStack matrices, CommentEntry comment, boolean focused, boolean showIcon) {
        Minecraft minecraft = Minecraft.m_91087_();
        Vec3 cameraPos = minecraft.f_91075_.m_20182_();
        RANDOM.setSeed(comment.id);
        matrices.m_85836_();
        matrices.m_252880_((float)comment.location.m_123341_() + 0.5f, (float)comment.location.m_123342_() + 1.8f, (float)comment.location.m_123343_() + 0.5f);
        float cycleRotateLength = 8000.0f;
        float cycleRotateX = (float)((System.currentTimeMillis() + RANDOM.nextLong(0L, (long)cycleRotateLength)) % (long)cycleRotateLength) / cycleRotateLength;
        float cycleRotateY = (float)Math.sin((double)cycleRotateX * Math.PI * 2.0) / 2.0f + 0.5f;
        float cycleHoverLength = focused ? 1000.0f : 8000.0f;
        float cycleHoverX = (float)((System.currentTimeMillis() + RANDOM.nextLong(0L, (long)cycleHoverLength)) % (long)cycleHoverLength) / cycleHoverLength;
        float cycleHoverY = (float)Math.sin((double)cycleHoverX * Math.PI * 2.0) / 2.0f + 0.5f;
        matrices.m_85837_((double)RANDOM.nextFloat(-0.3f, 0.3f), (double)cycleHoverY * 0.1, (double)RANDOM.nextFloat(-0.3f, 0.3f));
        float yaw = (float)Mth.m_14136_((double)((double)comment.location.m_123341_() + 0.5 - cameraPos.m_7096_()), (double)((double)comment.location.m_123343_() + 0.5 - cameraPos.m_7094_()));
        matrices.m_252781_(Axis.f_252436_.m_252961_(yaw + cycleRotateY * 0.1308997f));
        matrices.m_85841_(0.9f, 0.9f, 0.9f);
        float u1 = 0.5f;
        float v1 = 0.0f;
        float u2 = u1 + 0.125f - 0.00390625f;
        float v2 = v1 + 0.375f;
        PoseStack.Pose pose = matrices.m_85850_();
        CommentWorldRenderer.vertex(vertices, pose, 0.5f, 1.0f, 0.0f, u1, v1);
        CommentWorldRenderer.vertex(vertices, pose, 0.5f, -2.0f, 0.0f, u1, v2);
        CommentWorldRenderer.vertex(vertices, pose, -0.5f, -2.0f, 0.0f, u2, v2);
        CommentWorldRenderer.vertex(vertices, pose, -0.5f, 1.0f, 0.0f, u2, v1);
        if (showIcon) {
            matrices.m_252880_(0.0f, 0.25f, 0.0f);
            matrices.m_85841_(0.5f, 0.5f, 0.5f);
            u1 = (float)((comment.messageType - 1) % 4) * 0.25f;
            v1 = (float)((comment.messageType - 1) / 4) * 0.25f + 0.5f;
            u2 = u1 + 0.25f;
            v2 = v1 + 0.25f;
            pose = matrices.m_85850_();
            CommentWorldRenderer.vertex(vertices, pose, 0.5f, 1.0f, -0.05f, u1, v1);
            CommentWorldRenderer.vertex(vertices, pose, 0.5f, 0.0f, -0.05f, u1, v2);
            CommentWorldRenderer.vertex(vertices, pose, -0.5f, 0.0f, -0.05f, u2, v2);
            CommentWorldRenderer.vertex(vertices, pose, -0.5f, 1.0f, -0.05f, u2, v1);
        }
        matrices.m_85849_();
    }

    private static void vertex(VertexConsumer vertices, PoseStack.Pose pose, float x, float y, float z, float u, float v) {
        vertices.m_252986_(pose.m_252922_(), x, y, z).m_193479_(-1).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderComments(MultiBufferSource buffers, PoseStack matrices) {
        long currentTime = System.currentTimeMillis();
        VertexConsumer vertices = buffers.m_6299_(RenderType.m_110470_((ResourceLocation)ATLAS_LOCATION));
        for (Map.Entry<BlockPos, List<CommentEntry>> blockData : ClientRayPicking.visibleComments.entrySet()) {
            for (int i = 0; i < blockData.getValue().size(); ++i) {
                CommentEntry comment = blockData.getValue().get(i);
                boolean isVisible = MainClient.CLIENT_CONFIG.isCommentVisible(Minecraft.m_91087_(), comment);
                if (!isVisible) continue;
                boolean showIcon = blockData.getValue().size() < 2 || currentTime / 1000L % (long)blockData.getValue().size() == (long)i;
                CommentWorldRenderer.renderComment(vertices, matrices, comment, ClientRayPicking.pickedComments.contains(comment), showIcon);
            }
        }
    }
}

