/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.worldcomment.render;

import forge.cn.zbx1425.worldcomment.data.client.ClientRayPicking;
import forge.cn.zbx1425.worldcomment.data.client.Screenshot;
import forge.cn.zbx1425.worldcomment.gui.IGuiCommon;
import forge.cn.zbx1425.worldcomment.item.CommentToolItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class ControlTipRenderer
implements IGuiCommon {
    public static final ControlTip TIP_CREATE = new ControlTip((Component)Component.m_237115_((String)"gui.worldcomment.control_tip.create"), 2, Minecraft.m_91087_().f_91066_.f_92102_, false, true);
    public static final ControlTip TIP_PLACE_COMMENT = new ControlTip((Component)Component.m_237115_((String)"gui.worldcomment.control_tip.place_comment"), 0, null, true, true);
    public static final ControlTip TIP_TOGGLE_SHOW = new ControlTip(() -> Component.m_237110_((String)"gui.worldcomment.control_tip.toggle_show", (Object[])new Object[]{String.format("%02d:%02d", (int)Math.floor(CommentToolItem.invisibleTimeRemaining / 20.0f / 60.0f), (int)Math.floor(CommentToolItem.invisibleTimeRemaining / 20.0f % 60.0f))}), 0, null, true);
    public static final ControlTip TIP_TOGGLE_HIDE = new ControlTip((Component)Component.m_237115_((String)"gui.worldcomment.control_tip.toggle_hide"), 0, null, false);
    public static final ControlTip TIP_VIEW_MANAGE = new ControlTip((Component)Component.m_237115_((String)"gui.worldcomment.control_tip.view_manage"), 2, Minecraft.m_91087_().f_91066_.f_92103_, false);
    public static final ControlTip TIP_DETAIL = new ControlTip((Component)Component.m_237115_((String)"gui.worldcomment.control_tip.detail"), 2, Minecraft.m_91087_().f_91066_.f_92099_, false);
    public static final ControlTip TIP_SCROLL = new ControlTip((Component)Component.m_237115_((String)"gui.worldcomment.control_tip.scroll"), 1, null, false);
    public static final List<ControlTip> TIPS = List.of(TIP_PLACE_COMMENT, TIP_TOGGLE_SHOW, TIP_TOGGLE_HIDE, TIP_CREATE, TIP_VIEW_MANAGE, TIP_SCROLL, TIP_DETAIL);

    public static void render(GuiGraphics guiGraphics) {
        ControlTipRenderer.update();
        int yOffset = 10;
        for (ControlTip tip : TIPS) {
            if (!tip.visible) continue;
            tip.render(guiGraphics, 10, yOffset);
            if (tip.atCursor) continue;
            yOffset += 22;
        }
    }

    public static void update() {
        Minecraft minecraft = Minecraft.m_91087_();
        for (ControlTip tip : TIPS) {
            tip.visible = false;
        }
        if (minecraft.f_91074_ == null) {
            return;
        }
        if (Screenshot.isGrabbing) {
            return;
        }
        ItemStack item = CommentToolItem.Client.getHoldingCommentTool();
        if (item != null) {
            if (CommentToolItem.getUploadJobId(item) != null) {
                ControlTipRenderer.TIP_PLACE_COMMENT.visible = true;
            } else {
                ControlTipRenderer.TIP_CREATE.visible = true;
                if (CommentToolItem.getVisibilityPreference()) {
                    ControlTipRenderer.TIP_TOGGLE_HIDE.visible = true;
                } else {
                    ControlTipRenderer.TIP_TOGGLE_SHOW.visible = true;
                }
            }
            ControlTipRenderer.TIP_VIEW_MANAGE.visible = true;
        }
        if (!ClientRayPicking.pickedComments.isEmpty()) {
            if (ClientRayPicking.pickedComments.size() > 1) {
                ControlTipRenderer.TIP_SCROLL.visible = true;
            }
            ControlTipRenderer.TIP_DETAIL.visible = true;
        }
    }

    public static class ControlTip {
        public final int imgIndex;
        public final KeyMapping key;
        public final boolean critical;
        public final boolean atCursor;
        public final Supplier<Component> text;
        public boolean visible = false;

        public ControlTip(Component text, int imgIndex, KeyMapping key, boolean critical) {
            this.text = () -> text;
            this.imgIndex = imgIndex;
            this.key = key;
            this.critical = critical;
            this.atCursor = false;
        }

        public ControlTip(Component text, int imgIndex, KeyMapping key, boolean critical, boolean atCursor) {
            this.text = () -> text;
            this.imgIndex = imgIndex;
            this.key = key;
            this.critical = critical;
            this.atCursor = atCursor;
        }

        public ControlTip(Supplier<Component> text, int imgIndex, KeyMapping key, boolean critical) {
            this.text = text;
            this.imgIndex = imgIndex;
            this.key = key;
            this.critical = critical;
            this.atCursor = false;
        }

        public void render(GuiGraphics guiGraphics, int x, int y) {
            long currentTime;
            Font font = Minecraft.m_91087_().f_91062_;
            int innerWidth = 24 + font.m_92852_((FormattedText)this.text.get());
            if (this.atCursor) {
                x = guiGraphics.m_280182_() / 2 - innerWidth / 2;
                y = guiGraphics.m_280206_() / 2 - 20 - 4;
            }
            if (this.critical && (currentTime = System.currentTimeMillis()) % 400L < 200L) {
                guiGraphics.m_280509_(x + 1, y + 1, x + innerWidth + 4 + 1, y + 20 + 1, -12303292);
                guiGraphics.m_280509_(x, y, x + innerWidth + 4, y + 20, -2237082);
            }
            guiGraphics.m_280411_(IGuiCommon.ATLAS_LOCATION, x, y, 20, 20, (float)(176 + this.imgIndex * 20), 0.0f, 20, 20, 256, 256);
            if (this.key != null) {
                Component keyMessage = this.key.m_90863_();
                int keyMessageWidth = font.m_92852_((FormattedText)keyMessage);
                if (keyMessageWidth < 30) {
                    guiGraphics.m_280653_(font, keyMessage, x + 10, y + 10 - 4, -4941);
                } else {
                    guiGraphics.m_280588_(x, y, x + 20, y + 20);
                    int xOffset = (int)(System.currentTimeMillis() / 50L % (long)(keyMessageWidth + 40));
                    guiGraphics.m_280430_(font, keyMessage, x - xOffset + 20, y + 10 - 4, -4941);
                    guiGraphics.m_280618_();
                }
            }
            guiGraphics.m_280614_(font, this.text.get(), x + 20 + 4, y + 10 - 4, -1, true);
        }
    }
}

