/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core;

import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.AclCategory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.AclSetuserArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.BitFieldArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.Consumer;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.CopyArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ExpireArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.FlushMode;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.GeoAddArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.GeoArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.GeoCoordinates;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.GeoRadiusStoreArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.GeoSearch;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.GeoValue;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.GeoWithin;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.GetExArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.KeyScanCursor;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.KeyValue;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.KillArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.LMPopArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.LMoveArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.LPosArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.Limit;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.MapScanCursor;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.MigrateArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.Range;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisCommandBuilder;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisPublisher;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RestoreArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ScanArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ScanCursor;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ScoredValue;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ScoredValueScanCursor;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ScriptOutputType;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.SetArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ShutdownArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.SortArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.StrAlgoArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.StreamMessage;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.StreamScanCursor;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.StringMatchResult;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.TrackingArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.TransactionResult;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.UnblockType;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.Value;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ValueScanCursor;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.XAddArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.XAutoClaimArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.XClaimArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.XGroupCreateArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.XPendingArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.XReadArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.XTrimArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ZAddArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ZAggregateArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ZStoreArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.StatefulConnection;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.BaseRedisReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisAclReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisGeoReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisHLLReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisHashReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisListReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisScriptingReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisServerReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisSetReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisSortedSetReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisStringReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.reactive.RedisTransactionalReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.api.reactive.RedisClusterReactiveCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.Base16;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.models.stream.ClaimedMessages;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.models.stream.PendingMessage;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.models.stream.PendingMessages;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.CommandOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.KeyStreamingChannel;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.KeyValueStreamingChannel;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.ScoredValueStreamingChannel;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.ValueStreamingChannel;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.Command;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandType;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.ProtocolKeyword;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.RedisCommand;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.TracedCommand;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.resource.ClientResources;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.tracing.TraceContext;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.tracing.TraceContextProvider;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.tracing.Tracing;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Flux;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Mono;

public abstract class AbstractRedisReactiveCommands<K, V>
implements RedisAclReactiveCommands<K, V>,
RedisHashReactiveCommands<K, V>,
RedisKeyReactiveCommands<K, V>,
RedisStringReactiveCommands<K, V>,
RedisListReactiveCommands<K, V>,
RedisSetReactiveCommands<K, V>,
RedisSortedSetReactiveCommands<K, V>,
RedisScriptingReactiveCommands<K, V>,
RedisServerReactiveCommands<K, V>,
RedisHLLReactiveCommands<K, V>,
BaseRedisReactiveCommands<K, V>,
RedisTransactionalReactiveCommands<K, V>,
RedisGeoReactiveCommands<K, V>,
RedisClusterReactiveCommands<K, V> {
    private final StatefulConnection<K, V> connection;
    private final RedisCommandBuilder<K, V> commandBuilder;
    private final ClientResources clientResources;
    private final boolean tracingEnabled;
    private volatile EventExecutorGroup scheduler;

    public AbstractRedisReactiveCommands(StatefulConnection<K, V> connection, RedisCodec<K, V> codec) {
        this.connection = connection;
        this.commandBuilder = new RedisCommandBuilder<K, V>(codec);
        this.clientResources = connection.getResources();
        this.tracingEnabled = this.clientResources.tracing().isEnabled();
    }

    private EventExecutorGroup getScheduler() {
        EventExecutorGroup scheduler = this.scheduler;
        if (scheduler != null) {
            return scheduler;
        }
        ImmediateEventExecutor schedulerToUse = ImmediateEventExecutor.INSTANCE;
        if (this.connection.getOptions().isPublishOnScheduler()) {
            schedulerToUse = this.connection.getResources().eventExecutorGroup();
        }
        this.scheduler = schedulerToUse;
        return this.scheduler;
    }

    @Override
    public Mono<Set<AclCategory>> aclCat() {
        return this.createMono(this.commandBuilder::aclCat);
    }

    @Override
    public Mono<Set<CommandType>> aclCat(AclCategory category) {
        return this.createMono(() -> this.commandBuilder.aclCat(category));
    }

    @Override
    public Mono<Long> aclDeluser(String ... usernames) {
        return this.createMono(() -> this.commandBuilder.aclDeluser(usernames));
    }

    @Override
    public Mono<String> aclDryRun(String username, String command, String ... args) {
        return this.createMono(() -> this.commandBuilder.aclDryRun(username, command, args));
    }

    @Override
    public Mono<String> aclDryRun(String username, RedisCommand<K, V, ?> command) {
        return this.createMono(() -> this.commandBuilder.aclDryRun(username, command));
    }

    @Override
    public Mono<String> aclGenpass() {
        return this.createMono(this.commandBuilder::aclGenpass);
    }

    @Override
    public Mono<String> aclGenpass(int bits) {
        return this.createMono(() -> this.commandBuilder.aclGenpass(bits));
    }

    @Override
    public Mono<List<Object>> aclGetuser(String username) {
        return this.createMono(() -> this.commandBuilder.aclGetuser(username));
    }

    @Override
    public Flux<String> aclList() {
        return this.createDissolvingFlux(this.commandBuilder::aclList);
    }

    @Override
    public Mono<String> aclLoad() {
        return this.createMono(this.commandBuilder::aclLoad);
    }

    @Override
    public Flux<Map<String, Object>> aclLog() {
        return this.createDissolvingFlux(this.commandBuilder::aclLog);
    }

    @Override
    public Flux<Map<String, Object>> aclLog(int count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.aclLog(count));
    }

    @Override
    public Mono<String> aclLogReset() {
        return this.createMono(this.commandBuilder::aclLogReset);
    }

    @Override
    public Mono<String> aclSave() {
        return this.createMono(this.commandBuilder::aclSave);
    }

    @Override
    public Mono<String> aclSetuser(String username, AclSetuserArgs args) {
        return this.createMono(() -> this.commandBuilder.aclSetuser(username, args));
    }

    @Override
    public Flux<String> aclUsers() {
        return this.createDissolvingFlux(this.commandBuilder::aclUsers);
    }

    @Override
    public Mono<String> aclWhoami() {
        return this.createMono(this.commandBuilder::aclWhoami);
    }

    @Override
    public Mono<Long> append(K key, V value) {
        return this.createMono(() -> this.commandBuilder.append(key, value));
    }

    @Override
    public Mono<String> asking() {
        return this.createMono(this.commandBuilder::asking);
    }

    @Override
    public Mono<String> auth(CharSequence password) {
        return this.createMono(() -> this.commandBuilder.auth(password));
    }

    @Override
    public Mono<String> auth(String username, CharSequence password) {
        return this.createMono(() -> this.commandBuilder.auth(username, password));
    }

    @Override
    public Mono<String> bgrewriteaof() {
        return this.createMono(this.commandBuilder::bgrewriteaof);
    }

    @Override
    public Mono<String> bgsave() {
        return this.createMono(this.commandBuilder::bgsave);
    }

    @Override
    public Mono<Long> bitcount(K key) {
        return this.createMono(() -> this.commandBuilder.bitcount(key));
    }

    @Override
    public Mono<Long> bitcount(K key, long start, long end) {
        return this.createMono(() -> this.commandBuilder.bitcount(key, start, end));
    }

    @Override
    public Flux<Value<Long>> bitfield(K key, BitFieldArgs args) {
        return this.createDissolvingFlux(() -> this.commandBuilder.bitfieldValue(key, args));
    }

    @Override
    public Mono<Long> bitopAnd(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.bitopAnd(destination, keys));
    }

    @Override
    public Mono<Long> bitopNot(K destination, K source) {
        return this.createMono(() -> this.commandBuilder.bitopNot(destination, source));
    }

    @Override
    public Mono<Long> bitopOr(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.bitopOr(destination, keys));
    }

    @Override
    public Mono<Long> bitopXor(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.bitopXor(destination, keys));
    }

    @Override
    public Mono<Long> bitpos(K key, boolean state) {
        return this.createMono(() -> this.commandBuilder.bitpos(key, state));
    }

    @Override
    public Mono<Long> bitpos(K key, boolean state, long start) {
        return this.createMono(() -> this.commandBuilder.bitpos(key, state, start));
    }

    @Override
    public Mono<Long> bitpos(K key, boolean state, long start, long end) {
        return this.createMono(() -> this.commandBuilder.bitpos(key, state, start, end));
    }

    @Override
    public Mono<V> blmove(K source, K destination, LMoveArgs args, long timeout) {
        return this.createMono(() -> this.commandBuilder.blmove(source, destination, args, timeout));
    }

    @Override
    public Mono<V> blmove(K source, K destination, LMoveArgs args, double timeout) {
        return this.createMono(() -> this.commandBuilder.blmove(source, destination, args, timeout));
    }

    @Override
    public Mono<KeyValue<K, List<V>>> blmpop(long timeout, LMPopArgs args, K ... keys) {
        return this.createMono(() -> this.commandBuilder.blmpop(timeout, args, keys));
    }

    @Override
    public Mono<KeyValue<K, List<V>>> blmpop(double timeout, LMPopArgs args, K ... keys) {
        return this.createMono(() -> this.commandBuilder.blmpop(timeout, args, keys));
    }

    @Override
    public Mono<KeyValue<K, V>> blpop(long timeout, K ... keys) {
        return this.createMono(() -> this.commandBuilder.blpop(timeout, keys));
    }

    @Override
    public Mono<KeyValue<K, V>> blpop(double timeout, K ... keys) {
        return this.createMono(() -> this.commandBuilder.blpop(timeout, keys));
    }

    @Override
    public Mono<KeyValue<K, V>> brpop(long timeout, K ... keys) {
        return this.createMono(() -> this.commandBuilder.brpop(timeout, keys));
    }

    @Override
    public Mono<KeyValue<K, V>> brpop(double timeout, K ... keys) {
        return this.createMono(() -> this.commandBuilder.brpop(timeout, keys));
    }

    @Override
    public Mono<V> brpoplpush(long timeout, K source, K destination) {
        return this.createMono(() -> this.commandBuilder.brpoplpush(timeout, source, destination));
    }

    @Override
    public Mono<V> brpoplpush(double timeout, K source, K destination) {
        return this.createMono(() -> this.commandBuilder.brpoplpush(timeout, source, destination));
    }

    @Override
    public Mono<String> clientCaching(boolean enabled) {
        return this.createMono(() -> this.commandBuilder.clientCaching(enabled));
    }

    @Override
    public Mono<K> clientGetname() {
        return this.createMono(this.commandBuilder::clientGetname);
    }

    @Override
    public Mono<Long> clientGetredir() {
        return this.createMono(this.commandBuilder::clientGetredir);
    }

    @Override
    public Mono<String> clientKill(String addr) {
        return this.createMono(() -> this.commandBuilder.clientKill(addr));
    }

    @Override
    public Mono<Long> clientKill(KillArgs killArgs) {
        return this.createMono(() -> this.commandBuilder.clientKill(killArgs));
    }

    @Override
    public Mono<String> clientList() {
        return this.createMono(this.commandBuilder::clientList);
    }

    @Override
    public Mono<String> clientNoEvict(boolean on) {
        return this.createMono(() -> this.commandBuilder.clientNoEvict(on));
    }

    @Override
    public Mono<Long> clientId() {
        return this.createMono(this.commandBuilder::clientId);
    }

    @Override
    public Mono<String> clientPause(long timeout) {
        return this.createMono(() -> this.commandBuilder.clientPause(timeout));
    }

    @Override
    public Mono<String> clientSetname(K name) {
        return this.createMono(() -> this.commandBuilder.clientSetname(name));
    }

    @Override
    public Mono<String> clientTracking(TrackingArgs args) {
        return this.createMono(() -> this.commandBuilder.clientTracking(args));
    }

    @Override
    public Mono<Long> clientUnblock(long id, UnblockType type) {
        return this.createMono(() -> this.commandBuilder.clientUnblock(id, type));
    }

    public void close() {
        this.connection.close();
    }

    @Override
    public Mono<String> clusterAddSlots(int ... slots) {
        return this.createMono(() -> this.commandBuilder.clusterAddslots(slots));
    }

    @Override
    public Mono<String> clusterAddSlotsRange(Range<Integer> ... ranges) {
        return this.createMono(() -> this.commandBuilder.clusterAddSlotsRange(ranges));
    }

    @Override
    public Mono<String> clusterBumpepoch() {
        return this.createMono(() -> this.commandBuilder.clusterBumpepoch());
    }

    @Override
    public Mono<Long> clusterCountFailureReports(String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterCountFailureReports(nodeId));
    }

    @Override
    public Mono<Long> clusterCountKeysInSlot(int slot) {
        return this.createMono(() -> this.commandBuilder.clusterCountKeysInSlot(slot));
    }

    @Override
    public Mono<String> clusterDelSlots(int ... slots) {
        return this.createMono(() -> this.commandBuilder.clusterDelslots(slots));
    }

    @Override
    public Mono<String> clusterDelSlotsRange(Range<Integer> ... ranges) {
        return this.createMono(() -> this.commandBuilder.clusterDelSlotsRange(ranges));
    }

    @Override
    public Mono<String> clusterFailover(boolean force) {
        return this.createMono(() -> this.commandBuilder.clusterFailover(force));
    }

    @Override
    public Mono<String> clusterFlushslots() {
        return this.createMono(this.commandBuilder::clusterFlushslots);
    }

    @Override
    public Mono<String> clusterForget(String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterForget(nodeId));
    }

    @Override
    public Flux<K> clusterGetKeysInSlot(int slot, int count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.clusterGetKeysInSlot(slot, count));
    }

    @Override
    public Mono<String> clusterInfo() {
        return this.createMono(this.commandBuilder::clusterInfo);
    }

    @Override
    public Mono<Long> clusterKeyslot(K key) {
        return this.createMono(() -> this.commandBuilder.clusterKeyslot(key));
    }

    @Override
    public Mono<String> clusterMeet(String ip, int port) {
        return this.createMono(() -> this.commandBuilder.clusterMeet(ip, port));
    }

    @Override
    public Mono<String> clusterMyId() {
        return this.createMono(this.commandBuilder::clusterMyId);
    }

    @Override
    public Mono<String> clusterNodes() {
        return this.createMono(this.commandBuilder::clusterNodes);
    }

    @Override
    public Mono<String> clusterReplicate(String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterReplicate(nodeId));
    }

    @Override
    public Flux<String> clusterReplicas(String nodeId) {
        return this.createDissolvingFlux(() -> this.commandBuilder.clusterReplicas(nodeId));
    }

    @Override
    public Mono<String> clusterReset(boolean hard) {
        return this.createMono(() -> this.commandBuilder.clusterReset(hard));
    }

    @Override
    public Mono<String> clusterSaveconfig() {
        return this.createMono(() -> this.commandBuilder.clusterSaveconfig());
    }

    @Override
    public Mono<String> clusterSetConfigEpoch(long configEpoch) {
        return this.createMono(() -> this.commandBuilder.clusterSetConfigEpoch(configEpoch));
    }

    @Override
    public Mono<String> clusterSetSlotImporting(int slot, String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterSetSlotImporting(slot, nodeId));
    }

    @Override
    public Mono<String> clusterSetSlotMigrating(int slot, String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterSetSlotMigrating(slot, nodeId));
    }

    @Override
    public Mono<String> clusterSetSlotNode(int slot, String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterSetSlotNode(slot, nodeId));
    }

    @Override
    public Mono<String> clusterSetSlotStable(int slot) {
        return this.createMono(() -> this.commandBuilder.clusterSetSlotStable(slot));
    }

    @Override
    public Mono<List<Object>> clusterShards() {
        return this.createMono(() -> this.commandBuilder.clusterShards());
    }

    @Override
    public Flux<String> clusterSlaves(String nodeId) {
        return this.createDissolvingFlux(() -> this.commandBuilder.clusterSlaves(nodeId));
    }

    @Override
    public Flux<Object> clusterSlots() {
        return this.createDissolvingFlux(this.commandBuilder::clusterSlots);
    }

    @Override
    public Flux<Object> command() {
        return this.createDissolvingFlux(this.commandBuilder::command);
    }

    @Override
    public Mono<Long> commandCount() {
        return this.createMono(this.commandBuilder::commandCount);
    }

    @Override
    public Flux<Object> commandInfo(String ... commands) {
        return this.createDissolvingFlux(() -> this.commandBuilder.commandInfo(commands));
    }

    @Override
    public Flux<Object> commandInfo(CommandType ... commands) {
        String[] stringCommands = new String[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            stringCommands[i] = commands[i].name();
        }
        return this.commandInfo(stringCommands);
    }

    @Override
    public Mono<Map<String, String>> configGet(String parameter) {
        return this.createMono(() -> this.commandBuilder.configGet(parameter));
    }

    @Override
    public Mono<Map<String, String>> configGet(String ... parameters) {
        return this.createMono(() -> this.commandBuilder.configGet(parameters));
    }

    @Override
    public Mono<String> configResetstat() {
        return this.createMono(this.commandBuilder::configResetstat);
    }

    @Override
    public Mono<String> configRewrite() {
        return this.createMono(this.commandBuilder::configRewrite);
    }

    @Override
    public Mono<String> configSet(String parameter, String value) {
        return this.createMono(() -> this.commandBuilder.configSet(parameter, value));
    }

    @Override
    public Mono<String> configSet(Map<String, String> kvs) {
        return this.createMono(() -> this.commandBuilder.configSet(kvs));
    }

    public <T, R> Flux<R> createDissolvingFlux(Supplier<RedisCommand<K, V, T>> commandSupplier) {
        return this.createFlux(commandSupplier, true);
    }

    public <T> Flux<T> createFlux(Supplier<RedisCommand<K, V, T>> commandSupplier) {
        return this.createFlux(commandSupplier, false);
    }

    private <T> Flux<T> createFlux(Supplier<RedisCommand<K, V, T>> commandSupplier, boolean dissolve) {
        if (this.tracingEnabled) {
            return this.withTraceContext().flatMapMany(it -> Flux.from(new RedisPublisher(this.decorate(commandSupplier, (TraceContext)it), this.connection, dissolve, (Executor)this.getScheduler().next())));
        }
        return Flux.from(new RedisPublisher<K, V, T>(commandSupplier, this.connection, dissolve, (Executor)this.getScheduler().next()));
    }

    private Mono<TraceContext> withTraceContext() {
        return Tracing.getContext().switchIfEmpty(Mono.fromSupplier(() -> this.clientResources.tracing().initialTraceContextProvider())).flatMap(TraceContextProvider::getTraceContextLater).defaultIfEmpty(TraceContext.EMPTY);
    }

    protected <T> Mono<T> createMono(CommandType type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        return this.createMono(() -> new Command(type, output, args));
    }

    public <T> Mono<T> createMono(Supplier<RedisCommand<K, V, T>> commandSupplier) {
        if (this.tracingEnabled) {
            return this.withTraceContext().flatMap(it -> Mono.from(new RedisPublisher(this.decorate(commandSupplier, (TraceContext)it), this.connection, false, (Executor)this.getScheduler().next())));
        }
        return Mono.from(new RedisPublisher<K, V, T>(commandSupplier, this.connection, false, (Executor)this.getScheduler().next()));
    }

    private <T> Supplier<RedisCommand<K, V, T>> decorate(Supplier<RedisCommand<K, V, T>> commandSupplier, TraceContext traceContext) {
        return () -> new TracedCommand((RedisCommand)commandSupplier.get(), traceContext);
    }

    @Override
    public Mono<Long> dbsize() {
        return this.createMono(this.commandBuilder::dbsize);
    }

    @Override
    public Mono<String> debugCrashAndRecover(Long delay) {
        return this.createMono(() -> this.commandBuilder.debugCrashAndRecover(delay));
    }

    @Override
    public Mono<String> debugHtstats(int db) {
        return this.createMono(() -> this.commandBuilder.debugHtstats(db));
    }

    @Override
    public Mono<String> debugObject(K key) {
        return this.createMono(() -> this.commandBuilder.debugObject(key));
    }

    @Override
    public Mono<Void> debugOom() {
        return this.createMono(this.commandBuilder::debugOom).then();
    }

    @Override
    public Mono<String> debugReload() {
        return this.createMono(() -> this.commandBuilder.debugReload());
    }

    @Override
    public Mono<String> debugRestart(Long delay) {
        return this.createMono(() -> this.commandBuilder.debugRestart(delay));
    }

    @Override
    public Mono<String> debugSdslen(K key) {
        return this.createMono(() -> this.commandBuilder.debugSdslen(key));
    }

    @Override
    public Mono<Void> debugSegfault() {
        return this.createFlux(this.commandBuilder::debugSegfault).then();
    }

    @Override
    public Mono<Long> decr(K key) {
        return this.createMono(() -> this.commandBuilder.decr(key));
    }

    @Override
    public Mono<Long> decrby(K key, long amount) {
        return this.createMono(() -> this.commandBuilder.decrby(key, amount));
    }

    @Override
    public Mono<Long> del(K ... keys) {
        return this.createMono(() -> this.commandBuilder.del(keys));
    }

    public Mono<Long> del(Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.del(keys));
    }

    @Override
    public String digest(String script) {
        return this.digest(this.encodeScript(script));
    }

    @Override
    public String digest(byte[] script) {
        return Base16.digest(script);
    }

    @Override
    public Mono<String> discard() {
        return this.createMono(this.commandBuilder::discard);
    }

    @Override
    public <T> Flux<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, ?> output) {
        LettuceAssert.notNull((Object)type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        return this.createFlux(() -> new Command(type, output));
    }

    @Override
    public <T> Flux<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, ?> output, CommandArgs<K, V> args) {
        LettuceAssert.notNull((Object)type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        LettuceAssert.notNull(args, "CommandArgs type must not be null");
        return this.createFlux(() -> new Command(type, output, args));
    }

    @Override
    public Mono<byte[]> dump(K key) {
        return this.createMono(() -> this.commandBuilder.dump(key));
    }

    @Override
    public Mono<V> echo(V msg) {
        return this.createMono(() -> this.commandBuilder.echo(msg));
    }

    @Override
    public <T> Flux<T> eval(String script, ScriptOutputType type, K ... keys) {
        return this.eval(this.encodeScript(script), type, keys);
    }

    @Override
    public <T> Flux<T> eval(byte[] script, ScriptOutputType type, K ... keys) {
        return this.createFlux(() -> this.commandBuilder.eval(script, type, keys, new Object[0]));
    }

    @Override
    public <T> Flux<T> eval(String script, ScriptOutputType type, K[] keys, V ... values) {
        return this.eval(this.encodeScript(script), type, keys, values);
    }

    @Override
    public <T> Flux<T> eval(byte[] script, ScriptOutputType type, K[] keys, V ... values) {
        return this.createFlux(() -> this.commandBuilder.eval(script, type, keys, values));
    }

    @Override
    public <T> Flux<T> evalReadOnly(byte[] script, ScriptOutputType type, K[] keys, V ... values) {
        return this.createFlux(() -> this.commandBuilder.eval(script, type, true, keys, values));
    }

    @Override
    public <T> Flux<T> evalsha(String digest, ScriptOutputType type, K ... keys) {
        return this.createFlux(() -> this.commandBuilder.evalsha(digest, type, keys, new Object[0]));
    }

    @Override
    public <T> Flux<T> evalsha(String digest, ScriptOutputType type, K[] keys, V ... values) {
        return this.createFlux(() -> this.commandBuilder.evalsha(digest, type, keys, values));
    }

    @Override
    public <T> Flux<T> evalshaReadOnly(String digest, ScriptOutputType type, K[] keys, V ... values) {
        return this.createFlux(() -> this.commandBuilder.evalsha(digest, type, true, keys, values));
    }

    @Override
    public Mono<TransactionResult> exec() {
        return this.createMono(CommandType.EXEC, null, null);
    }

    public Mono<Boolean> exists(K key) {
        return this.createMono(() -> this.commandBuilder.exists((Object)key));
    }

    @Override
    public Mono<Long> exists(K ... keys) {
        return this.createMono(() -> this.commandBuilder.exists(keys));
    }

    public Mono<Long> exists(Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.exists(keys));
    }

    @Override
    public Mono<Boolean> expire(K key, long seconds) {
        return this.expire(key, seconds, null);
    }

    @Override
    public Mono<Boolean> expire(K key, long seconds, ExpireArgs expireArgs) {
        return this.createMono(() -> this.commandBuilder.expire(key, seconds, expireArgs));
    }

    @Override
    public Mono<Boolean> expire(K key, Duration seconds) {
        return this.expire(key, seconds, null);
    }

    @Override
    public Mono<Boolean> expire(K key, Duration seconds, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)seconds, "Timeout must not be null");
        return this.expire(key, seconds.toMillis() / 1000L, expireArgs);
    }

    @Override
    public Mono<Boolean> expireat(K key, long timestamp) {
        return this.expireat(key, timestamp, null);
    }

    @Override
    public Mono<Boolean> expireat(K key, long timestamp, ExpireArgs expireArgs) {
        return this.createMono(() -> this.commandBuilder.expireat(key, timestamp, expireArgs));
    }

    @Override
    public Mono<Boolean> expireat(K key, Date timestamp) {
        return this.expireat(key, timestamp, null);
    }

    @Override
    public Mono<Boolean> expireat(K key, Date timestamp, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.expireat(key, timestamp.getTime() / 1000L, expireArgs);
    }

    @Override
    public Mono<Boolean> expireat(K key, Instant timestamp) {
        return this.expireat(key, timestamp, null);
    }

    @Override
    public Mono<Boolean> expireat(K key, Instant timestamp, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.expireat(key, timestamp.toEpochMilli() / 1000L, expireArgs);
    }

    @Override
    public Mono<Long> expiretime(K key) {
        return this.createMono(() -> this.commandBuilder.expiretime(key));
    }

    @Override
    public void flushCommands() {
        this.connection.flushCommands();
    }

    @Override
    public Mono<String> flushall() {
        return this.createMono(this.commandBuilder::flushall);
    }

    @Override
    public Mono<String> flushall(FlushMode flushMode) {
        return this.createMono(() -> this.commandBuilder.flushall(flushMode));
    }

    @Override
    public Mono<String> flushallAsync() {
        return this.flushall(FlushMode.ASYNC);
    }

    @Override
    public Mono<String> flushdb() {
        return this.createMono(this.commandBuilder::flushdb);
    }

    @Override
    public Mono<String> flushdb(FlushMode flushMode) {
        return this.createMono(() -> this.commandBuilder.flushdb(flushMode));
    }

    @Override
    public Mono<String> flushdbAsync() {
        return this.flushdb(FlushMode.ASYNC);
    }

    @Override
    public Mono<Long> geoadd(K key, double longitude, double latitude, V member) {
        return this.geoadd(key, longitude, latitude, member, null);
    }

    @Override
    public Mono<Long> geoadd(K key, double longitude, double latitude, V member, GeoAddArgs args) {
        return this.createMono(() -> this.commandBuilder.geoadd(key, longitude, latitude, member, args));
    }

    @Override
    public Mono<Long> geoadd(K key, Object ... lngLatMember) {
        return this.createMono(() -> this.commandBuilder.geoadd(key, lngLatMember, null));
    }

    @Override
    public Mono<Long> geoadd(K key, GeoValue<V> ... values) {
        return this.createMono(() -> this.commandBuilder.geoadd(key, values, (GeoAddArgs)null));
    }

    @Override
    public Mono<Long> geoadd(K key, GeoAddArgs args, Object ... lngLatMember) {
        return this.createMono(() -> this.commandBuilder.geoadd(key, lngLatMember, args));
    }

    @Override
    public Mono<Long> geoadd(K key, GeoAddArgs args, GeoValue<V> ... values) {
        return this.createMono(() -> this.commandBuilder.geoadd(key, values, args));
    }

    @Override
    public Mono<Double> geodist(K key, V from, V to, GeoArgs.Unit unit) {
        return this.createMono(() -> this.commandBuilder.geodist(key, from, to, unit));
    }

    @Override
    public Flux<Value<String>> geohash(K key, V ... members) {
        return this.createDissolvingFlux(() -> this.commandBuilder.geohash(key, members));
    }

    @Override
    public Flux<Value<GeoCoordinates>> geopos(K key, V ... members) {
        return this.createDissolvingFlux(() -> this.commandBuilder.geoposValues(key, members));
    }

    @Override
    public Flux<V> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadius(CommandType.GEORADIUS, key, longitude, latitude, distance, unit.name()));
    }

    @Override
    public Flux<GeoWithin<V>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadius(CommandType.GEORADIUS, key, longitude, latitude, distance, unit.name(), geoArgs));
    }

    @Override
    public Mono<Long> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        return this.createMono(() -> this.commandBuilder.georadius(key, longitude, latitude, distance, unit.name(), geoRadiusStoreArgs));
    }

    protected Flux<V> georadius_ro(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadius(CommandType.GEORADIUS_RO, key, longitude, latitude, distance, unit.name()));
    }

    protected Flux<GeoWithin<V>> georadius_ro(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadius(CommandType.GEORADIUS_RO, key, longitude, latitude, distance, unit.name(), geoArgs));
    }

    @Override
    public Flux<V> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER, key, member, distance, unit.name()));
    }

    @Override
    public Flux<GeoWithin<V>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER, key, member, distance, unit.name(), geoArgs));
    }

    @Override
    public Mono<Long> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        return this.createMono(() -> this.commandBuilder.georadiusbymember(key, member, distance, unit.name(), geoRadiusStoreArgs));
    }

    protected Flux<V> georadiusbymember_ro(K key, V member, double distance, GeoArgs.Unit unit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER_RO, key, member, distance, unit.name()));
    }

    protected Flux<GeoWithin<V>> georadiusbymember_ro(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER_RO, key, member, distance, unit.name(), geoArgs));
    }

    @Override
    public Flux<V> geosearch(K key, GeoSearch.GeoRef<K> reference, GeoSearch.GeoPredicate predicate) {
        return this.createDissolvingFlux(() -> this.commandBuilder.geosearch(key, reference, predicate));
    }

    @Override
    public Flux<GeoWithin<V>> geosearch(K key, GeoSearch.GeoRef<K> reference, GeoSearch.GeoPredicate predicate, GeoArgs geoArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.geosearch(key, reference, predicate, geoArgs));
    }

    @Override
    public Mono<Long> geosearchstore(K destination, K key, GeoSearch.GeoRef<K> reference, GeoSearch.GeoPredicate predicate, GeoArgs geoArgs, boolean storeDist) {
        return this.createMono(() -> this.commandBuilder.geosearchstore(destination, key, reference, predicate, geoArgs, storeDist));
    }

    @Override
    public Mono<V> get(K key) {
        return this.createMono(() -> this.commandBuilder.get(key));
    }

    public StatefulConnection<K, V> getConnection() {
        return this.connection;
    }

    @Override
    public Mono<Long> getbit(K key, long offset) {
        return this.createMono(() -> this.commandBuilder.getbit(key, offset));
    }

    @Override
    public Mono<V> getdel(K key) {
        return this.createMono(() -> this.commandBuilder.getdel(key));
    }

    @Override
    public Mono<V> getex(K key, GetExArgs args) {
        return this.createMono(() -> this.commandBuilder.getex(key, args));
    }

    @Override
    public Mono<V> getrange(K key, long start, long end) {
        return this.createMono(() -> this.commandBuilder.getrange(key, start, end));
    }

    @Override
    public Mono<V> getset(K key, V value) {
        return this.createMono(() -> this.commandBuilder.getset(key, value));
    }

    @Override
    public Mono<Long> hdel(K key, K ... fields) {
        return this.createMono(() -> this.commandBuilder.hdel(key, fields));
    }

    @Override
    public Mono<Boolean> hexists(K key, K field) {
        return this.createMono(() -> this.commandBuilder.hexists(key, field));
    }

    @Override
    public Mono<V> hget(K key, K field) {
        return this.createMono(() -> this.commandBuilder.hget(key, field));
    }

    @Override
    public Flux<KeyValue<K, V>> hgetall(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.hgetallKeyValue(key));
    }

    @Override
    public Mono<Long> hgetall(KeyValueStreamingChannel<K, V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.hgetall(channel, key));
    }

    @Override
    public Mono<Long> hincrby(K key, K field, long amount) {
        return this.createMono(() -> this.commandBuilder.hincrby(key, field, amount));
    }

    @Override
    public Mono<Double> hincrbyfloat(K key, K field, double amount) {
        return this.createMono(() -> this.commandBuilder.hincrbyfloat(key, field, amount));
    }

    @Override
    public Flux<K> hkeys(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.hkeys(key));
    }

    @Override
    public Mono<Long> hkeys(KeyStreamingChannel<K> channel, K key) {
        return this.createMono(() -> this.commandBuilder.hkeys(channel, key));
    }

    @Override
    public Mono<Long> hlen(K key) {
        return this.createMono(() -> this.commandBuilder.hlen(key));
    }

    @Override
    public Flux<KeyValue<K, V>> hmget(K key, K ... fields) {
        return this.createDissolvingFlux(() -> this.commandBuilder.hmgetKeyValue(key, fields));
    }

    @Override
    public Mono<Long> hmget(KeyValueStreamingChannel<K, V> channel, K key, K ... fields) {
        return this.createMono(() -> this.commandBuilder.hmget(channel, key, fields));
    }

    @Override
    public Mono<K> hrandfield(K key) {
        return this.createMono(() -> this.commandBuilder.hrandfield(key));
    }

    @Override
    public Flux<K> hrandfield(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.hrandfield(key, count));
    }

    @Override
    public Mono<KeyValue<K, V>> hrandfieldWithvalues(K key) {
        return this.createMono(() -> this.commandBuilder.hrandfieldWithvalues(key));
    }

    @Override
    public Flux<KeyValue<K, V>> hrandfieldWithvalues(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.hrandfieldWithvalues(key, count));
    }

    @Override
    public Mono<String> hmset(K key, Map<K, V> map) {
        return this.createMono(() -> this.commandBuilder.hmset(key, map));
    }

    @Override
    public Mono<MapScanCursor<K, V>> hscan(K key) {
        return this.createMono(() -> this.commandBuilder.hscan(key));
    }

    @Override
    public Mono<MapScanCursor<K, V>> hscan(K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.hscan(key, scanArgs));
    }

    @Override
    public Mono<MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.hscan(key, scanCursor, scanArgs));
    }

    @Override
    public Mono<MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.hscan(key, scanCursor));
    }

    @Override
    public Mono<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.hscanStreaming(channel, key));
    }

    @Override
    public Mono<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.hscanStreaming(channel, key, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.hscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.hscanStreaming(channel, key, scanCursor));
    }

    @Override
    public Mono<Boolean> hset(K key, K field, V value) {
        return this.createMono(() -> this.commandBuilder.hset(key, field, value));
    }

    @Override
    public Mono<Long> hset(K key, Map<K, V> map) {
        return this.createMono(() -> this.commandBuilder.hset(key, map));
    }

    @Override
    public Mono<Boolean> hsetnx(K key, K field, V value) {
        return this.createMono(() -> this.commandBuilder.hsetnx(key, field, value));
    }

    @Override
    public Mono<Long> hstrlen(K key, K field) {
        return this.createMono(() -> this.commandBuilder.hstrlen(key, field));
    }

    @Override
    public Flux<V> hvals(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.hvals(key));
    }

    @Override
    public Mono<Long> hvals(ValueStreamingChannel<V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.hvals(channel, key));
    }

    @Override
    public Mono<Long> incr(K key) {
        return this.createMono(() -> this.commandBuilder.incr(key));
    }

    @Override
    public Mono<Long> incrby(K key, long amount) {
        return this.createMono(() -> this.commandBuilder.incrby(key, amount));
    }

    @Override
    public Mono<Double> incrbyfloat(K key, double amount) {
        return this.createMono(() -> this.commandBuilder.incrbyfloat(key, amount));
    }

    @Override
    public Mono<String> info() {
        return this.createMono(this.commandBuilder::info);
    }

    @Override
    public Mono<String> info(String section) {
        return this.createMono(() -> this.commandBuilder.info(section));
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public Flux<K> keys(K pattern) {
        return this.createDissolvingFlux(() -> this.commandBuilder.keys(pattern));
    }

    @Override
    public Mono<Long> keys(KeyStreamingChannel<K> channel, K pattern) {
        return this.createMono(() -> this.commandBuilder.keys(channel, pattern));
    }

    @Override
    public Mono<Date> lastsave() {
        return this.createMono(this.commandBuilder::lastsave);
    }

    @Override
    public Mono<V> lindex(K key, long index) {
        return this.createMono(() -> this.commandBuilder.lindex(key, index));
    }

    @Override
    public Mono<Long> linsert(K key, boolean before, V pivot, V value) {
        return this.createMono(() -> this.commandBuilder.linsert(key, before, pivot, value));
    }

    @Override
    public Mono<Long> llen(K key) {
        return this.createMono(() -> this.commandBuilder.llen(key));
    }

    @Override
    public Mono<V> lmove(K source, K destination, LMoveArgs args) {
        return this.createMono(() -> this.commandBuilder.lmove(source, destination, args));
    }

    @Override
    public Mono<KeyValue<K, List<V>>> lmpop(LMPopArgs args, K ... keys) {
        return this.createMono(() -> this.commandBuilder.lmpop(args, keys));
    }

    @Override
    public Mono<V> lpop(K key) {
        return this.createMono(() -> this.commandBuilder.lpop(key));
    }

    @Override
    public Flux<V> lpop(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.lpop(key, count));
    }

    @Override
    public Mono<Long> lpos(K key, V value) {
        return this.lpos(key, value, null);
    }

    @Override
    public Mono<Long> lpos(K key, V value, LPosArgs args) {
        return this.createMono(() -> this.commandBuilder.lpos(key, value, args));
    }

    @Override
    public Flux<Long> lpos(K key, V value, int count) {
        return this.lpos(key, value, count, null);
    }

    @Override
    public Flux<Long> lpos(K key, V value, int count, LPosArgs args) {
        return this.createDissolvingFlux(() -> this.commandBuilder.lpos(key, value, count, args));
    }

    @Override
    public Mono<Long> lpush(K key, V ... values) {
        return this.createMono(() -> this.commandBuilder.lpush(key, values));
    }

    @Override
    public Mono<Long> lpushx(K key, V ... values) {
        return this.createMono(() -> this.commandBuilder.lpushx(key, values));
    }

    @Override
    public Flux<V> lrange(K key, long start, long stop) {
        return this.createDissolvingFlux(() -> this.commandBuilder.lrange(key, start, stop));
    }

    @Override
    public Mono<Long> lrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.lrange(channel, key, start, stop));
    }

    @Override
    public Mono<Long> lrem(K key, long count, V value) {
        return this.createMono(() -> this.commandBuilder.lrem(key, count, value));
    }

    @Override
    public Mono<String> lset(K key, long index, V value) {
        return this.createMono(() -> this.commandBuilder.lset(key, index, value));
    }

    @Override
    public Mono<String> ltrim(K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.ltrim(key, start, stop));
    }

    @Override
    public Mono<Long> memoryUsage(K key) {
        return this.createMono(() -> this.commandBuilder.memoryUsage(key));
    }

    @Override
    public Flux<KeyValue<K, V>> mget(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.mgetKeyValue(keys));
    }

    public Flux<KeyValue<K, V>> mget(Iterable<K> keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.mgetKeyValue(keys));
    }

    @Override
    public Mono<Long> mget(KeyValueStreamingChannel<K, V> channel, K ... keys) {
        return this.createMono(() -> this.commandBuilder.mget(channel, keys));
    }

    public Mono<Long> mget(ValueStreamingChannel<V> channel, Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.mget(channel, keys));
    }

    public Mono<Long> mget(KeyValueStreamingChannel<K, V> channel, Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.mget(channel, keys));
    }

    @Override
    public Mono<String> migrate(String host, int port, K key, int db, long timeout) {
        return this.createMono(() -> this.commandBuilder.migrate(host, port, key, db, timeout));
    }

    @Override
    public Mono<String> migrate(String host, int port, int db, long timeout, MigrateArgs<K> migrateArgs) {
        return this.createMono(() -> this.commandBuilder.migrate(host, port, db, timeout, migrateArgs));
    }

    @Override
    public Mono<Boolean> move(K key, int db) {
        return this.createMono(() -> this.commandBuilder.move(key, db));
    }

    @Override
    public Mono<String> mset(Map<K, V> map) {
        return this.createMono(() -> this.commandBuilder.mset(map));
    }

    @Override
    public Mono<Boolean> msetnx(Map<K, V> map) {
        return this.createMono(() -> this.commandBuilder.msetnx(map));
    }

    @Override
    public Mono<String> multi() {
        return this.createMono(this.commandBuilder::multi);
    }

    @Override
    public Mono<String> objectEncoding(K key) {
        return this.createMono(() -> this.commandBuilder.objectEncoding(key));
    }

    @Override
    public Mono<Long> objectFreq(K key) {
        return this.createMono(() -> this.commandBuilder.objectFreq(key));
    }

    @Override
    public Mono<Long> objectIdletime(K key) {
        return this.createMono(() -> this.commandBuilder.objectIdletime(key));
    }

    @Override
    public Mono<Long> objectRefcount(K key) {
        return this.createMono(() -> this.commandBuilder.objectRefcount(key));
    }

    @Override
    public Mono<Boolean> persist(K key) {
        return this.createMono(() -> this.commandBuilder.persist(key));
    }

    @Override
    public Mono<Boolean> pexpire(K key, long milliseconds) {
        return this.pexpire(key, milliseconds, null);
    }

    @Override
    public Mono<Boolean> pexpire(K key, long milliseconds, ExpireArgs expireArgs) {
        return this.createMono(() -> this.commandBuilder.pexpire(key, milliseconds, expireArgs));
    }

    @Override
    public Mono<Boolean> pexpire(K key, Duration milliseconds) {
        return this.pexpire(key, milliseconds, null);
    }

    @Override
    public Mono<Boolean> pexpire(K key, Duration milliseconds, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)milliseconds, "Timeout must not be null");
        return this.pexpire(key, milliseconds.toMillis(), expireArgs);
    }

    @Override
    public Mono<Boolean> pexpireat(K key, Date timestamp) {
        return this.pexpireat(key, timestamp, null);
    }

    @Override
    public Mono<Boolean> pexpireat(K key, Date timestamp, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pexpireat(key, timestamp.getTime(), expireArgs);
    }

    @Override
    public Mono<Boolean> pexpireat(K key, Instant timestamp) {
        return this.pexpireat(key, timestamp, null);
    }

    @Override
    public Mono<Boolean> pexpireat(K key, Instant timestamp, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pexpireat(key, timestamp.toEpochMilli(), expireArgs);
    }

    @Override
    public Mono<Boolean> pexpireat(K key, long timestamp) {
        return this.pexpireat(key, timestamp, null);
    }

    @Override
    public Mono<Boolean> pexpireat(K key, long timestamp, ExpireArgs expireArgs) {
        return this.createMono(() -> this.commandBuilder.pexpireat(key, timestamp, expireArgs));
    }

    @Override
    public Mono<Long> pexpiretime(K key) {
        return this.createMono(() -> this.commandBuilder.pexpiretime(key));
    }

    @Override
    public Mono<Long> pfadd(K key, V ... values) {
        return this.createMono(() -> this.commandBuilder.pfadd(key, values));
    }

    public Mono<Long> pfadd(K key, V value, V ... values) {
        return this.createMono(() -> this.commandBuilder.pfadd((Object)key, (Object)value, values));
    }

    @Override
    public Mono<Long> pfcount(K ... keys) {
        return this.createMono(() -> this.commandBuilder.pfcount(keys));
    }

    public Mono<Long> pfcount(K key, K ... keys) {
        return this.createMono(() -> this.commandBuilder.pfcount((Object)key, keys));
    }

    @Override
    public Mono<String> pfmerge(K destkey, K ... sourcekeys) {
        return this.createMono(() -> this.commandBuilder.pfmerge(destkey, sourcekeys));
    }

    public Mono<String> pfmerge(K destkey, K sourceKey, K ... sourcekeys) {
        return this.createMono(() -> this.commandBuilder.pfmerge((Object)destkey, (Object)sourceKey, sourcekeys));
    }

    @Override
    public Mono<String> ping() {
        return this.createMono(this.commandBuilder::ping);
    }

    @Override
    public Mono<String> psetex(K key, long milliseconds, V value) {
        return this.createMono(() -> this.commandBuilder.psetex(key, milliseconds, value));
    }

    @Override
    public Mono<Long> pttl(K key) {
        return this.createMono(() -> this.commandBuilder.pttl(key));
    }

    @Override
    public Mono<Long> publish(K channel, V message) {
        return this.createMono(() -> this.commandBuilder.publish(channel, message));
    }

    @Override
    public Flux<K> pubsubChannels() {
        return this.createDissolvingFlux(this.commandBuilder::pubsubChannels);
    }

    @Override
    public Flux<K> pubsubChannels(K channel) {
        return this.createDissolvingFlux(() -> this.commandBuilder.pubsubChannels(channel));
    }

    @Override
    public Mono<Long> pubsubNumpat() {
        return this.createMono(this.commandBuilder::pubsubNumpat);
    }

    @Override
    public Mono<Map<K, Long>> pubsubNumsub(K ... channels) {
        return this.createMono(() -> this.commandBuilder.pubsubNumsub(channels));
    }

    @Override
    public Mono<String> quit() {
        return this.createMono(this.commandBuilder::quit);
    }

    @Override
    public Mono<K> randomkey() {
        return this.createMono(this.commandBuilder::randomkey);
    }

    @Override
    public Mono<String> readOnly() {
        return this.createMono(this.commandBuilder::readOnly);
    }

    @Override
    public Mono<String> readWrite() {
        return this.createMono(this.commandBuilder::readWrite);
    }

    @Override
    public Mono<String> rename(K key, K newKey) {
        return this.createMono(() -> this.commandBuilder.rename(key, newKey));
    }

    @Override
    public Mono<Boolean> renamenx(K key, K newKey) {
        return this.createMono(() -> this.commandBuilder.renamenx(key, newKey));
    }

    @Override
    public Mono<String> replicaof(String host, int port) {
        return this.createMono(() -> this.commandBuilder.replicaof(host, port));
    }

    @Override
    public Mono<String> replicaofNoOne() {
        return this.createMono(() -> this.commandBuilder.replicaofNoOne());
    }

    @Override
    public void reset() {
        this.getConnection().reset();
    }

    @Override
    public Mono<String> restore(K key, long ttl, byte[] value) {
        return this.createMono(() -> this.commandBuilder.restore(key, value, RestoreArgs.Builder.ttl(ttl)));
    }

    @Override
    public Mono<String> restore(K key, byte[] value, RestoreArgs args) {
        return this.createMono(() -> this.commandBuilder.restore(key, value, args));
    }

    @Override
    public Flux<Object> role() {
        return this.createDissolvingFlux(this.commandBuilder::role);
    }

    @Override
    public Mono<V> rpop(K key) {
        return this.createMono(() -> this.commandBuilder.rpop(key));
    }

    @Override
    public Flux<V> rpop(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.rpop(key, count));
    }

    @Override
    public Mono<V> rpoplpush(K source, K destination) {
        return this.createMono(() -> this.commandBuilder.rpoplpush(source, destination));
    }

    @Override
    public Mono<Long> rpush(K key, V ... values) {
        return this.createMono(() -> this.commandBuilder.rpush(key, values));
    }

    @Override
    public Mono<Long> rpushx(K key, V ... values) {
        return this.createMono(() -> this.commandBuilder.rpushx(key, values));
    }

    @Override
    public Mono<Long> sadd(K key, V ... members) {
        return this.createMono(() -> this.commandBuilder.sadd(key, members));
    }

    @Override
    public Mono<String> save() {
        return this.createMono(this.commandBuilder::save);
    }

    @Override
    public Mono<KeyScanCursor<K>> scan() {
        return this.createMono(this.commandBuilder::scan);
    }

    @Override
    public Mono<KeyScanCursor<K>> scan(ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.scan(scanArgs));
    }

    @Override
    public Mono<KeyScanCursor<K>> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.scan(scanCursor, scanArgs));
    }

    @Override
    public Mono<KeyScanCursor<K>> scan(ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.scan(scanCursor));
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel) {
        return this.createMono(() -> this.commandBuilder.scanStreaming(channel));
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.scanStreaming(channel, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.scanStreaming(channel, scanCursor, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.scanStreaming(channel, scanCursor));
    }

    @Override
    public Mono<Long> scard(K key) {
        return this.createMono(() -> this.commandBuilder.scard(key));
    }

    @Override
    public Flux<Boolean> scriptExists(String ... digests) {
        return this.createDissolvingFlux(() -> this.commandBuilder.scriptExists(digests));
    }

    @Override
    public Mono<String> scriptFlush() {
        return this.createMono(this.commandBuilder::scriptFlush);
    }

    @Override
    public Mono<String> scriptFlush(FlushMode flushMode) {
        return this.createMono(() -> this.commandBuilder.scriptFlush(flushMode));
    }

    @Override
    public Mono<String> scriptKill() {
        return this.createMono(this.commandBuilder::scriptKill);
    }

    @Override
    public Mono<String> scriptLoad(String script) {
        return this.scriptLoad(this.encodeScript(script));
    }

    @Override
    public Mono<String> scriptLoad(byte[] script) {
        return this.createMono(() -> this.commandBuilder.scriptLoad(script));
    }

    @Override
    public Flux<V> sdiff(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sdiff(keys));
    }

    @Override
    public Mono<Long> sdiff(ValueStreamingChannel<V> channel, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sdiff(channel, keys));
    }

    @Override
    public Mono<Long> sdiffstore(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sdiffstore(destination, keys));
    }

    public Mono<String> select(int db) {
        return this.createMono(() -> this.commandBuilder.select(db));
    }

    @Override
    public Mono<String> set(K key, V value) {
        return this.createMono(() -> this.commandBuilder.set(key, value));
    }

    @Override
    public Mono<String> set(K key, V value, SetArgs setArgs) {
        return this.createMono(() -> this.commandBuilder.set(key, value, setArgs));
    }

    @Override
    public Mono<V> setGet(K key, V value) {
        return this.createMono(() -> this.commandBuilder.setGet(key, value));
    }

    @Override
    public Mono<V> setGet(K key, V value, SetArgs setArgs) {
        return this.createMono(() -> this.commandBuilder.setGet(key, value, setArgs));
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.connection.setAutoFlushCommands(autoFlush);
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.connection.setTimeout(timeout);
    }

    @Override
    public Mono<Long> setbit(K key, long offset, int value) {
        return this.createMono(() -> this.commandBuilder.setbit(key, offset, value));
    }

    @Override
    public Mono<String> setex(K key, long seconds, V value) {
        return this.createMono(() -> this.commandBuilder.setex(key, seconds, value));
    }

    @Override
    public Mono<Boolean> setnx(K key, V value) {
        return this.createMono(() -> this.commandBuilder.setnx(key, value));
    }

    @Override
    public Mono<Long> setrange(K key, long offset, V value) {
        return this.createMono(() -> this.commandBuilder.setrange(key, offset, value));
    }

    @Override
    public Mono<Void> shutdown(boolean save) {
        return this.createMono(() -> this.commandBuilder.shutdown(save)).then();
    }

    @Override
    public Mono<Void> shutdown(ShutdownArgs args) {
        return this.createMono(() -> this.commandBuilder.shutdown(args)).then();
    }

    @Override
    public Flux<V> sinter(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sinter(keys));
    }

    @Override
    public Mono<Long> sinter(ValueStreamingChannel<V> channel, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sinter(channel, keys));
    }

    @Override
    public Mono<Long> sintercard(K ... keys) {
        return this.createMono(() -> this.commandBuilder.sintercard(keys));
    }

    @Override
    public Mono<Long> sintercard(long limit, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sintercard(limit, keys));
    }

    @Override
    public Mono<Long> sinterstore(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sinterstore(destination, keys));
    }

    @Override
    public Mono<Boolean> sismember(K key, V member) {
        return this.createMono(() -> this.commandBuilder.sismember(key, member));
    }

    @Override
    public Mono<String> slaveof(String host, int port) {
        return this.createMono(() -> this.commandBuilder.slaveof(host, port));
    }

    @Override
    public Mono<String> slaveofNoOne() {
        return this.createMono(() -> this.commandBuilder.slaveofNoOne());
    }

    @Override
    public Flux<Object> slowlogGet() {
        return this.createDissolvingFlux(() -> this.commandBuilder.slowlogGet());
    }

    @Override
    public Flux<Object> slowlogGet(int count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.slowlogGet(count));
    }

    @Override
    public Mono<Long> slowlogLen() {
        return this.createMono(() -> this.commandBuilder.slowlogLen());
    }

    @Override
    public Mono<String> slowlogReset() {
        return this.createMono(() -> this.commandBuilder.slowlogReset());
    }

    @Override
    public Flux<V> smembers(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.smembers(key));
    }

    @Override
    public Mono<Long> smembers(ValueStreamingChannel<V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.smembers(channel, key));
    }

    @Override
    public Flux<Boolean> smismember(K key, V ... members) {
        return this.createDissolvingFlux(() -> this.commandBuilder.smismember(key, members));
    }

    @Override
    public Mono<Boolean> smove(K source, K destination, V member) {
        return this.createMono(() -> this.commandBuilder.smove(source, destination, member));
    }

    @Override
    public Flux<V> sort(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sort(key));
    }

    @Override
    public Mono<Long> sort(ValueStreamingChannel<V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.sort(channel, key));
    }

    @Override
    public Flux<V> sort(K key, SortArgs sortArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sort(key, sortArgs));
    }

    @Override
    public Mono<Long> sort(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        return this.createMono(() -> this.commandBuilder.sort(channel, key, sortArgs));
    }

    @Override
    public Flux<V> sortReadOnly(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sortReadOnly(key));
    }

    @Override
    public Mono<Long> sortReadOnly(ValueStreamingChannel<V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.sortReadOnly(channel, key));
    }

    @Override
    public Flux<V> sortReadOnly(K key, SortArgs sortArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sortReadOnly(key, sortArgs));
    }

    @Override
    public Mono<Long> sortReadOnly(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        return this.createMono(() -> this.commandBuilder.sortReadOnly(channel, key, sortArgs));
    }

    @Override
    public Mono<Long> sortStore(K key, SortArgs sortArgs, K destination) {
        return this.createMono(() -> this.commandBuilder.sortStore(key, sortArgs, destination));
    }

    @Override
    public Mono<V> spop(K key) {
        return this.createMono(() -> this.commandBuilder.spop(key));
    }

    @Override
    public Flux<V> spop(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.spop(key, count));
    }

    @Override
    public Mono<V> srandmember(K key) {
        return this.createMono(() -> this.commandBuilder.srandmember(key));
    }

    @Override
    public Flux<V> srandmember(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.srandmember(key, count));
    }

    @Override
    public Mono<Long> srandmember(ValueStreamingChannel<V> channel, K key, long count) {
        return this.createMono(() -> this.commandBuilder.srandmember(channel, key, count));
    }

    @Override
    public Mono<Long> srem(K key, V ... members) {
        return this.createMono(() -> this.commandBuilder.srem(key, members));
    }

    @Override
    public Mono<ValueScanCursor<V>> sscan(K key) {
        return this.createMono(() -> this.commandBuilder.sscan(key));
    }

    @Override
    public Mono<ValueScanCursor<V>> sscan(K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.sscan(key, scanArgs));
    }

    @Override
    public Mono<ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.sscan(key, scanCursor, scanArgs));
    }

    @Override
    public Mono<ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.sscan(key, scanCursor));
    }

    @Override
    public Mono<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.sscanStreaming(channel, key));
    }

    @Override
    public Mono<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.sscanStreaming(channel, key, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.sscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.sscanStreaming(channel, key, scanCursor));
    }

    @Override
    public Mono<Long> strlen(K key) {
        return this.createMono(() -> this.commandBuilder.strlen(key));
    }

    @Override
    public Mono<StringMatchResult> stralgoLcs(StrAlgoArgs strAlgoArgs) {
        return this.createMono(() -> this.commandBuilder.stralgoLcs(strAlgoArgs));
    }

    @Override
    public Flux<V> sunion(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sunion(keys));
    }

    @Override
    public Mono<Long> sunion(ValueStreamingChannel<V> channel, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sunion(channel, keys));
    }

    @Override
    public Mono<Long> sunionstore(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sunionstore(destination, keys));
    }

    public Mono<String> swapdb(int db1, int db2) {
        return this.createMono(() -> this.commandBuilder.swapdb(db1, db2));
    }

    @Override
    public Flux<V> time() {
        return this.createDissolvingFlux(this.commandBuilder::time);
    }

    @Override
    public Mono<Long> touch(K ... keys) {
        return this.createMono(() -> this.commandBuilder.touch(keys));
    }

    public Mono<Long> touch(Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.touch(keys));
    }

    @Override
    public Mono<Long> ttl(K key) {
        return this.createMono(() -> this.commandBuilder.ttl(key));
    }

    @Override
    public Mono<String> type(K key) {
        return this.createMono(() -> this.commandBuilder.type(key));
    }

    @Override
    public Mono<Long> unlink(K ... keys) {
        return this.createMono(() -> this.commandBuilder.unlink(keys));
    }

    public Mono<Long> unlink(Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.unlink(keys));
    }

    @Override
    public Mono<Boolean> copy(K source, K destination) {
        return this.createMono(() -> this.commandBuilder.copy(source, destination));
    }

    @Override
    public Mono<Boolean> copy(K source, K destination, CopyArgs copyArgs) {
        return this.createMono(() -> this.commandBuilder.copy(source, destination, copyArgs));
    }

    @Override
    public Mono<String> unwatch() {
        return this.createMono(this.commandBuilder::unwatch);
    }

    @Override
    public Mono<Long> waitForReplication(int replicas, long timeout) {
        return this.createMono(() -> this.commandBuilder.wait(replicas, timeout));
    }

    @Override
    public Mono<String> watch(K ... keys) {
        return this.createMono(() -> this.commandBuilder.watch(keys));
    }

    @Override
    public Mono<Long> xack(K key, K group, String ... messageIds) {
        return this.createMono(() -> this.commandBuilder.xack(key, group, messageIds));
    }

    @Override
    public Mono<String> xadd(K key, Map<K, V> body) {
        return this.createMono(() -> this.commandBuilder.xadd(key, null, body));
    }

    @Override
    public Mono<String> xadd(K key, XAddArgs args, Map<K, V> body) {
        return this.createMono(() -> this.commandBuilder.xadd(key, args, body));
    }

    @Override
    public Mono<String> xadd(K key, Object ... keysAndValues) {
        return this.createMono(() -> this.commandBuilder.xadd(key, null, keysAndValues));
    }

    @Override
    public Mono<String> xadd(K key, XAddArgs args, Object ... keysAndValues) {
        return this.createMono(() -> this.commandBuilder.xadd(key, args, keysAndValues));
    }

    @Override
    public Mono<ClaimedMessages<K, V>> xautoclaim(K key, XAutoClaimArgs<K> args) {
        return this.createMono(() -> this.commandBuilder.xautoclaim(key, args));
    }

    @Override
    public Flux<StreamMessage<K, V>> xclaim(K key, Consumer<K> consumer, long minIdleTime, String ... messageIds) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xclaim(key, consumer, XClaimArgs.Builder.minIdleTime(minIdleTime), messageIds));
    }

    @Override
    public Flux<StreamMessage<K, V>> xclaim(K key, Consumer<K> consumer, XClaimArgs args, String ... messageIds) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xclaim(key, consumer, args, messageIds));
    }

    @Override
    public Mono<Long> xdel(K key, String ... messageIds) {
        return this.createMono(() -> this.commandBuilder.xdel(key, messageIds));
    }

    @Override
    public Mono<String> xgroupCreate(XReadArgs.StreamOffset<K> streamOffset, K group) {
        return this.createMono(() -> this.commandBuilder.xgroupCreate(streamOffset, group, null));
    }

    @Override
    public Mono<String> xgroupCreate(XReadArgs.StreamOffset<K> streamOffset, K group, XGroupCreateArgs args) {
        return this.createMono(() -> this.commandBuilder.xgroupCreate(streamOffset, group, args));
    }

    @Override
    public Mono<Boolean> xgroupCreateconsumer(K key, Consumer<K> consumer) {
        return this.createMono(() -> this.commandBuilder.xgroupCreateconsumer(key, consumer));
    }

    @Override
    public Mono<Long> xgroupDelconsumer(K key, Consumer<K> consumer) {
        return this.createMono(() -> this.commandBuilder.xgroupDelconsumer(key, consumer));
    }

    @Override
    public Mono<Boolean> xgroupDestroy(K key, K group) {
        return this.createMono(() -> this.commandBuilder.xgroupDestroy(key, group));
    }

    @Override
    public Mono<String> xgroupSetid(XReadArgs.StreamOffset<K> streamOffset, K group) {
        return this.createMono(() -> this.commandBuilder.xgroupSetid(streamOffset, group));
    }

    @Override
    public Flux<Object> xinfoStream(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xinfoStream(key));
    }

    @Override
    public Flux<Object> xinfoGroups(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xinfoGroups(key));
    }

    @Override
    public Flux<Object> xinfoConsumers(K key, K group) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xinfoConsumers(key, group));
    }

    @Override
    public Mono<Long> xlen(K key) {
        return this.createMono(() -> this.commandBuilder.xlen(key));
    }

    @Override
    public Mono<PendingMessages> xpending(K key, K group) {
        return this.createMono(() -> this.commandBuilder.xpending(key, group));
    }

    @Override
    public Flux<PendingMessage> xpending(K key, K group, Range<String> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xpending(key, group, range, limit));
    }

    @Override
    public Flux<PendingMessage> xpending(K key, Consumer<K> consumer, Range<String> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xpending(key, consumer, range, limit));
    }

    @Override
    public Flux<PendingMessage> xpending(K key, XPendingArgs<K> args) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xpending(key, args));
    }

    @Override
    public Flux<StreamMessage<K, V>> xrange(K key, Range<String> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xrange(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<StreamMessage<K, V>> xrange(K key, Range<String> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xrange(key, range, limit));
    }

    @Override
    public Flux<StreamMessage<K, V>> xread(XReadArgs.StreamOffset<K> ... streams) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xread(null, streams));
    }

    @Override
    public Flux<StreamMessage<K, V>> xread(XReadArgs args, XReadArgs.StreamOffset<K> ... streams) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xread(args, streams));
    }

    @Override
    public Flux<StreamMessage<K, V>> xreadgroup(Consumer<K> consumer, XReadArgs.StreamOffset<K> ... streams) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xreadgroup(consumer, null, streams));
    }

    @Override
    public Flux<StreamMessage<K, V>> xreadgroup(Consumer<K> consumer, XReadArgs args, XReadArgs.StreamOffset<K> ... streams) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xreadgroup(consumer, args, streams));
    }

    @Override
    public Flux<StreamMessage<K, V>> xrevrange(K key, Range<String> range) {
        return this.xrevrange(key, range, Limit.unlimited());
    }

    @Override
    public Flux<StreamMessage<K, V>> xrevrange(K key, Range<String> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.xrevrange(key, range, limit));
    }

    @Override
    public Mono<Long> xtrim(K key, long count) {
        return this.xtrim(key, false, count);
    }

    @Override
    public Mono<Long> xtrim(K key, boolean approximateTrimming, long count) {
        return this.createMono(() -> this.commandBuilder.xtrim(key, approximateTrimming, count));
    }

    @Override
    public Mono<Long> xtrim(K key, XTrimArgs args) {
        return this.createMono(() -> this.commandBuilder.xtrim(key, args));
    }

    @Override
    public Mono<KeyValue<K, ScoredValue<V>>> bzpopmin(long timeout, K ... keys) {
        return this.createMono(() -> this.commandBuilder.bzpopmin(timeout, keys));
    }

    @Override
    public Mono<KeyValue<K, ScoredValue<V>>> bzpopmin(double timeout, K ... keys) {
        return this.createMono(() -> this.commandBuilder.bzpopmin(timeout, keys));
    }

    @Override
    public Mono<KeyValue<K, ScoredValue<V>>> bzpopmax(long timeout, K ... keys) {
        return this.createMono(() -> this.commandBuilder.bzpopmax(timeout, keys));
    }

    @Override
    public Mono<KeyValue<K, ScoredValue<V>>> bzpopmax(double timeout, K ... keys) {
        return this.createMono(() -> this.commandBuilder.bzpopmax(timeout, keys));
    }

    @Override
    public Mono<Long> zadd(K key, double score, V member) {
        return this.createMono(() -> this.commandBuilder.zadd(key, (ZAddArgs)null, score, member));
    }

    @Override
    public Mono<Long> zadd(K key, Object ... scoresAndValues) {
        return this.createMono(() -> this.commandBuilder.zadd(key, null, scoresAndValues));
    }

    @Override
    public Mono<Long> zadd(K key, ScoredValue<V> ... scoredValues) {
        return this.createMono(() -> this.commandBuilder.zadd(key, null, scoredValues));
    }

    @Override
    public Mono<Long> zadd(K key, ZAddArgs zAddArgs, double score, V member) {
        return this.createMono(() -> this.commandBuilder.zadd(key, zAddArgs, score, member));
    }

    @Override
    public Mono<Long> zadd(K key, ZAddArgs zAddArgs, Object ... scoresAndValues) {
        return this.createMono(() -> this.commandBuilder.zadd(key, zAddArgs, scoresAndValues));
    }

    @Override
    public Mono<Long> zadd(K key, ZAddArgs zAddArgs, ScoredValue<V> ... scoredValues) {
        return this.createMono(() -> this.commandBuilder.zadd(key, zAddArgs, scoredValues));
    }

    @Override
    public Mono<Double> zaddincr(K key, double score, V member) {
        return this.createMono(() -> this.commandBuilder.zaddincr(key, null, score, member));
    }

    @Override
    public Mono<Double> zaddincr(K key, ZAddArgs zAddArgs, double score, V member) {
        return this.createMono(() -> this.commandBuilder.zaddincr(key, zAddArgs, score, member));
    }

    @Override
    public Mono<Long> zcard(K key) {
        return this.createMono(() -> this.commandBuilder.zcard(key));
    }

    @Override
    public Mono<Long> zcount(K key, double min, double max) {
        return this.createMono(() -> this.commandBuilder.zcount(key, min, max));
    }

    @Override
    public Mono<Long> zcount(K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zcount(key, min, max));
    }

    @Override
    public Mono<Long> zcount(K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zcount(key, range));
    }

    @Override
    public Flux<V> zdiff(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zdiff(keys));
    }

    @Override
    public Mono<Long> zdiffstore(K destKey, K ... srcKeys) {
        return this.createMono(() -> this.commandBuilder.zdiffstore(destKey, srcKeys));
    }

    @Override
    public Flux<ScoredValue<V>> zdiffWithScores(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zdiffWithScores(keys));
    }

    @Override
    public Mono<Double> zincrby(K key, double amount, V member) {
        return this.createMono(() -> this.commandBuilder.zincrby(key, amount, member));
    }

    @Override
    public Flux<V> zinter(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zinter(keys));
    }

    @Override
    public Flux<V> zinter(ZAggregateArgs aggregateArgs, K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zinter(aggregateArgs, keys));
    }

    @Override
    public Mono<Long> zintercard(K ... keys) {
        return this.createMono(() -> this.commandBuilder.zintercard(keys));
    }

    @Override
    public Mono<Long> zintercard(long limit, K ... keys) {
        return this.createMono(() -> this.commandBuilder.zintercard(limit, keys));
    }

    @Override
    public Flux<ScoredValue<V>> zinterWithScores(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zinterWithScores(keys));
    }

    @Override
    public Flux<ScoredValue<V>> zinterWithScores(ZAggregateArgs aggregateArgs, K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zinterWithScores(aggregateArgs, keys));
    }

    @Override
    public Mono<Long> zinterstore(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.zinterstore(destination, keys));
    }

    @Override
    public Mono<Long> zinterstore(K destination, ZStoreArgs zStoreArgs, K ... keys) {
        return this.createMono(() -> this.commandBuilder.zinterstore((Object)destination, zStoreArgs, keys));
    }

    @Override
    public Mono<Long> zlexcount(K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zlexcount(key, min, max));
    }

    @Override
    public Mono<Long> zlexcount(K key, Range<? extends V> range) {
        return this.createMono(() -> this.commandBuilder.zlexcount(key, range));
    }

    @Override
    public Mono<List<Double>> zmscore(K key, V ... members) {
        return this.createMono(() -> this.commandBuilder.zmscore(key, members));
    }

    @Override
    public Mono<ScoredValue<V>> zpopmin(K key) {
        return this.createMono(() -> this.commandBuilder.zpopmin(key));
    }

    @Override
    public Flux<ScoredValue<V>> zpopmin(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zpopmin(key, count));
    }

    @Override
    public Mono<ScoredValue<V>> zpopmax(K key) {
        return this.createMono(() -> this.commandBuilder.zpopmax(key));
    }

    @Override
    public Flux<ScoredValue<V>> zpopmax(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zpopmax(key, count));
    }

    @Override
    public Mono<V> zrandmember(K key) {
        return this.createMono(() -> this.commandBuilder.zrandmember(key));
    }

    @Override
    public Flux<V> zrandmember(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrandmember(key, count));
    }

    @Override
    public Mono<ScoredValue<V>> zrandmemberWithScores(K key) {
        return this.createMono(() -> this.commandBuilder.zrandmemberWithScores(key));
    }

    @Override
    public Flux<ScoredValue<V>> zrandmemberWithScores(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrandmemberWithScores(key, count));
    }

    @Override
    public Flux<V> zrange(K key, long start, long stop) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrange(key, start, stop));
    }

    @Override
    public Mono<Long> zrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.zrange(channel, key, start, stop));
    }

    @Override
    public Flux<ScoredValue<V>> zrangeWithScores(K key, long start, long stop) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangeWithScores(key, start, stop));
    }

    @Override
    public Mono<Long> zrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.zrangeWithScores(channel, key, start, stop));
    }

    @Override
    public Flux<V> zrangebylex(K key, String min, String max) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebylex(key, min, max));
    }

    @Override
    public Flux<V> zrangebylex(K key, Range<? extends V> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebylex(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<V> zrangebylex(K key, String min, String max, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebylex(key, min, max, offset, count));
    }

    @Override
    public Flux<V> zrangebylex(K key, Range<? extends V> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebylex(key, range, limit));
    }

    @Override
    public Flux<V> zrangebyscore(K key, double min, double max) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, min, max));
    }

    @Override
    public Flux<V> zrangebyscore(K key, String min, String max) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, min, max));
    }

    @Override
    public Flux<V> zrangebyscore(K key, double min, double max, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, min, max, offset, count));
    }

    @Override
    public Flux<V> zrangebyscore(K key, String min, String max, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, min, max, offset, count));
    }

    @Override
    public Flux<V> zrangebyscore(K key, Range<? extends Number> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<V> zrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, range, limit));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, min, max));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, min, max));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, min, max, offset, count));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, min, max, offset, count));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, range, limit));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, double min, double max) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, String min, String max) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, double min, double max, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max, offset, count));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, String min, String max, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max, offset, count));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, Range<? extends Number> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, range, limit));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max, offset, count));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max, offset, count));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, range, limit));
    }

    @Override
    public Mono<Long> zrangestore(K dstKey, K srcKey, Range<Long> range) {
        return this.createMono(() -> this.commandBuilder.zrangestore(dstKey, srcKey, range, false));
    }

    @Override
    public Mono<Long> zrangestorebylex(K dstKey, K srcKey, Range<? extends V> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrangestorebylex(dstKey, srcKey, range, limit, false));
    }

    @Override
    public Mono<Long> zrangestorebyscore(K dstKey, K srcKey, Range<? extends Number> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrangestorebyscore(dstKey, srcKey, range, limit, false));
    }

    @Override
    public Mono<Long> zrank(K key, V member) {
        return this.createMono(() -> this.commandBuilder.zrank(key, member));
    }

    @Override
    public Mono<Long> zrem(K key, V ... members) {
        return this.createMono(() -> this.commandBuilder.zrem(key, members));
    }

    @Override
    public Mono<Long> zremrangebylex(K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zremrangebylex(key, min, max));
    }

    @Override
    public Mono<Long> zremrangebylex(K key, Range<? extends V> range) {
        return this.createMono(() -> this.commandBuilder.zremrangebylex(key, range));
    }

    @Override
    public Mono<Long> zremrangebyrank(K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.zremrangebyrank(key, start, stop));
    }

    @Override
    public Mono<Long> zremrangebyscore(K key, double min, double max) {
        return this.createMono(() -> this.commandBuilder.zremrangebyscore(key, min, max));
    }

    @Override
    public Mono<Long> zremrangebyscore(K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zremrangebyscore(key, min, max));
    }

    @Override
    public Mono<Long> zremrangebyscore(K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zremrangebyscore(key, range));
    }

    @Override
    public Flux<V> zrevrange(K key, long start, long stop) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrange(key, start, stop));
    }

    @Override
    public Mono<Long> zrevrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.zrevrange(channel, key, start, stop));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangeWithScores(K key, long start, long stop) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangeWithScores(key, start, stop));
    }

    @Override
    public Mono<Long> zrevrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.zrevrangeWithScores(channel, key, start, stop));
    }

    @Override
    public Flux<V> zrevrangebylex(K key, Range<? extends V> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebylex(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<V> zrevrangebylex(K key, Range<? extends V> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebylex(key, range, limit));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, double max, double min) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, max, min));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, String max, String min) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, max, min));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, Range<? extends Number> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, double max, double min, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, max, min, offset, count));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, String max, String min, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, max, min, offset, count));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, range, limit));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min, offset, count));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min, offset, count));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, range, limit));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, double max, double min) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, String max, String min) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, double max, double min, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min, offset, count));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, String max, String min, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min, offset, count));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, range, limit));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min, offset, count));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min, offset, count));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, range, limit));
    }

    @Override
    public Mono<Long> zrevrangestore(K dstKey, K srcKey, Range<Long> range) {
        return this.createMono(() -> this.commandBuilder.zrangestore(dstKey, srcKey, range, true));
    }

    @Override
    public Mono<Long> zrevrangestorebylex(K dstKey, K srcKey, Range<? extends V> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrangestorebylex(dstKey, srcKey, range, limit, true));
    }

    @Override
    public Mono<Long> zrevrangestorebyscore(K dstKey, K srcKey, Range<? extends Number> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrangestorebyscore(dstKey, srcKey, range, limit, true));
    }

    @Override
    public Mono<Long> zrevrank(K key, V member) {
        return this.createMono(() -> this.commandBuilder.zrevrank(key, member));
    }

    @Override
    public Mono<ScoredValueScanCursor<V>> zscan(K key) {
        return this.createMono(() -> this.commandBuilder.zscan(key));
    }

    @Override
    public Mono<ScoredValueScanCursor<V>> zscan(K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.zscan(key, scanArgs));
    }

    @Override
    public Mono<ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.zscan(key, scanCursor, scanArgs));
    }

    @Override
    public Mono<ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.zscan(key, scanCursor));
    }

    @Override
    public Mono<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.zscanStreaming(channel, key));
    }

    @Override
    public Mono<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.zscanStreaming(channel, key, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.zscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.zscanStreaming(channel, key, scanCursor));
    }

    @Override
    public Mono<Double> zscore(K key, V member) {
        return this.createMono(() -> this.commandBuilder.zscore(key, member));
    }

    @Override
    public Flux<V> zunion(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zunion(keys));
    }

    @Override
    public Flux<V> zunion(ZAggregateArgs aggregateArgs, K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zunion(aggregateArgs, keys));
    }

    @Override
    public Flux<ScoredValue<V>> zunionWithScores(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zunionWithScores(keys));
    }

    @Override
    public Flux<ScoredValue<V>> zunionWithScores(ZAggregateArgs aggregateArgs, K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zunionWithScores(aggregateArgs, keys));
    }

    @Override
    public Mono<Long> zunionstore(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.zunionstore(destination, keys));
    }

    @Override
    public Mono<Long> zunionstore(K destination, ZStoreArgs zStoreArgs, K ... keys) {
        return this.createMono(() -> this.commandBuilder.zunionstore((Object)destination, zStoreArgs, keys));
    }

    private byte[] encodeScript(String script) {
        LettuceAssert.notNull((Object)script, "Lua script must not be null");
        LettuceAssert.notEmpty((CharSequence)script, "Lua script must not be empty");
        return script.getBytes(this.getConnection().getOptions().getScriptCharset());
    }
}

