/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.CompositeArgument;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandType;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.ProtocolKeyword;

public class BitFieldArgs
implements CompositeArgument {
    private List<SubCommand> commands;

    public BitFieldArgs() {
        this(new ArrayList<SubCommand>());
    }

    private BitFieldArgs(List<SubCommand> commands) {
        LettuceAssert.notNull(commands, "Commands must not be null");
        this.commands = commands;
    }

    public static BitFieldType signed(int bits) {
        return new BitFieldType(true, bits);
    }

    public static BitFieldType unsigned(int bits) {
        return new BitFieldType(false, bits);
    }

    public static Offset offset(int offset) {
        return new Offset(false, offset);
    }

    public static Offset typeWidthBasedOffset(int offset) {
        return new Offset(true, offset);
    }

    private BitFieldArgs addSubCommand(SubCommand subCommand) {
        LettuceAssert.notNull((Object)subCommand, "SubCommand must not be null");
        this.commands.add(subCommand);
        return this;
    }

    public BitFieldArgs get() {
        return this.get(this.previousFieldType());
    }

    public BitFieldArgs get(BitFieldType bitFieldType) {
        return this.get(bitFieldType, 0);
    }

    public BitFieldArgs get(BitFieldType bitFieldType, int offset) {
        return this.addSubCommand(new Get(bitFieldType, false, offset));
    }

    public BitFieldArgs get(BitFieldType bitFieldType, Offset offset) {
        LettuceAssert.notNull((Object)offset, "BitFieldOffset must not be null");
        return this.addSubCommand(new Get(bitFieldType, offset.isMultiplyByTypeWidth(), offset.getOffset()));
    }

    public BitFieldArgs get(int offset) {
        return this.get(this.previousFieldType(), offset);
    }

    public BitFieldArgs set(long value) {
        return this.set(this.previousFieldType(), value);
    }

    public BitFieldArgs set(BitFieldType bitFieldType, long value) {
        return this.set(bitFieldType, 0, value);
    }

    public BitFieldArgs set(int offset, long value) {
        return this.set(this.previousFieldType(), offset, value);
    }

    public BitFieldArgs set(BitFieldType bitFieldType, int offset, long value) {
        return this.addSubCommand(new Set(bitFieldType, false, offset, value));
    }

    public BitFieldArgs set(BitFieldType bitFieldType, Offset offset, long value) {
        LettuceAssert.notNull((Object)offset, "BitFieldOffset must not be null");
        return this.addSubCommand(new Set(bitFieldType, offset.isMultiplyByTypeWidth(), offset.getOffset(), value));
    }

    public BitFieldArgs incrBy(long value) {
        return this.incrBy(this.previousFieldType(), value);
    }

    public BitFieldArgs incrBy(BitFieldType bitFieldType, long value) {
        return this.incrBy(bitFieldType, 0, value);
    }

    public BitFieldArgs incrBy(int offset, long value) {
        return this.incrBy(this.previousFieldType(), offset, value);
    }

    public BitFieldArgs incrBy(BitFieldType bitFieldType, int offset, long value) {
        return this.addSubCommand(new IncrBy(bitFieldType, false, offset, value));
    }

    public BitFieldArgs incrBy(BitFieldType bitFieldType, Offset offset, long value) {
        LettuceAssert.notNull((Object)offset, "BitFieldOffset must not be null");
        return this.addSubCommand(new IncrBy(bitFieldType, offset.isMultiplyByTypeWidth(), offset.getOffset(), value));
    }

    public BitFieldArgs overflow(OverflowType overflowType) {
        return this.addSubCommand(new Overflow(overflowType));
    }

    private BitFieldType previousFieldType() {
        ArrayList<SubCommand> list = new ArrayList<SubCommand>(this.commands);
        Collections.reverse(list);
        for (SubCommand command : list) {
            if (command instanceof Get) {
                return ((Get)command).bitFieldType;
            }
            if (command instanceof Set) {
                return ((Set)command).bitFieldType;
            }
            if (!(command instanceof IncrBy)) continue;
            return ((IncrBy)command).bitFieldType;
        }
        throw new IllegalStateException("No previous field type found");
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        for (SubCommand command : this.commands) {
            command.build(args);
        }
    }

    public static class Offset {
        private final boolean multiplyByTypeWidth;
        private final int offset;

        private Offset(boolean multiplyByTypeWidth, int offset) {
            this.multiplyByTypeWidth = multiplyByTypeWidth;
            this.offset = offset;
        }

        public boolean isMultiplyByTypeWidth() {
            return this.multiplyByTypeWidth;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return (this.multiplyByTypeWidth ? "#" : "") + this.offset;
        }
    }

    public static class BitFieldType {
        private final boolean signed;
        private final int bits;

        private BitFieldType(boolean signed, int bits) {
            LettuceAssert.isTrue(bits > 0, "Bits must be greater 0");
            if (signed) {
                LettuceAssert.isTrue(bits < 65, "Signed integers support only up to 64 bits");
            } else {
                LettuceAssert.isTrue(bits < 64, "Unsigned integers support only up to 63 bits");
            }
            this.signed = signed;
            this.bits = bits;
        }

        public boolean isSigned() {
            return this.signed;
        }

        public int getBits() {
            return this.bits;
        }

        private String asString() {
            return (this.signed ? "i" : "u") + this.bits;
        }

        public String toString() {
            return this.asString();
        }
    }

    public static enum OverflowType implements ProtocolKeyword
    {
        WRAP,
        SAT,
        FAIL;

        public final byte[] bytes = this.name().getBytes(StandardCharsets.US_ASCII);

        @Override
        public byte[] getBytes() {
            return this.bytes;
        }
    }

    private static abstract class SubCommand {
        private SubCommand() {
        }

        abstract <K, V> void build(CommandArgs<K, V> var1);
    }

    private static class Overflow
    extends SubCommand {
        private final OverflowType overflowType;

        private Overflow(OverflowType overflowType) {
            LettuceAssert.notNull((Object)overflowType, "OverflowType must not be null");
            this.overflowType = overflowType;
        }

        @Override
        <K, V> void build(CommandArgs<K, V> args) {
            args.add("OVERFLOW").add(this.overflowType);
        }
    }

    private static class IncrBy
    extends SubCommand {
        private final BitFieldType bitFieldType;
        private final boolean bitOffset;
        private final long offset;
        private final long value;

        private IncrBy(BitFieldType bitFieldType, boolean offsetWidthMultiplier, int offset, long value) {
            LettuceAssert.notNull((Object)bitFieldType, "BitFieldType must not be null");
            LettuceAssert.isTrue(offset > -1, "Offset must be greater or equal to 0");
            this.bitFieldType = bitFieldType;
            this.bitOffset = offsetWidthMultiplier;
            this.offset = offset;
            this.value = value;
        }

        @Override
        <K, V> void build(CommandArgs<K, V> args) {
            args.add(CommandType.INCRBY).add(this.bitFieldType.asString());
            if (this.bitOffset) {
                args.add("#" + this.offset);
            } else {
                args.add(this.offset);
            }
            args.add(this.value);
        }
    }

    private static class Get
    extends SubCommand {
        private final BitFieldType bitFieldType;
        private final boolean bitOffset;
        private final int offset;

        private Get(BitFieldType bitFieldType, boolean bitOffset, int offset) {
            LettuceAssert.notNull((Object)bitFieldType, "BitFieldType must not be null");
            LettuceAssert.isTrue(offset > -1, "Offset must be greater or equal to 0");
            this.bitFieldType = bitFieldType;
            this.bitOffset = bitOffset;
            this.offset = offset;
        }

        @Override
        <K, V> void build(CommandArgs<K, V> args) {
            args.add(CommandType.GET).add(this.bitFieldType.asString());
            if (this.bitOffset) {
                args.add("#" + this.offset);
            } else {
                args.add(this.offset);
            }
        }
    }

    private static class Set
    extends SubCommand {
        private final BitFieldType bitFieldType;
        private final boolean bitOffset;
        private final long offset;
        private final long value;

        private Set(BitFieldType bitFieldType, boolean bitOffset, int offset, long value) {
            LettuceAssert.notNull((Object)bitFieldType, "BitFieldType must not be null");
            LettuceAssert.isTrue(offset > -1, "Offset must be greater or equal to 0");
            this.bitFieldType = bitFieldType;
            this.bitOffset = bitOffset;
            this.offset = offset;
            this.value = value;
        }

        @Override
        <K, V> void build(CommandArgs<K, V> args) {
            args.add(CommandType.SET).add(this.bitFieldType.asString());
            if (this.bitOffset) {
                args.add("#" + this.offset);
            } else {
                args.add(this.offset);
            }
            args.add(this.value);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static BitFieldArgs get(BitFieldType bitFieldType, int offset) {
            return new BitFieldArgs().get(bitFieldType, offset);
        }

        public static BitFieldArgs get(BitFieldType bitFieldType, Offset offset) {
            return new BitFieldArgs().get(bitFieldType, offset);
        }

        public static BitFieldArgs set(BitFieldType bitFieldType, int offset, long value) {
            return new BitFieldArgs().set(bitFieldType, offset, value);
        }

        public static BitFieldArgs set(BitFieldType bitFieldType, Offset offset, long value) {
            return new BitFieldArgs().set(bitFieldType, offset, value);
        }

        public static BitFieldArgs incrBy(BitFieldType bitFieldType, int offset, long value) {
            return new BitFieldArgs().incrBy(bitFieldType, offset, value);
        }

        public static BitFieldArgs incrBy(BitFieldType bitFieldType, Offset offset, long value) {
            return new BitFieldArgs().incrBy(bitFieldType, offset, value);
        }

        public static BitFieldArgs overflow(OverflowType overflowType) {
            return new BitFieldArgs().overflow(overflowType);
        }
    }
}

