/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ConnectionBuilder;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ConnectionEventTrigger;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.event.EventBus;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.event.connection.ConnectedEvent;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.event.connection.DisconnectedEvent;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandHandler;

class ChannelGroupListener
extends ChannelInboundHandlerAdapter {
    private final ChannelGroup channels;
    private final EventBus eventBus;

    public ChannelGroupListener(ChannelGroup channels, EventBus eventBus) {
        this.channels = channels;
        this.eventBus = eventBus;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        CommandHandler commandHandler = ChannelGroupListener.getCommandHandler(ctx);
        String epid = commandHandler.getEndpoint().getId();
        this.eventBus.publish(new ConnectedEvent(ChannelGroupListener.getRedisUri(ctx.channel()), epid, commandHandler.getChannelId(), ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
        this.channels.add((Object)ctx.channel());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        CommandHandler commandHandler = ChannelGroupListener.getCommandHandler(ctx);
        String epid = commandHandler.getEndpoint().getId();
        this.eventBus.publish(new DisconnectedEvent(ChannelGroupListener.getRedisUri(ctx.channel()), epid, commandHandler.getChannelId(), ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
        this.channels.remove((Object)ctx.channel());
        super.channelInactive(ctx);
    }

    private static String getRedisUri(Channel channel) {
        String redisUri = null;
        if (channel.hasAttr(ConnectionBuilder.REDIS_URI)) {
            redisUri = (String)channel.attr(ConnectionBuilder.REDIS_URI).get();
        }
        return redisUri;
    }

    private static CommandHandler getCommandHandler(ChannelHandlerContext ctx) {
        return (CommandHandler)ctx.pipeline().get(CommandHandler.class);
    }
}

