/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core;

import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisChannelHandler;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisConnectionStateListener;

public class ConnectionEvents {
    private final Set<RedisConnectionStateListener> listeners = ConcurrentHashMap.newKeySet();

    void fireEventRedisConnected(RedisChannelHandler<?, ?> connection, SocketAddress socketAddress) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisConnected(connection, socketAddress);
        }
    }

    void fireEventRedisDisconnected(RedisChannelHandler<?, ?> connection) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisDisconnected(connection);
        }
    }

    void fireEventRedisExceptionCaught(RedisChannelHandler<?, ?> connection, Throwable cause) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisExceptionCaught(connection, cause);
        }
    }

    public void addListener(RedisConnectionStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        this.listeners.remove(listener);
    }

    static ConnectionEvents of(ConnectionEvents ... delegates) {
        return delegates.length == 1 ? delegates[0] : new MergedConnectionEvents(delegates);
    }

    static class MergedConnectionEvents
    extends ConnectionEvents {
        private final ConnectionEvents[] delegates;

        MergedConnectionEvents(ConnectionEvents[] delegates) {
            this.delegates = delegates;
        }

        @Override
        void fireEventRedisConnected(RedisChannelHandler<?, ?> connection, SocketAddress socketAddress) {
            for (ConnectionEvents delegate : this.delegates) {
                delegate.fireEventRedisConnected(connection, socketAddress);
            }
        }

        @Override
        void fireEventRedisDisconnected(RedisChannelHandler<?, ?> connection) {
            for (ConnectionEvents delegate : this.delegates) {
                delegate.fireEventRedisDisconnected(connection);
            }
        }

        @Override
        void fireEventRedisExceptionCaught(RedisChannelHandler<?, ?> connection, Throwable cause) {
            for (ConnectionEvents delegate : this.delegates) {
                delegate.fireEventRedisExceptionCaught(connection, cause);
            }
        }

        @Override
        public void addListener(RedisConnectionStateListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeListener(RedisConnectionStateListener listener) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Reconnect {
        private final int attempt;

        public Reconnect(int attempt) {
            this.attempt = attempt;
        }

        public int getAttempt() {
            return this.attempt;
        }
    }

    public static class Reset {
    }
}

