/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisFuture;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.StatefulConnection;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.StatefulRedisConnection;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.AbstractInvocationHandler;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.Futures;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.TimeoutProvider;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandType;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.ProtocolKeyword;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.RedisCommand;

class FutureSyncInvocationHandler
extends AbstractInvocationHandler {
    private final StatefulConnection<?, ?> connection;
    private final TimeoutProvider timeoutProvider;
    private final Object asyncApi;
    private final AbstractInvocationHandler.MethodTranslator translator;

    FutureSyncInvocationHandler(StatefulConnection<?, ?> connection, Object asyncApi, Class<?>[] interfaces) {
        this.connection = connection;
        this.timeoutProvider = new TimeoutProvider(() -> connection.getOptions().getTimeoutOptions(), () -> connection.getTimeout().toNanos());
        this.asyncApi = asyncApi;
        this.translator = AbstractInvocationHandler.MethodTranslator.of(asyncApi.getClass(), interfaces);
    }

    @Override
    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Method targetMethod = this.translator.get(method);
            Object result = targetMethod.invoke(this.asyncApi, args);
            if (result instanceof RedisFuture) {
                RedisFuture command = (RedisFuture)result;
                if (!FutureSyncInvocationHandler.isTxControlMethod(method.getName(), args) && FutureSyncInvocationHandler.isTransactionActive(this.connection)) {
                    return null;
                }
                long timeout = this.getTimeoutNs(command);
                return Futures.awaitOrCancel(command, timeout, TimeUnit.NANOSECONDS);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private long getTimeoutNs(RedisFuture<?> command) {
        if (command instanceof RedisCommand) {
            return this.timeoutProvider.getTimeoutNs((RedisCommand)((Object)command));
        }
        return this.connection.getTimeout().toNanos();
    }

    private static boolean isTransactionActive(StatefulConnection<?, ?> connection) {
        return connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)connection).isMulti();
    }

    private static boolean isTxControlMethod(String methodName, Object[] args) {
        ProtocolKeyword keyword;
        if (methodName.equals("exec") || methodName.equals("multi") || methodName.equals("discard")) {
            return true;
        }
        return methodName.equals("dispatch") && args.length > 0 && args[0] instanceof ProtocolKeyword && ((keyword = (ProtocolKeyword)args[0]).name().equals(CommandType.MULTI.name()) || keyword.name().equals(CommandType.EXEC.name()) || keyword.name().equals(CommandType.DISCARD.name()));
    }
}

