/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core;

import java.util.function.Supplier;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisCredentials;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Mono;

@FunctionalInterface
public interface RedisCredentialsProvider {
    public Mono<RedisCredentials> resolveCredentials();

    public static RedisCredentialsProvider from(Supplier<RedisCredentials> supplier) {
        LettuceAssert.notNull(supplier, "Supplier must not be null");
        return () -> Mono.fromSupplier(supplier);
    }

    @FunctionalInterface
    public static interface ImmediateRedisCredentialsProvider
    extends RedisCredentialsProvider {
        @Override
        default public Mono<RedisCredentials> resolveCredentials() {
            return Mono.just(this.resolveCredentialsNow());
        }

        public RedisCredentials resolveCredentialsNow();
    }
}

