/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core;

import java.time.Duration;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.CompositeArgument;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandKeyword;

public class RestoreArgs
implements CompositeArgument {
    long ttl;
    private boolean replace;
    private boolean absttl;
    private Long frequency;
    private Long idleTime;

    public RestoreArgs ttl(long milliseconds) {
        this.ttl = milliseconds;
        return this;
    }

    public RestoreArgs ttl(Duration ttl) {
        LettuceAssert.notNull((Object)ttl, "Time to live must not be null");
        return this.ttl(ttl.toMillis());
    }

    public RestoreArgs replace() {
        return this.replace(true);
    }

    public RestoreArgs replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    public RestoreArgs absttl() {
        return this.absttl(true);
    }

    public RestoreArgs absttl(boolean absttl) {
        this.absttl = absttl;
        return this;
    }

    public RestoreArgs idleTime(long idleTime) {
        this.idleTime = idleTime;
        return this;
    }

    public RestoreArgs frequency(long frequency) {
        this.frequency = frequency;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.replace) {
            args.add(CommandKeyword.REPLACE);
        }
        if (this.absttl) {
            args.add(CommandKeyword.ABSTTL);
        }
        if (this.idleTime != null) {
            args.add(CommandKeyword.IDLETIME).add(this.idleTime);
        }
        if (this.frequency != null) {
            args.add(CommandKeyword.FREQ).add(this.frequency);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static RestoreArgs ttl(long milliseconds) {
            return new RestoreArgs().ttl(milliseconds);
        }

        public static RestoreArgs ttl(Duration ttl) {
            LettuceAssert.notNull((Object)ttl, "Time to live must not be null");
            return Builder.ttl(ttl.toMillis());
        }
    }
}

