/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.CompositeArgument;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandKeyword;

public class SetArgs
implements CompositeArgument {
    private Long ex;
    private Long exAt;
    private Long px;
    private Long pxAt;
    private boolean nx = false;
    private boolean xx = false;
    private boolean keepttl = false;

    public SetArgs ex(long timeout) {
        this.ex = timeout;
        return this;
    }

    public SetArgs ex(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        this.ex = timeout.toMillis() / 1000L;
        return this;
    }

    public SetArgs exAt(long timestamp) {
        this.exAt = timestamp;
        return this;
    }

    public SetArgs exAt(Date timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.exAt(timestamp.getTime() / 1000L);
    }

    public SetArgs exAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.exAt(timestamp.toEpochMilli() / 1000L);
    }

    public SetArgs px(long timeout) {
        this.px = timeout;
        return this;
    }

    public SetArgs px(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        this.px = timeout.toMillis();
        return this;
    }

    public SetArgs pxAt(long timestamp) {
        this.pxAt = timestamp;
        return this;
    }

    public SetArgs pxAt(Date timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pxAt(timestamp.getTime());
    }

    public SetArgs pxAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pxAt(timestamp.toEpochMilli());
    }

    public SetArgs nx() {
        this.nx = true;
        return this;
    }

    public SetArgs keepttl() {
        this.keepttl = true;
        return this;
    }

    public SetArgs xx() {
        this.xx = true;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.ex != null) {
            args.add("EX").add(this.ex);
        }
        if (this.exAt != null) {
            args.add("EXAT").add(this.exAt);
        }
        if (this.px != null) {
            args.add("PX").add(this.px);
        }
        if (this.pxAt != null) {
            args.add("PXAT").add(this.pxAt);
        }
        if (this.nx) {
            args.add(CommandKeyword.NX);
        }
        if (this.xx) {
            args.add(CommandKeyword.XX);
        }
        if (this.keepttl) {
            args.add("KEEPTTL");
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static SetArgs ex(long timeout) {
            return new SetArgs().ex(timeout);
        }

        public static SetArgs ex(Duration timeout) {
            return new SetArgs().ex(timeout);
        }

        public static SetArgs exAt(long timestamp) {
            return new SetArgs().exAt(timestamp);
        }

        public static SetArgs exAt(Date timestamp) {
            return new SetArgs().exAt(timestamp);
        }

        public static SetArgs exAt(Instant timestamp) {
            return new SetArgs().exAt(timestamp);
        }

        public static SetArgs px(long timeout) {
            return new SetArgs().px(timeout);
        }

        public static SetArgs px(Duration timeout) {
            return new SetArgs().px(timeout);
        }

        public static SetArgs pxAt(long timestamp) {
            return new SetArgs().pxAt(timestamp);
        }

        public static SetArgs pxAt(Date timestamp) {
            return new SetArgs().pxAt(timestamp);
        }

        public static SetArgs pxAt(Instant timestamp) {
            return new SetArgs().pxAt(timestamp);
        }

        public static SetArgs nx() {
            return new SetArgs().nx();
        }

        public static SetArgs xx() {
            return new SetArgs().xx();
        }

        public static SetArgs keepttl() {
            return new SetArgs().keepttl();
        }
    }
}

