/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core;

import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceStrings;

public class SslOptions {
    public static final SslProvider DEFAULT_SSL_PROVIDER = SslProvider.JDK;
    private final String keyStoreType;
    private final SslProvider sslProvider;
    private final URL keystore;
    private final char[] keystorePassword;
    private final URL truststore;
    private final char[] truststorePassword;
    private final String[] protocols;
    private final String[] cipherSuites;
    private final Consumer<SslContextBuilder> sslContextBuilderCustomizer;
    private final Supplier<SSLParameters> sslParametersSupplier;
    private final KeystoreAction keymanager;
    private final KeystoreAction trustmanager;
    private final Duration handshakeTimeout;

    protected SslOptions(Builder builder) {
        this.keyStoreType = builder.keyStoreType;
        this.sslProvider = builder.sslProvider;
        this.handshakeTimeout = builder.sslHandshakeTimeout;
        this.keystore = builder.keystore;
        this.keystorePassword = builder.keystorePassword;
        this.truststore = builder.truststore;
        this.truststorePassword = builder.truststorePassword;
        this.protocols = builder.protocols;
        this.cipherSuites = builder.cipherSuites;
        this.sslContextBuilderCustomizer = builder.sslContextBuilderCustomizer;
        this.sslParametersSupplier = builder.sslParametersSupplier;
        this.keymanager = builder.keymanager;
        this.trustmanager = builder.trustmanager;
    }

    protected SslOptions(SslOptions original) {
        this.keyStoreType = original.keyStoreType;
        this.sslProvider = original.getSslProvider();
        this.handshakeTimeout = original.handshakeTimeout;
        this.keystore = original.keystore;
        this.keystorePassword = original.keystorePassword;
        this.truststore = original.getTruststore();
        this.truststorePassword = original.getTruststorePassword();
        this.protocols = original.protocols;
        this.cipherSuites = original.cipherSuites;
        this.sslContextBuilderCustomizer = original.sslContextBuilderCustomizer;
        this.sslParametersSupplier = original.sslParametersSupplier;
        this.keymanager = original.keymanager;
        this.trustmanager = original.trustmanager;
    }

    public static SslOptions copyOf(SslOptions options) {
        return new SslOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SslOptions create() {
        return SslOptions.builder().build();
    }

    public SslContextBuilder createSslContextBuilder() throws IOException, GeneralSecurityException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(this.sslProvider).keyStoreType(this.keyStoreType);
        if (this.protocols != null && this.protocols.length > 0) {
            sslContextBuilder.protocols(this.protocols);
        }
        if (this.cipherSuites != null && this.cipherSuites.length > 0) {
            sslContextBuilder.ciphers(Arrays.asList(this.cipherSuites));
        }
        this.keymanager.accept(sslContextBuilder, this.keyStoreType);
        this.trustmanager.accept(sslContextBuilder, this.keyStoreType);
        this.sslContextBuilderCustomizer.accept(sslContextBuilder);
        return sslContextBuilder;
    }

    public SSLParameters createSSLParameters() {
        SSLParameters sslParams = this.sslParametersSupplier.get();
        if (this.protocols != null && this.protocols.length > 0) {
            sslParams.setProtocols(this.protocols);
        }
        if (this.cipherSuites != null && this.cipherSuites.length > 0) {
            sslParams.setCipherSuites(this.cipherSuites);
        }
        return sslParams;
    }

    public Builder mutate() {
        Builder builder = SslOptions.builder();
        builder.keyStoreType = this.keyStoreType;
        builder.sslProvider = this.getSslProvider();
        builder.keystore = this.keystore;
        Builder.access$402(builder, this.keystorePassword);
        builder.truststore = this.getTruststore();
        Builder.access$602(builder, this.getTruststorePassword());
        Builder.access$702(builder, this.protocols);
        Builder.access$802(builder, this.cipherSuites);
        builder.sslContextBuilderCustomizer = this.sslContextBuilderCustomizer;
        builder.sslParametersSupplier = this.sslParametersSupplier;
        builder.keymanager = this.keymanager;
        builder.trustmanager = this.trustmanager;
        builder.sslHandshakeTimeout = this.handshakeTimeout;
        return builder;
    }

    @Deprecated
    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    @Deprecated
    public URL getKeystore() {
        return this.keystore;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public Duration getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    @Deprecated
    public char[] getKeystorePassword() {
        return Arrays.copyOf(this.keystorePassword, this.keystorePassword.length);
    }

    @Deprecated
    public URL getTruststore() {
        return this.truststore;
    }

    @Deprecated
    public char[] getTruststorePassword() {
        return Arrays.copyOf(this.truststorePassword, this.truststorePassword.length);
    }

    private static KeyManagerFactory createKeyManagerFactory(InputStream inputStream, char[] storePassword, String keyStoreType) throws GeneralSecurityException, IOException {
        KeyStore keyStore = SslOptions.getKeyStore(inputStream, storePassword, keyStoreType);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, storePassword == null ? new char[]{} : storePassword);
        return keyManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(InputStream inputStream, char[] storePassword, String keyStoreType) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(LettuceStrings.isEmpty(keyStoreType) ? KeyStore.getDefaultType() : keyStoreType);
        try {
            keyStore.load(inputStream, storePassword);
        }
        finally {
            inputStream.close();
        }
        return keyStore;
    }

    private static TrustManagerFactory createTrustManagerFactory(InputStream inputStream, char[] storePassword, String keystoreType) throws GeneralSecurityException, IOException {
        KeyStore trustStore = SslOptions.getKeyStore(inputStream, storePassword, keystoreType);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory;
    }

    private static char[] getPassword(String truststorePassword) {
        return LettuceStrings.isNotEmpty(truststorePassword) ? truststorePassword.toCharArray() : null;
    }

    private static char[] getPassword(char[] chars) {
        return chars != null ? Arrays.copyOf(chars, chars.length) : null;
    }

    @FunctionalInterface
    public static interface Resource {
        public static Resource from(URL url) {
            LettuceAssert.notNull((Object)url, "URL must not be null");
            return () -> url.openConnection().getInputStream();
        }

        public static Resource from(File file) {
            LettuceAssert.notNull((Object)file, "File must not be null");
            return () -> new FileInputStream(file);
        }

        public InputStream get() throws IOException;
    }

    @FunctionalInterface
    static interface KeystoreAction {
        public static final KeystoreAction NO_OP = (builder, keyStoreType) -> {};

        public void accept(SslContextBuilder var1, String var2) throws IOException, GeneralSecurityException;
    }

    public static class Builder {
        private SslProvider sslProvider = DEFAULT_SSL_PROVIDER;
        private String keyStoreType;
        private URL keystore;
        private char[] keystorePassword = new char[0];
        private URL truststore;
        private char[] truststorePassword = new char[0];
        private String[] protocols = null;
        private String[] cipherSuites = null;
        private Consumer<SslContextBuilder> sslContextBuilderCustomizer = contextBuilder -> {};
        private Supplier<SSLParameters> sslParametersSupplier = SSLParameters::new;
        private KeystoreAction keymanager = KeystoreAction.NO_OP;
        private KeystoreAction trustmanager = KeystoreAction.NO_OP;
        private Duration sslHandshakeTimeout = Duration.ofSeconds(10L);

        private Builder() {
        }

        public Builder cipherSuites(String ... cipherSuites) {
            LettuceAssert.notNull((Object)cipherSuites, "Cipher suites must not be null");
            this.cipherSuites = cipherSuites;
            return this;
        }

        public Builder jdkSslProvider() {
            return this.sslProvider(SslProvider.JDK);
        }

        public Builder openSslProvider() {
            return this.sslProvider(SslProvider.OPENSSL);
        }

        private Builder sslProvider(SslProvider sslProvider) {
            if (sslProvider == SslProvider.OPENSSL && !OpenSsl.isAvailable()) {
                throw new IllegalStateException("OpenSSL SSL Provider is not available");
            }
            this.sslProvider = sslProvider;
            return this;
        }

        public Builder handshakeTimeout(Duration timeout) {
            LettuceAssert.notNull((Object)timeout, "SSL Handshake Timeout must not be null");
            this.sslHandshakeTimeout = timeout;
            return this;
        }

        public Builder keyStoreType(String keyStoreType) {
            LettuceAssert.notNull((Object)keyStoreType, "KeyStoreType must not be null");
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder keystore(File keystore) {
            return this.keystore(keystore, new char[0]);
        }

        public Builder keystore(File keystore, char[] keystorePassword) {
            LettuceAssert.notNull((Object)keystore, "Keystore must not be null");
            LettuceAssert.isTrue(keystore.exists(), () -> String.format("Keystore file %s does not exist", this.truststore));
            LettuceAssert.isTrue(keystore.isFile(), () -> String.format("Keystore %s is not a file", this.truststore));
            return this.keystore(Resource.from(keystore), keystorePassword);
        }

        public Builder keystore(URL keystore) {
            return this.keystore(keystore, null);
        }

        public Builder keystore(URL keystore, char[] keystorePassword) {
            LettuceAssert.notNull((Object)keystore, "Keystore must not be null");
            this.keystore = keystore;
            return this.keystore(Resource.from(keystore), keystorePassword);
        }

        public Builder keyManager(File keyCertChainFile, File keyFile, char[] keyPassword) {
            LettuceAssert.notNull((Object)keyCertChainFile, "Key certificate file must not be null");
            LettuceAssert.notNull((Object)keyFile, "Key file must not be null");
            LettuceAssert.isTrue(keyCertChainFile.exists(), () -> String.format("Key certificate file %s does not exist", keyCertChainFile));
            LettuceAssert.isTrue(keyCertChainFile.isFile(), () -> String.format("Key certificate %s is not a file", keyCertChainFile));
            LettuceAssert.isTrue(keyFile.exists(), () -> String.format("Key file %s does not exist", keyFile));
            LettuceAssert.isTrue(keyFile.isFile(), () -> String.format("Key %s is not a file", keyFile));
            return this.keyManager(Resource.from(keyCertChainFile), Resource.from(keyFile), keyPassword);
        }

        public Builder keyManager(Resource keyCertChain, Resource key, char[] keyPassword) {
            LettuceAssert.notNull((Object)keyCertChain, "KeyChain InputStreamProvider must not be null");
            LettuceAssert.notNull((Object)key, "Key InputStreamProvider must not be null");
            char[] passwordToUse = SslOptions.getPassword(keyPassword);
            this.keymanager = (builder, keyStoreType) -> {
                try (InputStream keyCertChainIs = keyCertChain.get();
                     InputStream keyIs = key.get();){
                    builder.keyManager(keyCertChainIs, keyIs, passwordToUse == null || passwordToUse.length == 0 ? null : new String(passwordToUse));
                }
            };
            return this;
        }

        public Builder keyManager(KeyManagerFactory keyManagerFactory) {
            LettuceAssert.notNull((Object)keyManagerFactory, "KeyManagerFactory must not be null");
            this.keymanager = (builder, keyStoreType) -> builder.keyManager(keyManagerFactory);
            return this;
        }

        public Builder keystore(Resource resource, char[] keystorePassword) {
            LettuceAssert.notNull((Object)resource, "Keystore InputStreamProvider must not be null");
            char[] keystorePasswordToUse = SslOptions.getPassword(keystorePassword);
            this.keystorePassword = keystorePasswordToUse;
            this.keymanager = (builder, keyStoreType) -> {
                try (InputStream is = resource.get();){
                    builder.keyManager(SslOptions.createKeyManagerFactory(is, keystorePasswordToUse, keyStoreType));
                }
            };
            return this;
        }

        public Builder protocols(String ... protocols) {
            LettuceAssert.notNull((Object)protocols, "Protocols  must not be null");
            this.protocols = protocols;
            return this;
        }

        public Builder truststore(File truststore) {
            return this.truststore(truststore, null);
        }

        public Builder truststore(File truststore, String truststorePassword) {
            LettuceAssert.notNull((Object)truststore, "Truststore must not be null");
            LettuceAssert.isTrue(truststore.exists(), () -> String.format("Truststore file %s does not exist", truststore));
            LettuceAssert.isTrue(truststore.isFile(), () -> String.format("Truststore file %s is not a file", truststore));
            return this.truststore(Resource.from(truststore), SslOptions.getPassword(truststorePassword));
        }

        public Builder truststore(URL truststore) {
            return this.truststore(truststore, null);
        }

        public Builder truststore(URL truststore, String truststorePassword) {
            LettuceAssert.notNull((Object)truststore, "Truststore must not be null");
            this.truststore = truststore;
            return this.truststore(Resource.from(truststore), SslOptions.getPassword(truststorePassword));
        }

        public Builder trustManager(File certCollection) {
            LettuceAssert.notNull((Object)certCollection, "Certificate collection must not be null");
            LettuceAssert.isTrue(certCollection.exists(), () -> String.format("Certificate collection file %s does not exist", certCollection));
            LettuceAssert.isTrue(certCollection.isFile(), () -> String.format("Certificate collection %s is not a file", certCollection));
            return this.trustManager(Resource.from(certCollection));
        }

        public Builder trustManager(Resource certCollection) {
            LettuceAssert.notNull((Object)certCollection, "Truststore must not be null");
            this.trustmanager = (builder, keyStoreType) -> {
                try (InputStream is = certCollection.get();){
                    builder.trustManager(is);
                }
            };
            return this;
        }

        public Builder trustManager(TrustManagerFactory trustManagerFactory) {
            LettuceAssert.notNull((Object)trustManagerFactory, "TrustManagerFactory must not be null");
            this.trustmanager = (builder, keyStoreType) -> builder.trustManager(trustManagerFactory);
            return this;
        }

        public Builder truststore(Resource resource, char[] truststorePassword) {
            LettuceAssert.notNull((Object)resource, "Truststore InputStreamProvider must not be null");
            char[] passwordToUse = SslOptions.getPassword(truststorePassword);
            this.truststorePassword = passwordToUse;
            this.trustmanager = (builder, keyStoreType) -> {
                try (InputStream is = resource.get();){
                    builder.trustManager(SslOptions.createTrustManagerFactory(is, passwordToUse, keyStoreType));
                }
            };
            return this;
        }

        public Builder sslContext(Consumer<SslContextBuilder> contextBuilderCustomizer) {
            LettuceAssert.notNull(contextBuilderCustomizer, "SslContextBuilder customizer must not be null");
            this.sslContextBuilderCustomizer = contextBuilderCustomizer;
            return this;
        }

        public Builder sslParameters(Supplier<SSLParameters> sslParametersSupplier) {
            LettuceAssert.notNull(sslParametersSupplier, "SSLParameters supplier must not be null");
            this.sslParametersSupplier = sslParametersSupplier;
            return this;
        }

        public SslOptions build() {
            return new SslOptions(this);
        }

        static /* synthetic */ char[] access$402(Builder x0, char[] x1) {
            x0.keystorePassword = x1;
            return x1;
        }

        static /* synthetic */ char[] access$602(Builder x0, char[] x1) {
            x0.truststorePassword = x1;
            return x1;
        }

        static /* synthetic */ String[] access$702(Builder x0, String[] x1) {
            x0.protocols = x1;
            return x1;
        }

        static /* synthetic */ String[] access$802(Builder x0, String[] x1) {
            x0.cipherSuites = x1;
            return x1;
        }
    }
}

