/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core;

import java.util.Arrays;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisCredentials;

class StaticRedisCredentials
implements RedisCredentials {
    private final String username;
    private final char[] password;

    StaticRedisCredentials(String username, char[] password) {
        this.username = username;
        this.password = password != null ? Arrays.copyOf(password, password.length) : null;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean hasUsername() {
        return this.username != null;
    }

    @Override
    public char[] getPassword() {
        return this.hasPassword() ? Arrays.copyOf(this.password, this.password.length) : null;
    }

    @Override
    public boolean hasPassword() {
        return this.password != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisCredentials)) {
            return false;
        }
        RedisCredentials that = (RedisCredentials)o;
        if (this.username != null ? !this.username.equals(that.getUsername()) : that.getUsername() != null) {
            return false;
        }
        return Arrays.equals(this.password, that.getPassword());
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.password);
        return result;
    }
}

