/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core;

import java.util.ArrayList;
import java.util.List;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.CompositeArgument;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandKeyword;

public class ZAggregateArgs
implements CompositeArgument {
    private List<Double> weights;
    private Aggregate aggregate;

    public ZAggregateArgs weights(double ... weights) {
        LettuceAssert.notNull((Object)weights, "Weights must not be null");
        this.weights = new ArrayList<Double>(weights.length);
        for (double weight : weights) {
            this.weights.add(weight);
        }
        return this;
    }

    public ZAggregateArgs sum() {
        this.aggregate = Aggregate.SUM;
        return this;
    }

    public ZAggregateArgs min() {
        this.aggregate = Aggregate.MIN;
        return this;
    }

    public ZAggregateArgs max() {
        this.aggregate = Aggregate.MAX;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.weights != null && !this.weights.isEmpty()) {
            args.add(CommandKeyword.WEIGHTS);
            for (double weight : this.weights) {
                args.add(weight);
            }
        }
        if (this.aggregate != null) {
            args.add(CommandKeyword.AGGREGATE);
            switch (this.aggregate) {
                case SUM: {
                    args.add(CommandKeyword.SUM);
                    break;
                }
                case MIN: {
                    args.add(CommandKeyword.MIN);
                    break;
                }
                case MAX: {
                    args.add(CommandKeyword.MAX);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Aggregation " + (Object)((Object)this.aggregate) + " not supported");
                }
            }
        }
    }

    public static class Builder {
        Builder() {
        }

        public static ZAggregateArgs weights(double ... weights) {
            return new ZAggregateArgs().weights(weights);
        }

        public static ZAggregateArgs sum() {
            return new ZAggregateArgs().sum();
        }

        public static ZAggregateArgs min() {
            return new ZAggregateArgs().min();
        }

        public static ZAggregateArgs max() {
            return new ZAggregateArgs().max();
        }
    }

    private static enum Aggregate {
        SUM,
        MIN,
        MAX;

    }
}

