/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster;

import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisURI;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.ClusterNodeConnectionFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.PooledClusterConnectionProvider;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.models.partitions.Partitions;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.resource.ClientResources;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Mono;

abstract class AbstractClusterNodeConnectionFactory<K, V>
implements ClusterNodeConnectionFactory<K, V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledClusterConnectionProvider.DefaultClusterNodeConnectionFactory.class);
    private final ClientResources clientResources;
    private volatile Partitions partitions;

    public AbstractClusterNodeConnectionFactory(ClientResources clientResources) {
        this.clientResources = clientResources;
    }

    @Override
    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
    }

    public Partitions getPartitions() {
        return this.partitions;
    }

    Mono<SocketAddress> getSocketAddressSupplier(ClusterNodeConnectionFactory.ConnectionKey connectionKey) {
        return Mono.fromCallable(() -> {
            if (connectionKey.nodeId != null) {
                SocketAddress socketAddress = this.getSocketAddress(connectionKey.nodeId);
                logger.debug("Resolved SocketAddress {} using for Cluster node {}", (Object)socketAddress, (Object)connectionKey.nodeId);
                return socketAddress;
            }
            SocketAddress socketAddress = this.resolve(RedisURI.create(connectionKey.host, connectionKey.port));
            logger.debug("Resolved SocketAddress {} using for Cluster node at {}:{}", new Object[]{socketAddress, connectionKey.host, connectionKey.port});
            return socketAddress;
        });
    }

    private SocketAddress getSocketAddress(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return this.resolve(partition.getUri());
        }
        throw new IllegalArgumentException(String.format("Cannot resolve a RedisClusterNode for nodeId %s", nodeId));
    }

    private SocketAddress resolve(RedisURI redisURI) {
        return this.clientResources.socketAddressResolver().resolve(redisURI);
    }
}

