/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster;

import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ClientOptions;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisChannelWriter;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.DefaultEndpoint;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.RedisCommand;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.resource.ClientResources;

class ClusterNodeEndpoint
extends DefaultEndpoint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClusterNodeEndpoint.class);
    private final RedisChannelWriter clusterChannelWriter;

    public ClusterNodeEndpoint(ClientOptions clientOptions, ClientResources clientResources, RedisChannelWriter clusterChannelWriter) {
        super(clientOptions, clientResources);
        this.clusterChannelWriter = clusterChannelWriter;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        logger.debug("{} closeAsync()", (Object)this.logPrefix());
        if (this.clusterChannelWriter != null) {
            this.retriggerCommands(this.doExclusive(this::drainCommands));
        }
        return super.closeAsync();
    }

    protected void retriggerCommands(Collection<RedisCommand<?, ?, ?>> commands) {
        for (RedisCommand<?, ?, ?> queuedCommand : commands) {
            if (queuedCommand == null || queuedCommand.isCancelled()) continue;
            try {
                this.clusterChannelWriter.write(queuedCommand);
            }
            catch (RedisException e) {
                queuedCommand.completeExceptionally(e);
            }
        }
    }
}

