/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster;

import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ConnectionFuture;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisChannelWriter;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.StatefulRedisConnection;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.AbstractClusterNodeConnectionFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.ClusterEventListener;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.ClusterNodeConnectionFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.PooledClusterConnectionProvider;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.RedisClusterClient;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.models.partitions.Partitions;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.pubsub.RedisClusterPubSubListener;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.pubsub.RedisPubSubAdapter;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.resource.ClientResources;

class ClusterPubSubConnectionProvider<K, V>
extends PooledClusterConnectionProvider<K, V> {
    private final RedisClusterClient redisClusterClient;
    private final RedisCodec<K, V> redisCodec;
    private final RedisClusterPubSubListener<K, V> notifications;

    ClusterPubSubConnectionProvider(RedisClusterClient redisClusterClient, RedisChannelWriter clusterWriter, RedisCodec<K, V> redisCodec, RedisClusterPubSubListener<K, V> notificationTarget, ClusterEventListener clusterEventListener) {
        super(redisClusterClient, clusterWriter, redisCodec, clusterEventListener);
        this.redisClusterClient = redisClusterClient;
        this.redisCodec = redisCodec;
        this.notifications = notificationTarget;
    }

    @Override
    protected ClusterNodeConnectionFactory<K, V> getConnectionFactory(RedisClusterClient redisClusterClient) {
        return new DecoratingClusterNodeConnectionFactory(new PubSubNodeConnectionFactory(redisClusterClient.getResources()));
    }

    class DelegatingRedisClusterPubSubListener
    extends RedisPubSubAdapter<K, V> {
        private final String nodeId;
        private final String host;
        private final int port;

        DelegatingRedisClusterPubSubListener(String nodeId) {
            this.nodeId = nodeId;
            this.host = null;
            this.port = 0;
        }

        DelegatingRedisClusterPubSubListener(String host, int port) {
            this.nodeId = null;
            this.host = host;
            this.port = port;
        }

        @Override
        public void message(K channel, V message) {
            ClusterPubSubConnectionProvider.this.notifications.message(this.getNode(), channel, message);
        }

        @Override
        public void message(K pattern, K channel, V message) {
            ClusterPubSubConnectionProvider.this.notifications.message(this.getNode(), pattern, channel, message);
        }

        @Override
        public void subscribed(K channel, long count) {
            ClusterPubSubConnectionProvider.this.notifications.subscribed(this.getNode(), channel, count);
        }

        @Override
        public void psubscribed(K pattern, long count) {
            ClusterPubSubConnectionProvider.this.notifications.psubscribed(this.getNode(), pattern, count);
        }

        @Override
        public void unsubscribed(K channel, long count) {
            ClusterPubSubConnectionProvider.this.notifications.unsubscribed(this.getNode(), channel, count);
        }

        @Override
        public void punsubscribed(K pattern, long count) {
            ClusterPubSubConnectionProvider.this.notifications.punsubscribed(this.getNode(), pattern, count);
        }

        private RedisClusterNode getNode() {
            return this.nodeId != null ? ClusterPubSubConnectionProvider.this.getPartitions().getPartitionByNodeId(this.nodeId) : ClusterPubSubConnectionProvider.this.getPartitions().getPartition(this.host, this.port);
        }
    }

    class DecoratingClusterNodeConnectionFactory
    implements ClusterNodeConnectionFactory<K, V> {
        private final ClusterNodeConnectionFactory<K, V> delegate;

        DecoratingClusterNodeConnectionFactory(ClusterNodeConnectionFactory<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setPartitions(Partitions partitions) {
            this.delegate.setPartitions(partitions);
        }

        @Override
        public ConnectionFuture<StatefulRedisConnection<K, V>> apply(ClusterNodeConnectionFactory.ConnectionKey key) {
            ConnectionFuture future = (ConnectionFuture)this.delegate.apply(key);
            if (key.nodeId != null) {
                return future.thenApply(connection -> {
                    ((StatefulRedisPubSubConnection)connection).addListener(new DelegatingRedisClusterPubSubListener(key.nodeId));
                    return connection;
                });
            }
            return future.thenApply(connection -> {
                ((StatefulRedisPubSubConnection)connection).addListener(new DelegatingRedisClusterPubSubListener(key.host, key.port));
                return connection;
            });
        }
    }

    class PubSubNodeConnectionFactory
    extends AbstractClusterNodeConnectionFactory<K, V> {
        PubSubNodeConnectionFactory(ClientResources clientResources) {
            super(clientResources);
        }

        @Override
        public ConnectionFuture<StatefulRedisConnection<K, V>> apply(ClusterNodeConnectionFactory.ConnectionKey key) {
            if (key.nodeId != null) {
                return ClusterPubSubConnectionProvider.this.redisClusterClient.connectPubSubToNodeAsync(ClusterPubSubConnectionProvider.this.redisCodec, key.nodeId, this.getSocketAddressSupplier(key));
            }
            return ClusterPubSubConnectionProvider.this.redisClusterClient.connectPubSubToNodeAsync(ClusterPubSubConnectionProvider.this.redisCodec, key.host + ":" + key.port, this.getSocketAddressSupplier(key));
        }
    }
}

