/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.topology;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisURI;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.models.partitions.Partitions;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.topology.NodeTopologyView;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.topology.TopologyComparators;

class NodeTopologyViews {
    private List<NodeTopologyView> views;

    public NodeTopologyViews(List<NodeTopologyView> views) {
        this.views = views;
    }

    public Set<RedisURI> getClusterNodes() {
        HashSet<RedisURI> result = new HashSet<RedisURI>();
        HashMap<String, RedisURI> knownUris = new HashMap<String, RedisURI>();
        for (NodeTopologyView view : this.views) {
            knownUris.put(view.getNodeId(), view.getRedisURI());
        }
        for (NodeTopologyView view : this.views) {
            for (RedisClusterNode redisClusterNode : view.getPartitions()) {
                if (knownUris.containsKey(redisClusterNode.getNodeId())) {
                    result.add((RedisURI)knownUris.get(redisClusterNode.getNodeId()));
                    continue;
                }
                result.add(redisClusterNode.getUri());
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.views.isEmpty();
    }

    public Map<RedisURI, Partitions> toMap() {
        TreeMap<RedisURI, Partitions> nodeSpecificViews = new TreeMap<RedisURI, Partitions>(TopologyComparators.RedisURIComparator.INSTANCE);
        for (NodeTopologyView view : this.views) {
            nodeSpecificViews.put(view.getRedisURI(), view.getPartitions());
        }
        return nodeSpecificViews;
    }
}

